/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.scuba_gear.item;

import com.legacy.scuba_gear.ScubaRegistry;
import com.legacy.scuba_gear.client.ScubaBootsModel;
import com.legacy.scuba_gear.client.ScubaChestplateModel;
import com.legacy.scuba_gear.client.ScubaHelmetModel;
import com.legacy.scuba_gear.client.ScubaLayers;
import com.legacy.scuba_gear.client.ScubaLeggingsModel;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class ScubaGearItem
extends ArmorItem {
    public ScubaGearItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(Rendering.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Rendering
    implements IClientItemExtensions {
        private static final Rendering INSTANCE = new Rendering();
        private final NonNullLazy<ScubaHelmetModel<LivingEntity>> helmet = NonNullLazy.of(() -> new ScubaHelmetModel(Rendering.getModel().m_171103_(ScubaLayers.SCUBA_HELMET)));
        private final NonNullLazy<ScubaChestplateModel<LivingEntity>> chestplate = NonNullLazy.of(() -> new ScubaChestplateModel(Rendering.getModel().m_171103_(ScubaLayers.SCUBA_CHESTPLATE)));
        private final NonNullLazy<ScubaLeggingsModel<LivingEntity>> leggings = NonNullLazy.of(() -> new ScubaLeggingsModel(Rendering.getModel().m_171103_(ScubaLayers.SCUBA_LEGGINGS)));
        private final NonNullLazy<ScubaBootsModel<LivingEntity>> boots = NonNullLazy.of(() -> new ScubaBootsModel(Rendering.getModel().m_171103_(ScubaLayers.SCUBA_BOOTS)));

        private Rendering() {
        }

        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity wearer, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
            Item item = stack.m_41720_();
            return item == ScubaRegistry.SCUBA_CHESTPLATE.get() ? (HumanoidModel)this.chestplate.get() : (item == ScubaRegistry.SCUBA_LEGGINGS.get() ? (HumanoidModel)this.leggings.get() : (item == ScubaRegistry.SCUBA_BOOTS.get() ? (HumanoidModel)this.boots.get() : (HumanoidModel)this.helmet.get()));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static EntityModelSet getModel() {
            return Minecraft.m_91087_().m_167973_();
        }
    }
}

