/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.util;

import com.cerbon.myths_of_the_sea.entity.MTSEntityAttributes;
import com.cerbon.myths_of_the_sea.item.custom.bunyip_claw.BaseBunyipClawItem;
import com.cerbon.myths_of_the_sea.util.forge.MTSUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class MTSUtils {
    public static boolean isUsingFullArmorSet(ArmorMaterial material, Player player) {
        return player.m_150109_().f_35975_.stream().allMatch(armorStack -> {
            ArmorItem armorItem;
            Item patt0$temp = armorStack.m_41720_();
            return patt0$temp instanceof ArmorItem && (armorItem = (ArmorItem)patt0$temp).m_40401_() == material;
        });
    }

    public static void pounceAtTarget(LivingEntity attacker, LivingEntity target, float horizontalStrength, float upwardStrength) {
        double dz;
        double dx = target.m_20185_() - attacker.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = target.m_20189_() - attacker.m_20189_()) * dz);
        if (distance > 1.0E-4) {
            double vx = dx / distance * (double)horizontalStrength;
            double vz = dz / distance * (double)horizontalStrength;
            attacker.m_20334_(vx, (double)upwardStrength, vz);
            attacker.f_19812_ = true;
        }
    }

    public static void breakShip(LivingEntity attacker, ServerLevel serverLevel, int radius) {
        if (MTSUtils.isModLoaded("valkyrienskies") && serverLevel.m_46469_().m_46207_(GameRules.f_46132_)) {
            BlockPos center = attacker.m_20097_();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = center.m_7918_(x, y, z);
                        if (VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos) == null || serverLevel.m_46859_(pos)) continue;
                        serverLevel.m_46961_(pos, true);
                    }
                }
            }
        }
    }

    public static float smoothAngle(float current, float target, float maxChange) {
        float delta = Mth.m_14177_((float)(target - current));
        delta = Mth.m_14036_((float)delta, (float)(-maxChange), (float)maxChange);
        return current + delta;
    }

    public static int getWaterSpeedAmount(LivingEntity entity) {
        int waterSpeed = 0;
        for (ItemStack stack : entity.m_6168_()) {
            ArmorItem armor;
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem) || !(armor = (ArmorItem)item).m_7167_(armor.m_40402_()).containsKey(MTSEntityAttributes.WATER_SPEED.get())) continue;
            AttributeModifier modifier = (AttributeModifier)armor.m_7167_(armor.m_40402_()).get((Object)((Attribute)MTSEntityAttributes.WATER_SPEED.get())).iterator().next();
            if (!entity.m_20069_()) continue;
            waterSpeed += (int)modifier.m_22218_();
        }
        return waterSpeed;
    }

    public static boolean hasDualwieldWeapon(LivingEntity entity) {
        return entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BaseBunyipClawItem && entity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BaseBunyipClawItem;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return MTSUtilsImpl.isModLoaded(modId);
    }
}

