/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.util;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GeoControllersUtil {
    public static final RawAnimation DIE_ANIM = RawAnimation.begin().thenPlayAndHold("death");
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation MOVE_ANIM = RawAnimation.begin().thenLoop("move");

    public static <E extends Mob> PlayState commonWaterAnimalDie(AnimationState<E> state, Mob mob) {
        if (((Mob)state.getAnimatable()).m_21224_() && mob.m_20069_()) {
            return state.setAndContinue(DIE_ANIM);
        }
        return PlayState.STOP;
    }

    public static <E extends Mob> PlayState commonMoveController(AnimationState<E> state, Mob mob) {
        if (mob.f_20911_) {
            return PlayState.STOP;
        }
        if (!state.isMoving()) {
            return state.setAndContinue(IDLE_ANIM);
        }
        if (state.isMoving()) {
            return state.setAndContinue(MOVE_ANIM);
        }
        return PlayState.STOP;
    }

    public static boolean isMoving(LivingEntity entity, float motionThreshold) {
        float limbSwingAmount = 0.0f;
        if (entity.m_6084_() && (limbSwingAmount = entity.f_267362_.m_267711_((float)entity.f_19797_)) > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        Vec3 velocity = entity.m_20184_();
        float avgVelocity = (float)((Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0);
        return avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
    }
}

