/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.item.custom;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTSSpawnEggItem
extends SpawnEggItem {
    private static final List<MTSSpawnEggItem> MTS_EGGS = new ArrayList<MTSSpawnEggItem>();
    private static final Map<EntityType<? extends Mob>, MTSSpawnEggItem> TYPE_MAP = new IdentityHashMap<EntityType<? extends Mob>, MTSSpawnEggItem>();
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        try {
            type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(face), MobSpawnType.DISPENSER, face != Direction.UP, false);
        }
        catch (Exception exception) {
            DispenseItemBehavior.f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)exception);
            return ItemStack.f_41583_;
        }
        stack.m_41774_(1);
        source.m_7727_().m_220407_(GameEvent.f_157810_, source.m_7961_(), GameEvent.Context.m_223722_((BlockState)source.m_6414_()));
        return stack;
    };

    public MTSSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(null, backgroundColor, highlightColor, properties);
        this.typeSupplier = type;
        MTS_EGGS.add(this);
    }

    @NotNull
    public EntityType<?> m_43228_(@Nullable CompoundTag tag) {
        EntityType<? extends Mob> type = super.m_43228_(tag);
        return type != null ? type : this.typeSupplier.get();
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Nullable
    public static SpawnEggItem fromEntityType(@Nullable EntityType<?> type) {
        SpawnEggItem ret = TYPE_MAP.get(type);
        return ret != null ? ret : SpawnEggItem.m_43213_(type);
    }

    @NotNull
    public FeatureFlagSet m_245183_() {
        return this.typeSupplier.get().m_245183_();
    }

    protected EntityType<?> getDefaultType() {
        return this.typeSupplier.get();
    }

    public static void registerSpawnEggsDispenserBehaviour() {
        MTS_EGGS.forEach(egg -> {
            DispenseItemBehavior dispenseBehavior = egg.createDispenseBehavior();
            if (dispenseBehavior != null) {
                DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)dispenseBehavior);
            }
            TYPE_MAP.put(egg.typeSupplier.get(), (MTSSpawnEggItem)((Object)egg));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerSpawnEggsColors(ItemColors itemColors) {
        MTS_EGGS.forEach(egg -> itemColors.m_92689_((stack, layer) -> egg.m_43211_(layer), new ItemLike[]{egg}));
    }
}

