/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.forge.datagen.providers;

import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.myths_of_the_sea.entity.MTSEntities;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.potion.MTSPotions;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.common.data.LanguageProvider;

public class MTSLanguageProvider
extends LanguageProvider {
    public MTSLanguageProvider(PackOutput output) {
        super(output, "myths_of_the_sea", "en_us");
    }

    protected void addTranslations() {
        MTSItems.ITEMS.getEntries().forEach(this::addItemTranslation);
        MTSEntities.ENTITY_TYPES.getEntries().forEach(this::addEntityTranslation);
        this.addPotionTranslation((Potion)MTSPotions.VERY_LONG_NIGHT_VISION.get(), "Night Vision");
        this.add("itemGroup.myths_of_the_sea", "Myths of The Sea");
        this.add("attribute.name.water_speed", "Depth Strider");
        this.add("item.minecraft.tipped_arrow.effect.very_long_night_vision", "Arrow of Night Vision");
        this.add("item.myths_of_the_sea.bunyip_claw.tooltip", "+2 Attack Damage when dual wielding");
        this.addSubtitleTranslation(MTSSounds.ABAIA_IDLE, "Abaia groans");
        this.addSubtitleTranslation(MTSSounds.ABAIA_ATTACK, "Abaia attacks");
        this.addSubtitleTranslation(MTSSounds.ABAIA_DAMAGE, "Abaia hurts");
        this.addSubtitleTranslation(MTSSounds.ABAIA_MOVEMENT, "Abaia swims");
        this.addSubtitleTranslation(MTSSounds.ABAIA_DEATH, "Abaia dies");
        this.addSubtitleTranslation(MTSSounds.ABAIA_FLOP, "Abaia flops");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_IDLE, "Bake Kujira groans");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_ATTACK, "Bake Kujira attacks");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_DAMAGE, "Bake Kujira hurts");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_MOVEMENT, "Bake Kujira swims");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_DEATH, "Bake Kujira dies");
        this.addSubtitleTranslation(MTSSounds.BAKE_KUJIRA_FLOP, "Bake Kujira flops");
        this.addSubtitleTranslation(MTSSounds.LEVIATHAN_IDLE, "Leviathan roars");
        this.addSubtitleTranslation(MTSSounds.LEVIATHAN_ATTACK, "Leviathan attacks");
        this.addSubtitleTranslation(MTSSounds.LEVIATHAN_DAMAGE, "Leviathan hurts");
        this.addSubtitleTranslation(MTSSounds.LEVIATHAN_MOVEMENT, "Leviathan swims");
        this.addSubtitleTranslation(MTSSounds.LEVIATHAN_DEATH, "Leviathan dies");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_IDLE, "Hippocampus neighs");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_ATTACK, "Leviathan attacks");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_DAMAGE, "Hippocampus hurts");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_MOVEMENT, "Hippocampus swims");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_DEATH, "Hippocampus dies");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_FLOP, "Hippocampus flops");
        this.addSubtitleTranslation(MTSSounds.HIPPOCAMPUS_EAT, "Hippocampus eats");
        this.addSubtitleTranslation(MTSSounds.BUNYIP_IDLE, "Bunyip groans");
        this.addSubtitleTranslation(MTSSounds.BUNYIP_ATTACK, "Bunyip attacks");
        this.addSubtitleTranslation(MTSSounds.BUNYIP_DAMAGE, "Bunyip hurts");
        this.addSubtitleTranslation(MTSSounds.BUNYIP_MOVEMENT, "Footsteps");
        this.addSubtitleTranslation(MTSSounds.BUNYIP_DEATH, "Bunyip dies");
        this.addSubtitleTranslation(MTSSounds.KRAKEN_IDLE, "Kraken rumbles");
        this.addSubtitleTranslation(MTSSounds.KRAKEN_ATTACK, "Kraken attacks");
        this.addSubtitleTranslation(MTSSounds.KRAKEN_DAMAGE, "Kraken hurts");
        this.addSubtitleTranslation(MTSSounds.KRAKEN_MOVEMENT, "Kraken swims");
        this.addSubtitleTranslation(MTSSounds.KRAKEN_DEATH, "Kraken dies");
    }

    private void addItemTranslation(RegistryEntry<Item> item) {
        String path = item.getId().m_135815_();
        String translation = this.translate(path);
        this.add((Item)item.get(), translation);
    }

    private void addEntityTranslation(RegistryEntry<EntityType<?>> entity) {
        String path = entity.getId().m_135815_();
        String translation = this.translate(path);
        this.add((EntityType)entity.get(), translation);
    }

    private void addSubtitleTranslation(RegistryEntry<SoundEvent> sound, String translation) {
        String path = sound.getId().m_135815_();
        String subtitle = "subtitles.myths_of_the_sea." + path;
        this.add(subtitle, translation);
    }

    private String translate(String path) {
        return Arrays.stream(path.split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    private void addPotionTranslation(Potion potion, String baseName) {
        String path = BuiltInRegistries.f_256980_.m_7981_((Object)potion).m_135815_();
        this.add("item.minecraft.potion.effect." + path, "Potion of " + baseName);
        this.add("item.minecraft.splash_potion.effect." + path, "Splash Potion of " + baseName);
        this.add("item.minecraft.lingering_potion.effect." + path, "Lingering Potion of " + baseName);
    }
}

