/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.leviathan;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.entity.EntityBounds;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.MTSConfig;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanHitboxes;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanMoveControl;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanRotationControl;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanFleeFromTarget;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanMeleeAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanNearestAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.util.BreachingWaterBoundPathNavigation;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeviathanEntity
extends WaterAnimal
implements GeoEntity,
MultipartAwareEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final LeviathanHitboxes hitboxManager = new LeviathanHitboxes(this);
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE);
    private static final int ATTACK_ANIM_TIME = 21;
    @Nullable
    private UUID lastPreyUUID;
    @Nullable
    private Entity lastPrey;
    public boolean hasAttackedOnWater;
    public int cooldownSwimmingAttackTicks;
    public static final EntityDataAccessor<Vector3f> BODY_ROT_2 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_3 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_4 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_5 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_6 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_7 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Vector3f> BODY_ROT_8 = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    public static final EntityDataAccessor<Float> CLIENT_SIDE_TAIL_ANIMATION = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> CLIENT_SIDE_TAIL_ANIMATION_O = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> CLIENT_SIDE_TAIL_ANIMATION_SPEED = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public LeviathanEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 50;
        this.f_21342_ = new LeviathanMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_19811_ = true;
        this.setClientSideTailAnimation(this.f_19796_.m_188501_());
        this.setClientSideTailAnimationO(this.getClientSideTailAnimation());
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 1.5).m_22268_(Attributes.f_22277_, 96.0).m_22265_();
    }

    public static boolean surfaceWaterSpawnRulesAndNotNearLeviathan(EntityType<? extends WaterAnimal> waterAnimal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean raining = level.m_6106_().m_6533_();
        boolean thundering = level.m_6106_().m_6534_();
        long time = level.m_6106_().m_6792_() % 24000L;
        boolean night = time >= 13000L && time < 23000L;
        int radiusToSearchLeviathan = MTSConfig.leviathanNormalSpawnSeparationRadius();
        if (thundering) {
            radiusToSearchLeviathan = MTSConfig.leviathanThunderSpawnSeparationRadius();
        } else if (raining) {
            radiusToSearchLeviathan = MTSConfig.leviathanRainSpawnSeparationRadius();
        } else if (night) {
            radiusToSearchLeviathan = MTSConfig.leviathanNightSpawnSeparationRadius();
        }
        double willCancell = MTSConfig.leviathanNormalSpawnProbability();
        if (thundering) {
            willCancell = MTSConfig.leviathanThunderSpawnProbability();
        } else if (raining) {
            willCancell = MTSConfig.leviathanRainSpawnProbability();
        } else if (night) {
            willCancell = MTSConfig.leviathanNightSpawnProbability();
        }
        if ((double)random.m_216332_(0, 100) > willCancell) {
            return false;
        }
        int i = level.m_5736_();
        int j = i - 13;
        return pos.m_123342_() >= j && pos.m_123342_() <= i && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && level.m_6443_(LeviathanEntity.class, new AABB((double)(pos.m_123341_() - radiusToSearchLeviathan), (double)(pos.m_123342_() - radiusToSearchLeviathan), (double)(pos.m_123343_() - radiusToSearchLeviathan), (double)(pos.m_123341_() + radiusToSearchLeviathan), (double)(pos.m_123342_() + radiusToSearchLeviathan), (double)(pos.m_123343_() + radiusToSearchLeviathan)), leviathan -> true).isEmpty();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new LeviathanFleeFromTarget(this, 2.0, 1));
        this.f_21345_.m_25352_(1, (Goal)new LeviathanMeleeAttackGoal(this, 2.0, true, 100));
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 200));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(0, new LeviathanNearestAttackGoal<Player>(this, Player.class, 10, false, false, entity -> this.getLastPrey() != null && entity.m_7306_(this.getLastPrey()) && entity.m_20069_()));
        this.f_21346_.m_25352_(1, new LeviathanNearestAttackGoal<Player>(this, Player.class, 10, false, false, Entity::m_20069_));
        this.f_21346_.m_25352_(2, new LeviathanNearestAttackGoal<Villager>(this, Villager.class, 10, false, false, Entity::m_20069_));
    }

    public void setLastPreyUUID(@Nullable UUID lastPreyUUID) {
        this.lastPreyUUID = lastPreyUUID;
    }

    @Nullable
    public UUID getLastPreyUUID() {
        return this.lastPreyUUID;
    }

    @Nullable
    public Entity getLastPrey() {
        return this.lastPrey;
    }

    public void setLastPrey(@Nullable Entity lastPrey) {
        this.lastPrey = lastPrey;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getLastPreyUUID() != null) {
            compound.m_128362_("LastPrey", this.getLastPreyUUID());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_9236_() instanceof ServerLevel) {
            if (!compound.m_128403_("LastPrey")) {
                this.setLastPreyUUID(null);
            } else {
                UUID uUID = compound.m_128342_("LastPrey");
                this.setLastPreyUUID(uUID);
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uUID);
                if (entity != null) {
                    this.setLastPrey(entity);
                }
            }
        }
    }

    public boolean isSeeingTarget(LivingEntity target) {
        Vec3 vec3d = target.m_20182_();
        Vec3 vec3d2 = this.m_20171_(0.0f, this.m_6080_());
        Vec3 vec3d3 = vec3d.m_82505_(this.m_20182_());
        vec3d3 = new Vec3(vec3d3.f_82479_, 0.0, vec3d3.f_82481_).m_82541_();
        return vec3d3.m_82526_(vec3d2) < -0.9;
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return super.m_6779_(target) && target.m_20069_() && !this.hasAttackedOnWater;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.f_20911_ && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(ATTACK_ANIM);
                CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                    this.f_20911_ = false;
                }, 21));
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> {
            if (this.f_20911_) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                return state.setAndContinue(GeoControllersUtil.IDLE_ANIM);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (Mob)this))});
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new BreachingWaterBoundPathNavigation((Mob)this, level);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public int m_21529_() {
        return 1;
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.008, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        }
        if (this.m_20096_() && !this.m_20069_() && !this.m_21224_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.8, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_6853_(false);
            this.f_19812_ = true;
        }
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return super.m_5639_(fallDistance, damageMultiplier) - 10;
    }

    public EntityBounds getBounds() {
        return this.hitboxManager.getHitbox();
    }

    public void onSetPos(double x, double y, double z) {
        if (this.hitboxManager != null) {
            this.hitboxManager.updatePosition();
        }
    }

    public void setNextDamagedPart(@Nullable String part) {
    }

    public CompoundOrientedBox getCompoundBoundingBox(AABB bounds) {
        return this.hitboxManager.getHitbox().getBox(bounds);
    }

    public boolean m_7327_(@NotNull Entity target) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundUtils.playSound((ServerLevel)serverLevel, (Vec3)this.m_20182_(), (SoundEvent)((SoundEvent)MTSSounds.LEVIATHAN_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)6.0);
        }
        return super.m_7327_(target);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MTSSounds.LEVIATHAN_IDLE.get();
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return (SoundEvent)MTSSounds.LEVIATHAN_MOVEMENT.get();
    }

    protected void m_5625_(float volume) {
        float f = (float)this.m_20184_().m_165924_();
        if (f >= 0.01f) {
            super.m_5625_(Mth.m_14179_((float)Mth.m_14036_((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f));
        }
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)MTSSounds.LEVIATHAN_DAMAGE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MTSSounds.LEVIATHAN_DEATH.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new LeviathanRotationControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BODY_ROT_2, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_3, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_4, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_5, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_6, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_7, (Object)new Vector3f());
        this.m_20088_().m_135372_(BODY_ROT_8, (Object)new Vector3f());
        this.m_20088_().m_135372_(CLIENT_SIDE_TAIL_ANIMATION, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(CLIENT_SIDE_TAIL_ANIMATION_O, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(CLIENT_SIDE_TAIL_ANIMATION_SPEED, (Object)Float.valueOf(0.0f));
    }

    public float getYRot2() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_2)).y;
    }

    public float getYRot3() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_3)).y;
    }

    public float getYRot4() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_4)).y;
    }

    public float getYRot5() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_5)).y;
    }

    public float getYRot6() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_6)).y;
    }

    public float getYRot7() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_7)).y;
    }

    public float getYRot8() {
        return ((Vector3f)this.f_19804_.m_135370_(LeviathanEntity.BODY_ROT_8)).y;
    }

    public void setYRot2(float YRot2) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_2);
        this.f_19804_.m_135381_(BODY_ROT_2, (Object)new Vector3f(actualVector.x, YRot2, actualVector.z));
    }

    public void setYRot3(float YRot3) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_3);
        this.f_19804_.m_135381_(BODY_ROT_3, (Object)new Vector3f(actualVector.x, YRot3, actualVector.z));
    }

    public void setYRot4(float YRot4) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_4);
        this.f_19804_.m_135381_(BODY_ROT_4, (Object)new Vector3f(actualVector.x, YRot4, actualVector.z));
    }

    public void setYRot5(float YRot5) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_5);
        this.f_19804_.m_135381_(BODY_ROT_5, (Object)new Vector3f(actualVector.x, YRot5, actualVector.z));
    }

    public void setYRot6(float YRot6) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_6);
        this.f_19804_.m_135381_(BODY_ROT_6, (Object)new Vector3f(actualVector.x, YRot6, actualVector.z));
    }

    public void setYRot7(float YRot7) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_7);
        this.f_19804_.m_135381_(BODY_ROT_7, (Object)new Vector3f(actualVector.x, YRot7, actualVector.z));
    }

    public void setYRot8(float YRot8) {
        Vector3f actualVector = (Vector3f)this.f_19804_.m_135370_(BODY_ROT_8);
        this.f_19804_.m_135381_(BODY_ROT_8, (Object)new Vector3f(actualVector.x, YRot8, actualVector.z));
    }

    public float getClientSideTailAnimation() {
        return ((Float)this.f_19804_.m_135370_(CLIENT_SIDE_TAIL_ANIMATION)).floatValue();
    }

    public float getClientSideTailAnimationO() {
        return ((Float)this.f_19804_.m_135370_(CLIENT_SIDE_TAIL_ANIMATION_O)).floatValue();
    }

    public float getClientSideTailAnimationSpeed() {
        return ((Float)this.f_19804_.m_135370_(CLIENT_SIDE_TAIL_ANIMATION_SPEED)).floatValue();
    }

    public void setClientSideTailAnimation(float clientSideTailAnimation) {
        this.f_19804_.m_135381_(CLIENT_SIDE_TAIL_ANIMATION, (Object)Float.valueOf(clientSideTailAnimation));
    }

    public void setClientSideTailAnimationO(float clientSideTailAnimationO) {
        this.f_19804_.m_135381_(CLIENT_SIDE_TAIL_ANIMATION_O, (Object)Float.valueOf(clientSideTailAnimationO));
    }

    public void setClientSideTailAnimationSpeed(float clientSideTailAnimationSpeed) {
        this.f_19804_.m_135381_(CLIENT_SIDE_TAIL_ANIMATION_SPEED, (Object)Float.valueOf(clientSideTailAnimationSpeed));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.setClientSideTailAnimationO(this.getClientSideTailAnimation());
        if (this.m_20184_().m_82553_() != 0.0) {
            float updatedSpeed = this.getClientSideTailAnimationSpeed() + (0.05f - this.getClientSideTailAnimationSpeed()) * 0.1f;
            this.setClientSideTailAnimationSpeed(updatedSpeed);
        } else {
            float updatedSpeed = this.getClientSideTailAnimationSpeed() + (0.025f - this.getClientSideTailAnimationSpeed()) * 0.2f;
            this.setClientSideTailAnimationSpeed(updatedSpeed);
        }
        this.setClientSideTailAnimation(this.getClientSideTailAnimation() + this.getClientSideTailAnimationSpeed());
    }

    public float getTailAnimation(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.getClientSideTailAnimationO(), (float)this.getClientSideTailAnimation());
    }

    protected void m_6153_() {
        CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> super.m_6153_(), 80));
    }

    public int m_6062_() {
        return 6000;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 0.85f;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)MTSItems.LEVIATHAN_SPAWN_EGG.get());
    }
}

