/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.hippocampus;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.myths_of_the_sea.entity.MTSEntities;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.AbstractWaterHorse;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.PlayWithItemsGoal;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.TemptGoalNoMounted;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.TemptGoalTamed;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HippocampusEntity
extends AbstractWaterHorse
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HippocampusEntity(EntityType<? extends AbstractWaterHorse> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
        this.m_274367_(0.6f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, HippocampusEntity.class));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoalNoMounted((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_}), false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoalTamed(this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42530_, Items.f_42531_}), false));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new PlayWithItemsGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 8.0f, 1.0, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guardian.class}).m_26044_(new Class[0]));
    }

    public boolean m_21515_() {
        return super.m_21515_() && !this.m_21224_();
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22288_, 0.0).m_22265_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> GeoControllersUtil.commonMoveController(state, (Mob)this))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (Mob)this))});
    }

    protected void m_6153_() {
        CapabilityUtils.getLevelEventScheduler((Level)this.m_9236_()).addEvent((IEvent)new TimedEvent(() -> super.m_6153_(), 40));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_IDLE.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_MOVEMENT.get();
    }

    protected void m_5625_(float volume) {
        float f = (float)this.m_20184_().m_165924_();
        if (f >= 0.01f) {
            super.m_5625_(Mth.m_14179_((float)Mth.m_14036_((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f));
        }
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_DAMAGE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_DEATH.get();
    }

    public SoundEvent getFlopSound() {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_FLOP.get();
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return (SoundEvent)MTSSounds.HIPPOCAMPUS_EAT.get();
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_() && !this.m_217005_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else if (this.m_20069_() && this.m_217005_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            super.m_7023_(travelVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_6835_(@NotNull Player player) {
        this.m_146926_(0.0f);
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    protected void m_274498_(@NotNull Player player, @NotNull Vec3 travelVector) {
        Vec2 vec2 = this.m_274391_((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        if (this.m_6109_()) {
            this.controlHippocampus(travelVector);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void controlHippocampus(Vec3 travelVector) {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player rider = (Player)livingEntity;
            if (travelVector.f_82481_ > 0.0) {
                float pitch = rider.m_146909_();
                float yaw = rider.m_146908_();
                float fYaw = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
                float fPitchY = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float fYawCos = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
                float fPitchCos = Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                double speed = this.m_20069_() ? 0.8 : 0.001;
                Vec3 direction = new Vec3((double)(fYaw * fPitchCos), (double)fPitchY, (double)(fYawCos * fPitchCos)).m_82541_().m_82490_(speed);
                if (!this.m_20069_()) {
                    direction = new Vec3(direction.f_82479_, this.m_20184_().f_82480_ - 0.05, direction.f_82481_);
                }
                this.m_20256_(direction);
                return;
            }
        }
        if (!this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ - 0.05, motion.f_82481_);
            return;
        }
        this.m_20256_(Vec3.f_82478_);
    }

    public boolean m_7132_() {
        return false;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player player, @NotNull Vec3 travelVector) {
        if (this.m_20069_() || this.m_20096_()) {
            float f = player.f_20900_ * 0.5f;
            float g = player.f_20902_;
            if (g <= 0.0f) {
                g *= 0.25f;
            }
            return new Vec3((double)f, 0.0, (double)g);
        }
        return Vec3.f_82478_;
    }

    protected float m_245547_(@NotNull Player player) {
        return this.m_20069_() ? (float)this.m_21133_(Attributes.f_22279_) : 0.1f;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.6;
    }

    protected void m_19956_(@NotNull Entity passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float yawRad = this.f_20883_ * ((float)Math.PI / 180);
        float sinYaw = Mth.m_14031_((float)yawRad);
        float cosYaw = Mth.m_14089_((float)yawRad);
        float pitchRad = this.m_146909_() * ((float)Math.PI / 180);
        float pitchOffset = (float)Mth.m_14008_((double)(Mth.m_14031_((float)pitchRad) * 1.2f), (double)-0.9, (double)1.0);
        double verticalPitchOffset = Mth.m_14008_((double)((double)Mth.m_14031_((float)pitchRad) * 1.0), (double)-0.6, (double)-0.4);
        double offsetX = -sinYaw * pitchOffset;
        double offsetZ = cosYaw * pitchOffset;
        callback.m_20372_(passenger, this.m_20185_() + (double)sinYaw * (verticalPitchOffset <= -0.5 ? 0.3 : 0.4) + offsetX, this.m_20186_() + this.m_6048_() + passenger.m_6049_() + verticalPitchOffset + (verticalPitchOffset < 1.0 && verticalPitchOffset > -1.0 ? 0.15 : 0.0), this.m_20189_() - (double)cosYaw * (verticalPitchOffset <= -0.5 ? 0.3 : 0.4) + offsetZ);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        }
        if (this.m_20096_() && !this.m_20069_() && !this.m_21224_() && !this.m_20160_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
    }

    public void m_213583_(@NotNull Player player) {
        if (!this.m_9236_().f_46443_) {
            player.m_6658_((AbstractHorse)this, (Container)this.f_30520_);
        }
    }

    @NotNull
    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, 0.0);
    }

    public int m_6062_() {
        return 400;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.75f;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        if (this.m_20160_()) {
            return super.m_6071_(player, hand);
        }
        if (this.m_6898_(stackInHand) || this.isMatingFood(stackInHand)) {
            return this.m_30580_(player, stackInHand);
        }
        if (this.m_30614_() && player.m_36341_()) {
            this.m_213583_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_30614_()) {
            InteractionResult interactionResult;
            if (!stackInHand.m_41619_() && (interactionResult = stackInHand.m_41647_(player, (LivingEntity)this, hand)).m_19077_()) {
                return interactionResult;
            }
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HippocampusEntity getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return (HippocampusEntity)((EntityType)MTSEntities.HIPPOCAMPUS.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(MTSItems.HIPPOCAMPUS_FOOD);
    }

    private boolean isMatingFood(ItemStack stack) {
        return stack.m_204117_(MTSItems.HIPPOCAMPUS_FOOD_MATING);
    }

    protected boolean m_5994_(@NotNull Player player, @NotNull ItemStack stack) {
        if (this.m_6898_(stack) || this.isMatingFood(stack)) {
            if (!(this.m_30614_() || this.isMatingFood(stack) || this.m_6162_())) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_30637_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.m_30614_()) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(stack.m_41720_().m_41473_() != null ? (float)stack.m_41720_().m_41473_().m_38744_() : 1.0f);
                    return this.playEatingSound();
                }
                if (this.m_146764_() == 0 && this.m_5957_() && this.isMatingFood(stack)) {
                    this.m_27595_(player);
                    return this.playEatingSound();
                }
            }
            if (this.m_6162_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                if (!this.m_9236_().f_46443_) {
                    this.m_146758_(this.m_6898_(stack) ? 10 : 20);
                }
                return this.playEatingSound();
            }
        }
        return false;
    }

    protected boolean playEatingSound() {
        SoundEvent soundEvent;
        if (!this.m_20067_() && (soundEvent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7848_(@NotNull Animal otherAnimal) {
        if (!(otherAnimal instanceof HippocampusEntity)) return false;
        HippocampusEntity camel = (HippocampusEntity)otherAnimal;
        if (!this.m_30628_()) return false;
        if (!camel.m_30628_()) return false;
        return true;
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @NotNull DamageSource source) {
        int i = this.m_5639_(fallDistance, multiplier);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(source, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(source, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    public boolean m_7559_() {
        return false;
    }

    public boolean m_7066_(@NotNull ItemStack stack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)stack);
        return this.m_6844_(equipmentSlot).m_41619_() && equipmentSlot == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    protected void m_7581_(@NotNull ItemEntity itemEntity) {
        ItemStack itemStack;
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && this.m_7252_(itemStack = itemEntity.m_32055_())) {
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
            this.m_21508_(EquipmentSlot.MAINHAND);
            this.m_7938_((Entity)itemEntity, itemStack.m_41613_());
            itemEntity.m_146870_();
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)MTSItems.HIPPOCAMPUS_SPAWN_EGG.get());
    }
}

