/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.abaia.goal;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.util.MTSUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AbaiaMeleeAttackGoal
extends MeleeAttackGoal {
    private boolean soundTriggered = false;
    private final SoundEvent attackSound;
    private final int attackDelay;
    private final int soundDelay;

    public AbaiaMeleeAttackGoal(PathfinderMob pathfinderMob, double d, boolean bl, SoundEvent attackSound, int attackDelay, int soundDelay) {
        super(pathfinderMob, d, bl);
        this.attackSound = attackSound;
        this.attackDelay = attackDelay;
        this.soundDelay = soundDelay;
    }

    protected void m_6739_(@NotNull LivingEntity enemy, double distToEnemySqr) {
        double d = this.m_6639_(enemy);
        if (distToEnemySqr <= d && this.m_25565_() <= 0) {
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            if (!this.soundTriggered) {
                CapabilityUtils.getLevelEventScheduler((Level)this.f_25540_.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                    Level patt0$temp = this.f_25540_.m_9236_();
                    if (patt0$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt0$temp;
                        SoundUtils.playSound((ServerLevel)serverLevel, (Vec3)this.f_25540_.m_20182_(), (SoundEvent)this.attackSound, (SoundSource)SoundSource.HOSTILE, (float)3.0f, (double)6.0);
                    }
                    this.soundTriggered = true;
                }, this.soundDelay, () -> this.f_25540_.m_21224_() || this.soundTriggered || this.m_25565_() > 0));
            }
            CapabilityUtils.getLevelEventScheduler((Level)this.f_25540_.m_9236_()).addEvent((IEvent)new TimedEvent(() -> {
                MTSUtils.pounceAtTarget((LivingEntity)this.f_25540_, enemy, 0.55f, 0.1f);
                double newDistToEnemySqr = this.f_25540_.m_262793_(enemy);
                double d1 = this.m_6639_(enemy);
                if (newDistToEnemySqr <= d1 && this.m_25565_() <= 0) {
                    this.m_25563_();
                    this.f_25540_.m_7327_((Entity)enemy);
                }
                this.soundTriggered = false;
            }, this.attackDelay, () -> ((PathfinderMob)this.f_25540_).m_21224_()));
        }
    }

    protected double m_6639_(@NotNull LivingEntity attackTarget) {
        PathfinderMob pathfinderMob = this.f_25540_;
        if (!(pathfinderMob instanceof MultipartAwareEntity)) {
            return super.m_6639_(attackTarget);
        }
        MultipartAwareEntity thisMob = (MultipartAwareEntity)pathfinderMob;
        CompoundOrientedBox compound = thisMob.getCompoundBoundingBox(this.f_25540_.m_20191_());
        double definitiveMaxSize = 0.0;
        for (OrientedBox orientedBox : compound) {
            AABB extents = orientedBox.getExtents();
            double xSize = extents.f_82291_ - extents.f_82288_;
            double zSize = extents.f_82293_ - extents.f_82290_;
            double maxSize = Math.max(xSize, zSize);
            definitiveMaxSize = Math.max(maxSize, definitiveMaxSize);
        }
        return definitiveMaxSize * (double)2.35f + (double)attackTarget.m_20205_() + 0.5;
    }
}

