/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.setup;

import com.google.common.collect.ArrayListMultimap;
import com.mystic.atlantis.AtlantisDimensionalEffect;
import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.blocks.blockentities.plants.GeneralPlantBlockEntity;
import com.mystic.atlantis.blocks.blockentities.renderers.GeneralPlantRenderer;
import com.mystic.atlantis.blocks.blockentities.renderers.SodiumBombRenderer;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import com.mystic.atlantis.entities.AquaielJellyfishEntity;
import com.mystic.atlantis.entities.GlittertailShrimpEntity;
import com.mystic.atlantis.entities.RubyclawCrabEntity;
import com.mystic.atlantis.entities.StarfishEntity;
import com.mystic.atlantis.entities.ThalassianSeahorseEntity;
import com.mystic.atlantis.entities.ZombieStarfishEntity;
import com.mystic.atlantis.entities.models.AquaielJellyfishEntityModel;
import com.mystic.atlantis.entities.models.CoconutCrabEntityModel;
import com.mystic.atlantis.entities.models.GlittertailShrimpEntityModel;
import com.mystic.atlantis.entities.models.LeviathanEntityModel;
import com.mystic.atlantis.entities.models.RubyclawCrabEntityModel;
import com.mystic.atlantis.entities.models.StarfishEntityModel;
import com.mystic.atlantis.entities.models.ThalassianSeahorseEntityModel;
import com.mystic.atlantis.entities.models.ZombieStarfishEntityModel;
import com.mystic.atlantis.entities.renders.AquaielJellyfishEntityRenderer;
import com.mystic.atlantis.entities.renders.CoconutCrabEntityRenderer;
import com.mystic.atlantis.entities.renders.GlittertailShrimpEntityRenderer;
import com.mystic.atlantis.entities.renders.LeviathanEntityRenderer;
import com.mystic.atlantis.entities.renders.NymphBoatRenderer;
import com.mystic.atlantis.entities.renders.PalmBoatRenderer;
import com.mystic.atlantis.entities.renders.RubyclawCrabEntityRenderer;
import com.mystic.atlantis.entities.renders.StarfishEntityRenderer;
import com.mystic.atlantis.entities.renders.SubmarineEntityRenderer;
import com.mystic.atlantis.entities.renders.ThalassianSeahorseEntityRenderer;
import com.mystic.atlantis.entities.renders.ZombieStarfishEntityRenderer;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.BlockEntityInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.particles.ModParticleTypes;
import com.mystic.atlantis.particles.PushBubbleStreamParticleDown;
import com.mystic.atlantis.particles.PushBubbleStreamParticleEast;
import com.mystic.atlantis.particles.PushBubbleStreamParticleNorth;
import com.mystic.atlantis.particles.PushBubbleStreamParticleSouth;
import com.mystic.atlantis.particles.PushBubbleStreamParticleUp;
import com.mystic.atlantis.particles.PushBubbleStreamParticleWest;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="atlantis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.JETSTREAM_WATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.FLOWING_JETSTREAM_WATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.SALTY_SEAWATER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.FLOWING_SALTY_SEAWATER.get()), (RenderType)RenderType.m_110466_());
        ClientSetup.registerPlantRenderer(BlockEntityInit.SEASHROOM, "seashroom");
        ClientSetup.registerPlantRenderer(BlockEntityInit.TUBER_UP, "tuber_up");
        ClientSetup.registerPlantRenderer(BlockEntityInit.BLUE_LILY, "blue_lily");
        ClientSetup.registerPlantRenderer(BlockEntityInit.BURNT_DEEP, "burnt_deep");
        ClientSetup.registerPlantRenderer(BlockEntityInit.ANEMONE, "anemone");
        for (Object dyeColor : DyeColor.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110457_(), (Block)BlockInit.MOSSY_SHELL_BLOCKS.get(dyeColor).get(), (Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(dyeColor).get());
        }
        for (TrailsGroup group : BlockInit.ANCIENT_CUPRUM.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110457_(), (Block)group.grate().get(), (Block)group.waxed_grate().get());
        }
        for (Object dyeColor : DyeColor.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110457_(), (Block)BlockInit.MOSSY_SHELL_BLOCKS.get(dyeColor).get(), (Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(dyeColor).get());
        }
        for (TrailsGroup group : BlockInit.ANCIENT_CUPRUM.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110457_(), (Block)group.grate().get());
        }
        for (BlockType seaGlass : BlockInit.SEA_GLASS_LIST.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110466_(), (Block)seaGlass.block().get(), (Block)seaGlass.button().get(), (Block)seaGlass.wall().get(), (Block)seaGlass.slab().get(), (Block)seaGlass.pressurePlate().get(), (Block)seaGlass.stairs().get());
        }
        for (BlockType seaGlass : BlockInit.SEA_GLASS_PATTERNS.values()) {
            ClientSetup.registerBlockRenderLayers(RenderType.m_110466_(), (Block)seaGlass.block().get(), (Block)seaGlass.button().get(), (Block)seaGlass.wall().get(), (Block)seaGlass.slab().get(), (Block)seaGlass.pressurePlate().get(), (Block)seaGlass.stairs().get());
        }
        ClientSetup.registerBlockRenderLayers(RenderType.m_110463_(), (Block)BlockInit.BLUE_LILY.get(), (Block)BlockInit.BURNT_DEEP.get(), (Block)BlockInit.ANEMONE.get(), (Block)BlockInit.TUBER_UP.get(), (Block)BlockInit.SEASHROOM.get(), (Block)BlockInit.FIRE_MELON_FRUIT.get(), (Block)BlockInit.FIRE_MELON_FRUIT_SPIKED.get(), (Block)BlockInit.FIRE_MELON_STEM.get(), (Block)BlockInit.FIRE_MELON_TOP.get(), (Block)BlockInit.NYMPH_PLANKS.door().get(), (Block)BlockInit.NYMPH_PLANKS.trapDoor().get(), (Block)BlockInit.NYMPH_SAPLING.get(), (Block)BlockInit.PALM_SAPLING.get(), (Block)BlockInit.SEABLOOM.get(), (Block)BlockInit.ALGAE.get(), (Block)BlockInit.AQUATIC_POWER_TORCH.get(), (Block)BlockInit.WALL_AQUATIC_POWER_TORCH.get(), (Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get(), (Block)BlockInit.AQUATIC_POWER_REPEATER.get(), (Block)BlockInit.AQUATIC_POWER_TRIPWIRE.get(), (Block)BlockInit.AQUATIC_POWER_TRIPWIRE_HOOK.get(), (Block)BlockInit.YELLOW_SEABLOOM.get(), (Block)BlockInit.RED_SEABLOOM.get(), (Block)BlockInit.AQUATIC_POWER_COMPARATOR.get(), (Block)BlockInit.ANCIENT_ACACIA.door().get(), (Block)BlockInit.ANCIENT_BIRCH.door().get(), (Block)BlockInit.ANCIENT_DARK_OAK.door().get(), (Block)BlockInit.ANCIENT_JUNGLE.door().get(), (Block)BlockInit.ANCIENT_OAK.door().get(), (Block)BlockInit.ANCIENT_SPRUCE.door().get(), (Block)BlockInit.ANCIENT_BAMBOO.door().get(), (Block)BlockInit.ANCIENT_MANGROVE.door().get(), (Block)BlockInit.ANCIENT_CHERRY.door().get(), (Block)BlockInit.ANCIENT_WARPED.door().get(), (Block)BlockInit.ANCIENT_CRIMSON.door().get(), (Block)BlockInit.ANCIENT_ACACIA.trapDoor().get(), (Block)BlockInit.ANCIENT_BIRCH.trapDoor().get(), (Block)BlockInit.ANCIENT_DARK_OAK.trapDoor().get(), (Block)BlockInit.ANCIENT_JUNGLE.trapDoor().get(), (Block)BlockInit.ANCIENT_OAK.trapDoor().get(), (Block)BlockInit.ANCIENT_SPRUCE.trapDoor().get(), (Block)BlockInit.ANCIENT_BAMBOO.trapDoor().get(), (Block)BlockInit.ANCIENT_MANGROVE.trapDoor().get(), (Block)BlockInit.ANCIENT_CHERRY.trapDoor().get(), (Block)BlockInit.ANCIENT_WARPED.trapDoor().get(), (Block)BlockInit.ANCIENT_CRIMSON.trapDoor().get(), (Block)BlockInit.PURPLE_SEASHROOM.get(), (Block)BlockInit.YELLOW_SEASHROOM.get());
        ClientSetup.registerBlockRenderLayers(RenderType.m_110466_(), (Block)BlockInit.BLACK_PEARL_BLOCK.get(), (Block)BlockInit.GRAY_PEARL_BLOCK.get(), (Block)BlockInit.WHITE_PEARL_BLOCK.get(), (Block)BlockInit.LIGHT_GRAY_PEARL_BLOCK.get(), (Block)BlockInit.BLUE_PEARL_BLOCK.get(), (Block)BlockInit.LIGHT_BLUE_PEARL_BLOCK.get(), (Block)BlockInit.RED_PEARL_BLOCK.get(), (Block)BlockInit.ORANGE_PEARL_BLOCK.get(), (Block)BlockInit.PINK_PEARL_BLOCK.get(), (Block)BlockInit.YELLOW_PEARL_BLOCK.get(), (Block)BlockInit.GREEN_PEARL_BLOCK.get(), (Block)BlockInit.LIME_PEARL_BLOCK.get(), (Block)BlockInit.PURPLE_PEARL_BLOCK.get(), (Block)BlockInit.MAGENTA_PEARL_BLOCK.get(), (Block)BlockInit.CYAN_PEARL_BLOCK.get(), (Block)BlockInit.BROWN_PEARL_BLOCK.get(), (Block)BlockInit.ATLANTEAN_PORTAL.get());
        ClientSetup.registerBlockRenderLayers(RenderType.m_110457_(), (Block)BlockInit.PALM_LEAVES.get(), (Block)BlockInit.NYMPH_LEAVES.get());
    }

    private static <T extends GeneralPlantBlockEntity<T>> void registerPlantRenderer(RegistryObject<BlockEntityType<T>> registryObject, String name) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)registryObject.get()), pContext -> new GeneralPlantRenderer(name));
    }

    @SubscribeEvent
    public static void registerDimensionEffect(RegisterDimensionSpecialEffectsEvent event) {
        event.register(DimensionAtlantis.ATLANTIS_DIMENSION_EFFECT, (DimensionSpecialEffects)AtlantisDimensionalEffect.INSTANCE);
    }

    @SubscribeEvent
    public static void entityRegisterEvent(EntityRenderersEvent.RegisterRenderers bus) {
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), entityRenderDispatcher -> new RubyclawCrabEntityRenderer(entityRenderDispatcher, new RubyclawCrabEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.COCONUT_CRAB.get(), entityRenderDispatcher -> new CoconutCrabEntityRenderer(entityRenderDispatcher, new CoconutCrabEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), entityRenderDispatcher -> new AquaielJellyfishEntityRenderer(entityRenderDispatcher, new AquaielJellyfishEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), entityRenderDispatcher -> new GlittertailShrimpEntityRenderer(entityRenderDispatcher, new GlittertailShrimpEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.SUBMARINE.get(), SubmarineEntityRenderer::new);
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.NYMPH_BOAT.get(), NymphBoatRenderer::new);
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.PALM_BOAT.get(), PalmBoatRenderer::new);
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.LEVIATHAN.get(), entityRenderDispatcher -> new LeviathanEntityRenderer(entityRenderDispatcher, new LeviathanEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), entityRenderDispatcher -> new ThalassianSeahorseEntityRenderer(entityRenderDispatcher, new ThalassianSeahorseEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.STARFISH.get(), entityRenderDispatcher -> new StarfishEntityRenderer(entityRenderDispatcher, new StarfishEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), entityRenderDispatcher -> new ZombieStarfishEntityRenderer(entityRenderDispatcher, new ZombieStarfishEntityModel()));
        bus.registerEntityRenderer((EntityType)AtlantisEntityInit.SODIUM_BOMB.get(), SodiumBombRenderer::new);
    }

    @SubscribeEvent
    public static void spawnRules(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)AtlantisEntityInit.STARFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, StarfishEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, ZombieStarfishEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, ThalassianSeahorseEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, AquaielJellyfishEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, RubyclawCrabEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR_WG, GlittertailShrimpEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
    }

    @SubscribeEvent
    public static void init(RegisterParticleProvidersEvent bus) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_UP.get(), PushBubbleStreamParticleUp.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_DOWN.get(), PushBubbleStreamParticleDown.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_NORTH.get(), PushBubbleStreamParticleNorth.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_SOUTH.get(), PushBubbleStreamParticleSouth.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_EAST.get(), PushBubbleStreamParticleEast.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.PUSH_BUBBLESTREAM_WEST.get(), PushBubbleStreamParticleWest.Factory::new);
    }

    private static void registerBlockRenderLayers(RenderType layer, Block ... blocks) {
        Stream.of(blocks).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)layer));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        ArrayListMultimap mapLinguistic = ArrayListMultimap.create();
        for (Map<DyeColor, RegistryObject<Block>> colorMapLinguistics : BlockInit.DYED_LINGUISTICS.values()) {
            colorMapLinguistics.forEach((k, v) -> mapLinguistic.put(k, (Object)((Block)v.get())));
        }
        BlockColors blockColors = event.getBlockColors();
        BlockColor WHITE = (arg, arg2, arg3, i) -> 0xF9FFFE;
        BlockColor ORANGE = (arg, arg2, arg3, i) -> 16351261;
        BlockColor MAGENTA = (arg, arg2, arg3, i) -> 13061821;
        BlockColor LIGHT_BLUE = (arg, arg2, arg3, i) -> 3847130;
        BlockColor YELLOW = (arg, arg2, arg3, i) -> 16701501;
        BlockColor LIME = (arg, arg2, arg3, i) -> 8439583;
        BlockColor PINK = (arg, arg2, arg3, i) -> 15961002;
        BlockColor GRAY = (arg, arg2, arg3, i) -> 4673362;
        BlockColor LIGHT_GRAY = (arg, arg2, arg3, i) -> 0x9D9D97;
        BlockColor CYAN = (arg, arg2, arg3, i) -> 1481884;
        BlockColor PURPLE = (arg, arg2, arg3, i) -> 8991416;
        BlockColor BLUE = (arg, arg2, arg3, i) -> 3949738;
        BlockColor BROWN = (arg, arg2, arg3, i) -> 8606770;
        BlockColor GREEN = (arg, arg2, arg3, i) -> 6192150;
        BlockColor RED = (arg, arg2, arg3, i) -> 11546150;
        BlockColor BLACK = (arg, arg2, arg3, i) -> 0x1D1D21;
        mapLinguistic.get((Object)DyeColor.WHITE).forEach(block -> blockColors.m_92589_(WHITE, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.ORANGE).forEach(block -> blockColors.m_92589_(ORANGE, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.MAGENTA).forEach(block -> blockColors.m_92589_(MAGENTA, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.LIGHT_BLUE).forEach(block -> blockColors.m_92589_(LIGHT_BLUE, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.YELLOW).forEach(block -> blockColors.m_92589_(YELLOW, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.LIME).forEach(block -> blockColors.m_92589_(LIME, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.PINK).forEach(block -> blockColors.m_92589_(PINK, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.GRAY).forEach(block -> blockColors.m_92589_(GRAY, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.LIGHT_GRAY).forEach(block -> blockColors.m_92589_(LIGHT_GRAY, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.CYAN).forEach(block -> blockColors.m_92589_(CYAN, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.PURPLE).forEach(block -> blockColors.m_92589_(PURPLE, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.BLUE).forEach(block -> blockColors.m_92589_(BLUE, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.BROWN).forEach(block -> blockColors.m_92589_(BROWN, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.GREEN).forEach(block -> blockColors.m_92589_(GREEN, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.RED).forEach(block -> blockColors.m_92589_(RED, new Block[]{block}));
        mapLinguistic.get((Object)DyeColor.BLACK).forEach(block -> blockColors.m_92589_(BLACK, new Block[]{block}));
        blockColors.m_92589_(WHITE, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92589_(ORANGE, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92589_(MAGENTA, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92589_(LIGHT_BLUE, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92589_(YELLOW, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92589_(LIME, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92589_(PINK, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92589_(GRAY, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92589_(LIGHT_GRAY, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92589_(CYAN, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92589_(PURPLE, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92589_(BLUE, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92589_(BROWN, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92589_(GREEN, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92589_(RED, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92589_(BLACK, new Block[]{(Block)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92589_(WHITE, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92589_(ORANGE, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92589_(MAGENTA, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92589_(LIGHT_BLUE, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92589_(YELLOW, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92589_(LIME, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92589_(PINK, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92589_(GRAY, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92589_(LIGHT_GRAY, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92589_(CYAN, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92589_(PURPLE, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92589_(BLUE, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92589_(BROWN, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92589_(GREEN, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92589_(RED, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92589_(BLACK, new Block[]{(Block)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92589_(WHITE, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92589_(ORANGE, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92589_(MAGENTA, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92589_(LIGHT_BLUE, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92589_(YELLOW, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92589_(LIME, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92589_(PINK, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92589_(GRAY, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92589_(LIGHT_GRAY, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92589_(CYAN, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92589_(PURPLE, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92589_(BLUE, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92589_(BROWN, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92589_(GREEN, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92589_(RED, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92589_(BLACK, new Block[]{(Block)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92589_(WHITE, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92589_(ORANGE, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92589_(MAGENTA, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92589_(LIGHT_BLUE, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92589_(YELLOW, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92589_(LIME, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92589_(PINK, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92589_(GRAY, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92589_(LIGHT_GRAY, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92589_(CYAN, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92589_(PURPLE, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92589_(BLUE, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92589_(BROWN, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92589_(GREEN, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92589_(RED, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92589_(BLACK, new Block[]{(Block)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        BlockColor REGULAR = (arg, arg2, arg3, i) -> 9219794;
        BlockInit.NON_LINGUISTICS.values().stream().map(RegistryObject::get).forEach(block -> blockColors.m_92589_(REGULAR, new Block[]{block}));
        BlockColor JetstreamWaterColor = (arg, arg2, arg3, i) -> FastColor.ARGB32.m_13660_((int)255, (int)169, (int)255, (int)208);
        blockColors.m_92589_(JetstreamWaterColor, new Block[]{(Block)BlockInit.JETSTREAM_WATER.get()});
        BlockColor SaltySeaWaterColor = (arg, arg2, arg3, i) -> FastColor.ARGB32.m_13660_((int)255, (int)10, (int)96, (int)208);
        blockColors.m_92589_(SaltySeaWaterColor, new Block[]{(Block)BlockInit.SALTY_SEAWATER.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerItemColor(RegisterColorHandlersEvent.Item event) {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Map<DyeColor, RegistryObject<Block>> colorMap : BlockInit.DYED_LINGUISTICS.values()) {
            colorMap.forEach((k, v) -> map.put(k, (Object)((Block)v.get())));
        }
        ItemColors blockColors = event.getItemColors();
        ItemColor WHITE = (arg, i) -> 0xF9FFFE;
        map.get((Object)DyeColor.WHITE).forEach(block -> blockColors.m_92689_(WHITE, new ItemLike[]{block}));
        ItemColor ORANGE = (arg, i) -> 16351261;
        map.get((Object)DyeColor.ORANGE).forEach(block -> blockColors.m_92689_(ORANGE, new ItemLike[]{block}));
        ItemColor MAGENTA = (arg, i) -> 13061821;
        map.get((Object)DyeColor.MAGENTA).forEach(block -> blockColors.m_92689_(MAGENTA, new ItemLike[]{block}));
        ItemColor LIGHT_BLUE = (arg, i) -> 3847130;
        map.get((Object)DyeColor.LIGHT_BLUE).forEach(block -> blockColors.m_92689_(LIGHT_BLUE, new ItemLike[]{block}));
        ItemColor YELLOW = (arg, i) -> 16701501;
        map.get((Object)DyeColor.YELLOW).forEach(block -> blockColors.m_92689_(YELLOW, new ItemLike[]{block}));
        ItemColor LIME = (arg, i) -> 8439583;
        map.get((Object)DyeColor.LIME).forEach(block -> blockColors.m_92689_(LIME, new ItemLike[]{block}));
        ItemColor PINK = (arg, i) -> 15961002;
        map.get((Object)DyeColor.PINK).forEach(block -> blockColors.m_92689_(PINK, new ItemLike[]{block}));
        ItemColor GRAY = (arg, i) -> 4673362;
        map.get((Object)DyeColor.GRAY).forEach(block -> blockColors.m_92689_(GRAY, new ItemLike[]{block}));
        ItemColor LIGHT_GRAY = (arg, i) -> 0x9D9D97;
        map.get((Object)DyeColor.LIGHT_GRAY).forEach(block -> blockColors.m_92689_(LIGHT_GRAY, new ItemLike[]{block}));
        ItemColor CYAN = (arg, i) -> 1481884;
        map.get((Object)DyeColor.CYAN).forEach(block -> blockColors.m_92689_(CYAN, new ItemLike[]{block}));
        ItemColor PURPLE = (arg, i) -> 8991416;
        map.get((Object)DyeColor.PURPLE).forEach(block -> blockColors.m_92689_(PURPLE, new ItemLike[]{block}));
        ItemColor BLUE = (arg, i) -> 3949738;
        map.get((Object)DyeColor.BLUE).forEach(block -> blockColors.m_92689_(BLUE, new ItemLike[]{block}));
        ItemColor BROWN = (arg, i) -> 8606770;
        map.get((Object)DyeColor.BROWN).forEach(block -> blockColors.m_92689_(BROWN, new ItemLike[]{block}));
        ItemColor GREEN = (arg, i) -> 6192150;
        map.get((Object)DyeColor.GREEN).forEach(block -> blockColors.m_92689_(GREEN, new ItemLike[]{block}));
        ItemColor RED = (arg, i) -> 11546150;
        map.get((Object)DyeColor.RED).forEach(block -> blockColors.m_92689_(RED, new ItemLike[]{block}));
        ItemColor BLACK = (arg, i) -> 0x1D1D21;
        map.get((Object)DyeColor.BLACK).forEach(block -> blockColors.m_92689_(BLACK, new ItemLike[]{block}));
        blockColors.m_92689_(WHITE, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92689_(ORANGE, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92689_(MAGENTA, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92689_(LIGHT_BLUE, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92689_(YELLOW, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92689_(LIME, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92689_(PINK, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92689_(GRAY, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92689_(LIGHT_GRAY, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92689_(CYAN, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92689_(PURPLE, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92689_(BLUE, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92689_(BROWN, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92689_(GREEN, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92689_(RED, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92689_(BLACK, new ItemLike[]{(ItemLike)BlockInit.COLORED_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92689_(WHITE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92689_(ORANGE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92689_(MAGENTA, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92689_(LIGHT_BLUE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92689_(YELLOW, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92689_(LIME, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92689_(PINK, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92689_(GRAY, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92689_(LIGHT_GRAY, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92689_(CYAN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92689_(PURPLE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92689_(BLUE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92689_(BROWN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92689_(GREEN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92689_(RED, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92689_(BLACK, new ItemLike[]{(ItemLike)BlockInit.CRACKED_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92689_(WHITE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92689_(ORANGE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92689_(MAGENTA, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92689_(LIGHT_BLUE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92689_(YELLOW, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92689_(LIME, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92689_(PINK, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92689_(GRAY, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92689_(LIGHT_GRAY, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92689_(CYAN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92689_(PURPLE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92689_(BLUE, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92689_(BROWN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92689_(GREEN, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92689_(RED, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92689_(BLACK, new ItemLike[]{(ItemLike)BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        blockColors.m_92689_(WHITE, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.WHITE).get()});
        blockColors.m_92689_(ORANGE, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.ORANGE).get()});
        blockColors.m_92689_(MAGENTA, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.MAGENTA).get()});
        blockColors.m_92689_(LIGHT_BLUE, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_BLUE).get()});
        blockColors.m_92689_(YELLOW, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.YELLOW).get()});
        blockColors.m_92689_(LIME, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIME).get()});
        blockColors.m_92689_(PINK, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.PINK).get()});
        blockColors.m_92689_(GRAY, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.GRAY).get()});
        blockColors.m_92689_(LIGHT_GRAY, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.LIGHT_GRAY).get()});
        blockColors.m_92689_(CYAN, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.CYAN).get()});
        blockColors.m_92689_(PURPLE, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.PURPLE).get()});
        blockColors.m_92689_(BLUE, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BLUE).get()});
        blockColors.m_92689_(BROWN, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BROWN).get()});
        blockColors.m_92689_(GREEN, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.GREEN).get()});
        blockColors.m_92689_(RED, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.RED).get()});
        blockColors.m_92689_(BLACK, new ItemLike[]{(ItemLike)BlockInit.MOSSY_SHELL_BLOCKS.get(DyeColor.BLACK).get()});
        ItemColor REGULAR = (arg, i) -> 9219794;
        BlockInit.NON_LINGUISTICS.values().stream().map(RegistryObject::get).forEach(block -> blockColors.m_92689_(REGULAR, new ItemLike[]{block}));
    }
}

