/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.inventory.WritingMenu;
import com.mystic.atlantis.recipes.WritingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;

public class WritingScreen
extends AbstractContainerScreen<WritingMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("textures/gui/container/stonecutter.png");
    private static final ResourceLocation GRADIENT = Atlantis.id("textures/gui/container/gradient.png");
    private static final ResourceLocation GRADIENT_TOP = Atlantis.id("textures/gui/container/gradient_top.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WritingScreen(WritingMenu arg, Inventory arg2, Component arg3) {
        super((AbstractContainerMenu)arg, arg2, arg3);
        arg.registerUpdateListener(this::containerChanged);
    }

    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(poseStack, mouseX, mouseY, partialTick);
        this.m_280072_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(poseStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.f_97735_;
        int j = this.f_97736_;
        poseStack.m_280218_(BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        poseStack.m_280218_(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int m = this.f_97736_ + 14;
        int n = this.startIndex + 12;
        this.renderButtons(poseStack, mouseX, mouseY, l, m, n);
        this.renderRecipes(poseStack, l, m, n);
        poseStack.m_280218_(GRADIENT_TOP, i - 4, j - 4, 0, 0, this.f_97726_ + 7, this.f_97727_ + 7);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_280218_(GRADIENT, i - 4, j - 4, 0, 0, this.f_97726_ + 7, this.f_97727_ + 7);
        RenderSystem.disableBlend();
    }

    protected void m_280072_(GuiGraphics poseStack, int x, int y) {
        super.m_280072_(poseStack, x, y);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<WritingRecipe> list = ((WritingMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WritingMenu)this.f_97732_).getNumRecipes(); ++l) {
                int m = l - this.startIndex;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                assert (Minecraft.m_91087_().f_91073_ != null);
                poseStack.m_280153_(this.f_96547_, list.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics poseStack, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        for (int i = this.startIndex; i < lastVisibleElementIndex && i < ((WritingMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            int n = this.f_97727_;
            if (i == ((WritingMenu)this.f_97732_).getSelectedRecipeIndex()) {
                n += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                n += 36;
            }
            poseStack.m_280218_(BG_LOCATION, k, m - 1, 0, n, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int left, int top, int recipeIndexOffsetMax) {
        List<WritingRecipe> list = ((WritingMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((WritingMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int m = top + l * 18 + 2;
            guiGraphics.m_280203_(((Item)ItemInit.getScroll(WritingScreen.intToGlyph(i)).get()).m_7968_(), k, m);
        }
    }

    public static LinguisticGlyph intToGlyph(int scroll) {
        return switch (scroll) {
            case 1 -> LinguisticGlyph.ZERO;
            case 2 -> LinguisticGlyph.ONE;
            case 3 -> LinguisticGlyph.TWO;
            case 4 -> LinguisticGlyph.THREE;
            case 5 -> LinguisticGlyph.FOUR;
            case 6 -> LinguisticGlyph.FIVE;
            case 7 -> LinguisticGlyph.SIX;
            case 8 -> LinguisticGlyph.SEVEN;
            case 9 -> LinguisticGlyph.EIGHT;
            case 10 -> LinguisticGlyph.NINE;
            case 11 -> LinguisticGlyph.A;
            case 12 -> LinguisticGlyph.B;
            case 13 -> LinguisticGlyph.C;
            case 14 -> LinguisticGlyph.D;
            case 15 -> LinguisticGlyph.E;
            case 16 -> LinguisticGlyph.F;
            case 17 -> LinguisticGlyph.G;
            case 18 -> LinguisticGlyph.H;
            case 19 -> LinguisticGlyph.I;
            case 20 -> LinguisticGlyph.J;
            case 21 -> LinguisticGlyph.K;
            case 22 -> LinguisticGlyph.L;
            case 23 -> LinguisticGlyph.M;
            case 24 -> LinguisticGlyph.N;
            case 25 -> LinguisticGlyph.O;
            case 26 -> LinguisticGlyph.P;
            case 27 -> LinguisticGlyph.Q;
            case 28 -> LinguisticGlyph.R;
            case 29 -> LinguisticGlyph.S;
            case 30 -> LinguisticGlyph.T;
            case 31 -> LinguisticGlyph.U;
            case 32 -> LinguisticGlyph.V;
            case 33 -> LinguisticGlyph.W;
            case 34 -> LinguisticGlyph.X;
            case 35 -> LinguisticGlyph.Y;
            case 36 -> LinguisticGlyph.Z;
            default -> LinguisticGlyph.BLANK;
        };
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int m = l - this.startIndex;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WritingMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l))) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WritingMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - delta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WritingMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((WritingMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WritingMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

