/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items.armor;

import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.util.Lazy;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasicArmorMaterial {
    public static final net.minecraft.world.item.ArmorMaterial ARMOR_AQUAMARINE = new ArmorMaterial("aquamarine", 24, new int[]{2, 6, 7, 3}, 9, SoundEvents.f_11677_, 1.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.AQUAMARINE_GEM.get()}));
    public static final net.minecraft.world.item.ArmorMaterial ARMOR_ORICHALCUM = new ArmorMaterial("orichalcum", 24, new int[]{2, 6, 7, 3}, 9, SoundEvents.f_11677_, 1.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.AQUAMARINE_GEM.get()}));
    public static final net.minecraft.world.item.ArmorMaterial ARMOR_BROWN_WROUGHT = new ArmorMaterial("wrought", 24, new int[]{3, 5, 5, 4}, 7, SoundEvents.f_11677_, 2.0, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.BROWN_WROUGHT_PATCHES.get()}));

    private static class ArmorMaterial
    implements net.minecraft.world.item.ArmorMaterial {
        private static final int[] Max_Damage_Array = new int[]{13, 15, 16, 11};
        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final float knockbackResistance;
        private final Lazy<Ingredient> repairMaterial;

        public ArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, double toughness, float knockbackResistance, Supplier<Ingredient> supplier) {
            this.name = name;
            this.maxDamageFactor = maxDamageFactor;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = (float)toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = new Lazy<Ingredient>(supplier);
        }

        public int m_266425_(ArmorItem.Type pType) {
            return Max_Damage_Array[pType.m_266308_().m_20749_()] * this.maxDamageFactor;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return this.damageReductionAmountArray[pType.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return this.enchantability;
        }

        public SoundEvent m_7344_() {
            return this.soundEvent;
        }

        public Ingredient m_6230_() {
            return this.repairMaterial.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }
    }
}

