/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.inventory;

import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.GlyphBlock;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.items.LinguisticGlyphScrollItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LinguisticMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private Runnable slotUpdateListener = () -> {};
    private final Slot blankSlot;
    private final Slot dyeSlot;
    private final Slot symbolSlot;
    private final Slot resultSlot;
    private long lastSoundTime;
    private final Container inputContainer = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            LinguisticMenu.this.m_6199_((Container)this);
            LinguisticMenu.this.slotUpdateListener.run();
        }
    };
    private final Container outputContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            LinguisticMenu.this.slotUpdateListener.run();
        }
    };

    public LinguisticMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public LinguisticMenu(int id, Inventory inventory, ContainerLevelAccess accessLevel) {
        super((MenuType)MenuTypeInit.LINGUISTIC.get(), id);
        int j;
        this.access = accessLevel;
        this.blankSlot = this.m_38897_(new Slot(this.inputContainer, 0, 28, 28){

            public boolean m_5857_(ItemStack arg) {
                BlockItem blockItem;
                Item item = arg.m_41720_();
                return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof GlyphBlock;
            }
        });
        this.dyeSlot = this.m_38897_(new Slot(this.inputContainer, 1, 48, 28){

            public boolean m_5857_(ItemStack arg) {
                return arg.m_41720_() instanceof DyeItem;
            }
        });
        this.symbolSlot = this.m_38897_(new Slot(this.inputContainer, 2, 38, 48){

            public boolean m_5857_(ItemStack arg) {
                return arg.m_41720_() instanceof LinguisticGlyphScrollItem;
            }
        });
        this.resultSlot = this.m_38897_(new Slot(this.outputContainer, 0, 122, 38){

            public boolean m_5857_(ItemStack arg) {
                return false;
            }

            public void m_142406_(Player arg, ItemStack arg2) {
                LinguisticMenu.this.blankSlot.m_6201_(1);
                LinguisticMenu.this.dyeSlot.m_6201_(1);
                LinguisticMenu.this.symbolSlot.m_6201_(1);
                LinguisticMenu.this.access.m_39292_((argx, arg2xxx) -> {
                    long l = argx.m_46467_();
                    if (LinguisticMenu.this.lastSoundTime != l) {
                        argx.m_5594_(null, arg2xxx, SoundEvents.f_12492_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        LinguisticMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(arg, arg2);
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 12 + k * 18, 88 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 12 + j * 18, 146));
        }
    }

    public boolean m_6875_(Player usingPlayer) {
        return LinguisticMenu.m_38889_((ContainerLevelAccess)this.access, (Player)usingPlayer, (Block)((Block)BlockInit.LINGUISTIC_TABLE.get()));
    }

    public void m_6199_(Container curContainer) {
        ItemStack blankStack = this.blankSlot.m_7993_();
        ItemStack dyetack = this.dyeSlot.m_7993_();
        ItemStack systemStack = this.symbolSlot.m_7993_();
        ItemStack resultStack = this.resultSlot.m_7993_();
        if (!resultStack.m_41619_() && (blankStack.m_41619_() || dyetack.m_41619_()) && systemStack.m_41619_()) {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.setupResultSlot();
        this.m_38946_();
    }

    public void registerUpdateListener(Runnable updateListener) {
        this.slotUpdateListener = updateListener;
    }

    public ItemStack m_7648_(Player usingPlayer, int index) {
        ItemStack emptyStack = ItemStack.f_41583_;
        Slot targetSlot = (Slot)this.f_38839_.get(index);
        if (targetSlot != null && targetSlot.m_6657_()) {
            ItemStack targetStack = targetSlot.m_7993_();
            emptyStack = targetStack.m_41777_();
            if (index == this.resultSlot.f_40219_) {
                if (!this.m_38903_(targetStack, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                targetSlot.m_40234_(targetStack, emptyStack);
            } else if (index != this.dyeSlot.f_40219_ && index != this.blankSlot.f_40219_ && index != this.symbolSlot.f_40219_ ? (BlockInit.getLinguisticBlock(LinguisticGlyph.BLANK, null).map(Block::m_5456_).filter(a -> a == targetStack.m_41720_()).isPresent() ? !this.m_38903_(targetStack, this.blankSlot.f_40219_, this.blankSlot.f_40219_ + 1, false) : (targetStack.m_41720_() instanceof DyeItem ? !this.m_38903_(targetStack, this.dyeSlot.f_40219_, this.dyeSlot.f_40219_ + 1, false) : (targetStack.m_41720_() instanceof LinguisticGlyphScrollItem ? !this.m_38903_(targetStack, this.symbolSlot.f_40219_, this.symbolSlot.f_40219_ + 1, false) : (index >= 4 && index < 31 ? !this.m_38903_(targetStack, 31, 40, false) : index >= 31 && index < 40 && !this.m_38903_(targetStack, 4, 31, false))))) : !this.m_38903_(targetStack, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (targetStack.m_41619_()) {
                targetSlot.m_5852_(ItemStack.f_41583_);
            } else {
                targetSlot.m_6654_();
            }
            if (targetStack.m_41613_() == emptyStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            targetSlot.m_142406_(usingPlayer, targetStack);
        }
        return emptyStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((arg2, arg3) -> this.m_150411_(player, this.inputContainer));
    }

    private void setupResultSlot() {
        DyeColor curDyeColor = this.dyeSlot.m_6657_() ? ((DyeItem)this.dyeSlot.m_7993_().m_41720_()).m_41089_() : null;
        LinguisticGlyph curSymbol = this.symbolSlot.m_6657_() ? ((LinguisticGlyphScrollItem)this.symbolSlot.m_7993_().m_41720_()).getSymbol() : LinguisticGlyph.BLANK;
        ItemStack result = ItemStack.f_41583_;
        if (this.blankSlot.m_6657_()) {
            result = new ItemStack((ItemLike)BlockInit.getLinguisticBlock(curSymbol, curDyeColor).get());
        }
        if (!ItemStack.m_41728_((ItemStack)result, (ItemStack)this.resultSlot.m_7993_())) {
            this.resultSlot.m_5852_(result);
        }
    }

    public Slot getBlankSlot() {
        return this.blankSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getSymbolSlot() {
        return this.symbolSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

