/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.AtlantisSoundEventInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.ToolInit;
import com.mystic.atlantis.items.AtlanteanCrystal;
import com.mystic.atlantis.items.AtlanteanEntityBucketItem;
import com.mystic.atlantis.items.CrabEntityBucketItem;
import com.mystic.atlantis.items.DefaultItem;
import com.mystic.atlantis.items.LinguisticGlyphScrollItem;
import com.mystic.atlantis.items.NymphBoatItem;
import com.mystic.atlantis.items.OrbOfAtlantis;
import com.mystic.atlantis.items.OrichalcumSmithingTemplateItem;
import com.mystic.atlantis.items.PalmBoatItem;
import com.mystic.atlantis.items.SodiumItem;
import com.mystic.atlantis.items.SubmarineItem;
import com.mystic.atlantis.items.armor.BasicArmorMaterial;
import com.mystic.atlantis.items.armor.ItemArmorAtlantis;
import com.mystic.atlantis.items.armor.ItemArmorOrichalcum;
import com.mystic.atlantis.items.armor.ItemArmorWrought;
import com.mystic.atlantis.items.food.CoconutSliceItem;
import com.mystic.atlantis.items.food.CrabLegsItem;
import com.mystic.atlantis.items.food.FireMelonJellyBottle;
import com.mystic.atlantis.items.food.JellyfishJellyBottle;
import com.mystic.atlantis.items.food.WaterPill;
import com.mystic.atlantis.items.tools.AquamarineHammer;
import com.mystic.atlantis.items.tools.AtlanteanAmuletItem;
import com.mystic.atlantis.items.tools.AtlanteanAxe;
import com.mystic.atlantis.items.tools.AtlanteanHoe;
import com.mystic.atlantis.items.tools.AtlanteanPickaxe;
import com.mystic.atlantis.items.tools.AtlanteanShovel;
import com.mystic.atlantis.items.tools.AtlanteanSpearItem;
import com.mystic.atlantis.items.tools.AtlanteanSword;
import com.mystic.atlantis.items.tools.OrichalcumHammer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"atlantis");
    private static final Map<LinguisticGlyph, RegistryObject<Item>> scrolls = new HashMap<LinguisticGlyph, RegistryObject<Item>>();
    private static final Item.Properties ATLANTIS_SETTINGS = new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON);
    public static final RegistryObject<Item> ATLANTEAN_AMULET = ItemInit.register("atlantean_amulet", AtlanteanAmuletItem::new);
    public static final RegistryObject<Item> ATLANTEAN_SPEAR = ItemInit.register("atlantean_spear", () -> new AtlanteanSpearItem(ToolInit.AQUAMARINE, 5));
    public static final RegistryObject<Item> NYMPH_BOAT = ItemInit.register("nymph_boat", () -> new NymphBoatItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> PALM_BOAT = ItemInit.register("palm_boat", () -> new PalmBoatItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> RUBYCLAW_CRAB_EGG = ItemInit.register("rubyclaw_crab_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.RUBYCLAW_CRAB, 0x800002, 16715589, new Item.Properties()));
    public static final RegistryObject<Item> AQUAIEL_JELLYFISH_EGG = ItemInit.register("aquaiel_jellyfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.AQUAIEL_JELLYFISH, 17802, 361215, new Item.Properties()));
    public static final RegistryObject<Item> GLITTERTAIL_SHRIMP_EGG = ItemInit.register("glittertail_shrimp_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.GLITTERTAIL_SHRIMP, 0xFF0000, 0xFF8000, new Item.Properties()));
    public static final RegistryObject<Item> LEVIATHAN_EGG = ItemInit.register("leviathan_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.LEVIATHAN, 0x1DDDDD, 11394779, new Item.Properties()));
    public static final RegistryObject<Item> THALASSIAN_SEAHORSE_EGG = ItemInit.register("thalassian_seahorse_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.THALASSIAN_SEAHORSE, 16182078, 13617243, new Item.Properties()));
    public static final RegistryObject<Item> COCONUT_CRAB_EGG = ItemInit.register("coconut_crab_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.COCONUT_CRAB, 0x800002, 16715589, new Item.Properties()));
    public static final RegistryObject<Item> STARFISH_EGG = ItemInit.register("starfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.STARFISH, 16753693, 16179807, new Item.Properties()));
    public static final RegistryObject<Item> ZOMBIE_STARFISH_EGG = ItemInit.register("zombie_starfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.ZOMBIE_STARFISH, 16646390, 41328, new Item.Properties()));
    public static final RegistryObject<Item> PANBEE = ItemInit.register("panbee", () -> new RecordItem(15, AtlantisSoundEventInit.PANBEE, ATLANTIS_SETTINGS, 4040));
    public static final RegistryObject<Item> COLUMN_CAVITATION = ItemInit.register("column_cavitation", () -> new RecordItem(15, AtlantisSoundEventInit.COLUMN, ATLANTIS_SETTINGS, 4420));
    public static final RegistryObject<Item> ANCIENT_CUPRUM_INGOT = ItemInit.register("ancient_cuprum_ingot", DefaultItem::new);
    public static final RegistryObject<Item> RAW_ANCIENT_CUPRUM = ItemInit.register("raw_ancient_cuprum", DefaultItem::new);
    public static final RegistryObject<Item> BROKEN_SHELLS = ItemInit.register("broken_shells", DefaultItem::new);
    public static final RegistryObject<Item> SODIUM_NUGGET = ItemInit.register("sodium_nugget", () -> new SodiumItem(new Item.Properties()));
    public static final RegistryObject<Item> SEASALT = ItemInit.register("seasalt", DefaultItem::new);
    public static final RegistryObject<Item> FIRE_MELON_JELLY_BOTTLE = ItemInit.register("fire_melon_jelly_bottle", () -> new FireMelonJellyBottle(new Item.Properties()));
    public static final RegistryObject<Item> JELLY_BOTTLE = ItemInit.register("jellyfish_jelly_bottle", () -> new JellyfishJellyBottle(new Item.Properties()));
    public static final RegistryObject<Item> AQUAMARINE_GEM = ItemInit.register("aquamarine_gem", DefaultItem::new);
    public static final RegistryObject<Item> ORICHALCUM_INGOT = ItemInit.register("orichalcum_ingot", DefaultItem::new);
    public static final RegistryObject<Item> ORICHALCUM_BLEND = ItemInit.register("orichalcum_blend", DefaultItem::new);
    public static final RegistryObject<Item> ORB_OF_ATLANTIS = ItemInit.register("orb_of_atlantis", OrbOfAtlantis::new);
    public static final RegistryObject<Item> ATLANTEAN_CRYSTAL = ItemInit.register("atlantean_crystal", AtlanteanCrystal::new);
    public static final RegistryObject<Item> OCEAN_STONE = ItemInit.register("ocean_stone", DefaultItem::new);
    public static final RegistryObject<Item> DROP_OF_ATLANTIS = ItemInit.register("drop_of_atlantis", DefaultItem::new);
    public static final RegistryObject<Item> BROWN_WROUGHT_PATCHES = ItemInit.register("brown_wrought_patches", DefaultItem::new);
    public static final RegistryObject<Item> CRAB_LEGS = ItemInit.register("crab_legs", () -> new CrabLegsItem(new Item.Properties()));
    public static final RegistryObject<Item> SHRIMP = ItemInit.register("shrimp", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(5).m_38758_(0.2f).effect(() -> new MobEffectInstance(MobEffects.f_19604_, 100), 0.05f).m_38767_())));
    public static final RegistryObject<Item> COOKED_SHRIMP = ItemInit.register("cooked_shrimp", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(2).m_38758_(0.4f).m_38767_())));
    public static final RegistryObject<Item> AQUATIC_POWER_TORCH = ItemInit.register("aquatic_power_torch", () -> new StandingAndWallBlockItem((Block)BlockInit.AQUATIC_POWER_TORCH.get(), (Block)BlockInit.WALL_AQUATIC_POWER_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final RegistryObject<Item> AQUATIC_POWER_DUST = ItemInit.register("aquatic_power_dust", () -> new ItemNameBlockItem((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get(), new Item.Properties()));
    public static final RegistryObject<Item> AQUAIEL_STRING = ItemInit.register("aquaiel_string", () -> new ItemNameBlockItem((Block)BlockInit.AQUATIC_POWER_TRIPWIRE.get(), new Item.Properties()));
    public static final RegistryObject<Item> SUBMARINE = ItemInit.register("submarine", () -> new SubmarineItem(new Item.Properties()));
    public static final RegistryObject<Item> WATER_PILL = ItemInit.register("water_pill", WaterPill::new);
    public static final RegistryObject<Item> NYMPH_SIGN = ItemInit.register("nymph_sign", () -> new SignItem(new Item.Properties(), (Block)BlockInit.NYMPH_SIGN.get(), (Block)BlockInit.NYMPH_WALL_SIGN.get()));
    public static final RegistryObject<Item> PALM_SIGN = ItemInit.register("palm_sign", () -> new SignItem(new Item.Properties(), (Block)BlockInit.PALM_SIGN.get(), (Block)BlockInit.PALM_WALL_SIGN.get()));
    public static final RegistryObject<Item> FIRE_MELON_FRUIT = ItemInit.register("fire_melon_fruit", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(1.0f).m_38767_())));
    public static final RegistryObject<Item> FIRE_MELON_FRUIT_SPIKED = ItemInit.register("fire_melon_fruit_spiked", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 60), 1.0f).m_38767_())));
    public static final RegistryObject<Item> FIRE_MELON_SEEDS = ItemInit.register("fire_melon_fruit_seeds", () -> new ItemNameBlockItem((Block)BlockInit.FIRE_MELON_TOP.get(), new Item.Properties()));
    public static final RegistryObject<Item> FIRE_MELON_SPIKE = ItemInit.register("fire_melon_spike", DefaultItem::new);
    public static final RegistryObject<Item> COCONUT_SLICE = ItemInit.register("coconut_slice", () -> new CoconutSliceItem(new Item.Properties()));
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL = ItemInit.registerGlyph(LinguisticGlyph.BLANK);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_A = ItemInit.registerGlyph(LinguisticGlyph.A);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_B = ItemInit.registerGlyph(LinguisticGlyph.B);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_C = ItemInit.registerGlyph(LinguisticGlyph.C);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_D = ItemInit.registerGlyph(LinguisticGlyph.D);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_E = ItemInit.registerGlyph(LinguisticGlyph.E);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_F = ItemInit.registerGlyph(LinguisticGlyph.F);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_G = ItemInit.registerGlyph(LinguisticGlyph.G);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_H = ItemInit.registerGlyph(LinguisticGlyph.H);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_I = ItemInit.registerGlyph(LinguisticGlyph.I);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_J = ItemInit.registerGlyph(LinguisticGlyph.J);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_K = ItemInit.registerGlyph(LinguisticGlyph.K);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_L = ItemInit.registerGlyph(LinguisticGlyph.L);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_M = ItemInit.registerGlyph(LinguisticGlyph.M);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_N = ItemInit.registerGlyph(LinguisticGlyph.N);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_O = ItemInit.registerGlyph(LinguisticGlyph.O);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_P = ItemInit.registerGlyph(LinguisticGlyph.P);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Q = ItemInit.registerGlyph(LinguisticGlyph.Q);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_R = ItemInit.registerGlyph(LinguisticGlyph.R);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_S = ItemInit.registerGlyph(LinguisticGlyph.S);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_T = ItemInit.registerGlyph(LinguisticGlyph.T);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_U = ItemInit.registerGlyph(LinguisticGlyph.U);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_V = ItemInit.registerGlyph(LinguisticGlyph.V);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_W = ItemInit.registerGlyph(LinguisticGlyph.W);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_X = ItemInit.registerGlyph(LinguisticGlyph.X);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Y = ItemInit.registerGlyph(LinguisticGlyph.Y);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Z = ItemInit.registerGlyph(LinguisticGlyph.Z);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_0 = ItemInit.registerGlyph(LinguisticGlyph.ZERO);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_1 = ItemInit.registerGlyph(LinguisticGlyph.ONE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_2 = ItemInit.registerGlyph(LinguisticGlyph.TWO);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_3 = ItemInit.registerGlyph(LinguisticGlyph.THREE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_4 = ItemInit.registerGlyph(LinguisticGlyph.FOUR);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_5 = ItemInit.registerGlyph(LinguisticGlyph.FIVE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_6 = ItemInit.registerGlyph(LinguisticGlyph.SIX);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_7 = ItemInit.registerGlyph(LinguisticGlyph.SEVEN);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_8 = ItemInit.registerGlyph(LinguisticGlyph.EIGHT);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_9 = ItemInit.registerGlyph(LinguisticGlyph.NINE);
    public static final RegistryObject<Item> JETSTREAM_WATER_BUCKET = ITEMS.register("jetstream_water_bucket", () -> new BucketItem(FluidInit.JETSTREAM_WATER, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<Item> SALTY_SEAWATER_BUCKET = ITEMS.register("salty_seawater_bucket", () -> new BucketItem(FluidInit.SALTY_SEAWATER, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<Item> RUBYCLAW_CRAB_BUCKET = ItemInit.register("rubyclaw_crab_bucket", () -> new CrabEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.RUBYCLAW_CRAB, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> AQUAIEL_JELLYFISH_BUCKET = ItemInit.register("aquaiel_jellyfish_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.AQUAIEL_JELLYFISH, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> GLITTERTAIL_SHRIMP_BUCKET = ItemInit.register("glittertail_shrimp_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.GLITTERTAIL_SHRIMP, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> THALASSIAN_SEAHORSE_BUCKET = ItemInit.register("thalassian_seahorse_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.THALASSIAN_SEAHORSE, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> AQUAMARINE_AXE = ItemInit.register("aquamarine_axe", () -> new AtlanteanAxe(ToolInit.AQUAMARINE, 3.0f));
    public static final RegistryObject<Item> AQUAMARINE_PICKAXE = ItemInit.register("aquamarine_pickaxe", () -> new AtlanteanPickaxe(ToolInit.AQUAMARINE, 2));
    public static final RegistryObject<Item> AQUAMARINE_SHOVEL = ItemInit.register("aquamarine_shovel", () -> new AtlanteanShovel(ToolInit.AQUAMARINE, 1));
    public static final RegistryObject<Item> AQUAMARINE_HOE = ItemInit.register("aquamarine_hoe", () -> new AtlanteanHoe(ToolInit.AQUAMARINE, 2));
    public static final RegistryObject<Item> AQUAMARINE_SWORD = ItemInit.register("aquamarine_sword", () -> new AtlanteanSword(ToolInit.AQUAMARINE, 4));
    public static final RegistryObject<Item> AQUAMARINE_HAMMER = ItemInit.register("aquamarine_hammer", AquamarineHammer::new);
    public static final RegistryObject<Item> ORICHALCUM_AXE = ItemInit.register("orichalcum_axe", () -> new AtlanteanAxe(ToolInit.ORICHALCUM, 3.0f));
    public static final RegistryObject<Item> ORICHALCUM_PICKAXE = ItemInit.register("orichalcum_pickaxe", () -> new AtlanteanPickaxe(ToolInit.ORICHALCUM, 2));
    public static final RegistryObject<Item> ORICHALCUM_SHOVEL = ItemInit.register("orichalcum_shovel", () -> new AtlanteanShovel(ToolInit.ORICHALCUM, 1));
    public static final RegistryObject<Item> ORICHALCUM_HOE = ItemInit.register("orichalcum_hoe", () -> new AtlanteanHoe(ToolInit.ORICHALCUM, 2));
    public static final RegistryObject<Item> ORICHALCUM_SWORD = ItemInit.register("orichalcum_sword", () -> new AtlanteanSword(ToolInit.ORICHALCUM, 4));
    public static final RegistryObject<Item> ORICHALCUM_HAMMER = ItemInit.register("orichalcum_hammer", OrichalcumHammer::new);
    public static final RegistryObject<Item> AQUAMARINE_HELMET = ItemInit.register("aquamarine_helmet", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> AQUAMARINE_CHESTPLATE = ItemInit.register("aquamarine_chestplate", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> AQUAMARINE_LEGGINGS = ItemInit.register("aquamarine_leggings", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> AQUAMARINE_BOOTS = ItemInit.register("aquamarine_boots", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> BROWN_WROUGHT_HELMET = ItemInit.register("brown_wrought_helmet", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> BROWN_WROUGHT_CHESTPLATE = ItemInit.register("brown_wrought_chestplate", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> BROWN_WROUGHT_LEGGINGS = ItemInit.register("brown_wrought_leggings", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> BROWN_WROUGHT_BOOTS = ItemInit.register("brown_wrought_boots", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> ORICHALCUM_UPGRADE_SMITHING_TEMPLATE = ItemInit.register("orichalcum_upgrade_smithing_template", OrichalcumSmithingTemplateItem::new);
    public static final RegistryObject<Item> ORICHALCUM_HELMET = ItemInit.register("orichalcum_helmet", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> ORICHALCUM_CHESTPLATE = ItemInit.register("orichalcum_chestplate", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> ORICHALCUM_LEGGINGS = ItemInit.register("orichalcum_leggings", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> ORICHALCUM_BOOTS = ItemInit.register("orichalcum_boots", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, ArmorItem.Type.BOOTS, new Item.Properties()));

    public static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        RegistryObject register = ITEMS.register(name, item);
        AtlantisGroupInit.addToMainTabItems(register);
        return register;
    }

    public static <T extends Item> RegistryObject<T> registerToGlyph(String name, Supplier<T> item) {
        RegistryObject register = ITEMS.register(name, item);
        AtlantisGroupInit.addToGylphTabItems(register);
        return register;
    }

    static RegistryObject<Item> registerGlyph(LinguisticGlyph symbol) {
        RegistryObject<Item> registryObject = ItemInit.registerToGlyph("linguistic_glyph_scroll" + symbol.toString(), () -> new LinguisticGlyphScrollItem(symbol));
        scrolls.put(symbol, registryObject);
        return registryObject;
    }

    public static List<Item> getScrolls() {
        return scrolls.values().stream().map(Supplier::get).toList();
    }

    public static RegistryObject<Item> getScroll(LinguisticGlyph a) {
        return scrolls.get((Object)a);
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

