/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mystic.atlantis.init.ItemInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AtlantisModifierInit {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"atlantis");
    public static final RegistryObject<Codec<SeaGrassModifier>> SEEDS_DROP = GLM.register("seeds_drop", SeaGrassModifier.CODEC);

    public static void init(IEventBus bus) {
        GLM.register(bus);
    }

    public static class SeaGrassModifier
    extends LootModifier {
        public static final Supplier<Codec<SeaGrassModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SeaGrassModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SeaGrassModifier::new)));

        public SeaGrassModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            BlockState ctxBlockState;
            int silkTouch;
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            RandomSource random = context.m_230907_();
            if (ctxTool != null && ((silkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)ctxTool)) > 0 || ctxTool.m_41720_() instanceof ShearsItem)) {
                return generatedLoot;
            }
            int bonusLevel = ctxTool != null ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)ctxTool) : 0;
            int seedRarity = (int)(0.5f - (float)(bonusLevel * 2));
            if (!(seedRarity >= 1 && random.m_188503_(seedRarity) != 0 || (ctxBlockState = (BlockState)context.m_78953_(LootContextParams.f_81461_)) != Blocks.f_50037_.m_49966_() && ctxBlockState != Blocks.f_50038_.m_49966_())) {
                generatedLoot.add((Object)new ItemStack((ItemLike)ItemInit.FIRE_MELON_SEEDS.get()));
            }
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }

    private static class DataProvider
    extends GlobalLootModifierProvider {
        public DataProvider(DataGenerator gen, String modid) {
            super(gen.getPackOutput(), modid);
        }

        protected void start() {
            this.add("seeds_drop", (IGlobalLootModifier)new SeaGrassModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50037_).m_6409_()}));
        }
    }

    public static class EventHandlers {
        @SubscribeEvent
        public static void runData(GatherDataEvent event) {
            event.getGenerator().addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new DataProvider(event.getGenerator(), "atlantis"));
        }
    }
}

