/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.base.BubbleMagmaBlock;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class VolcanoesFeature
extends Feature<NoneFeatureConfiguration> {
    FastNoiseLite fnlPerlin = null;

    public VolcanoesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        this.setSeed(context.m_159774_().m_7328_());
        BlockPos pos = context.m_159777_();
        SectionPos chunkPos = SectionPos.m_123199_((BlockPos)pos);
        if ((chunkPos.m_123341_() & 1) == 1 || (chunkPos.m_123342_() & 1) == context.m_225041_().m_188503_(2) || (chunkPos.m_123343_() & 1) == 1) {
            return false;
        }
        if (!context.m_159774_().m_8055_(context.m_159777_().m_7495_()).m_60804_((BlockGetter)context.m_159774_(), pos)) {
            return false;
        }
        if (((Boolean)AtlantisConfig.INSTANCE.volcanoesOn.get()).booleanValue()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            double baseRadius = 15.0;
            double waterLeakage = 0.7;
            double calciteBase = 0.6;
            int volcanoConeSize = 55;
            int volcanoStartHeight = volcanoConeSize - 5;
            double threshold = 0.5;
            for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
                for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                    for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                        mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_((int)x, (int)y + volcanoStartHeight, (int)z);
                        float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                        double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                        if (scaledNoise - waterLeakage >= threshold) {
                            if (mutable.m_123342_() <= context.m_159777_().m_123342_() + (volcanoStartHeight - 14)) {
                                context.m_159774_().m_7731_((BlockPos)mutable, Blocks.f_49990_.m_49966_(), 2);
                                context.m_159774_().m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76193_, 0);
                            }
                        } else if (scaledNoise >= threshold) {
                            context.m_159774_().m_7731_((BlockPos)mutable, Blocks.f_50137_.m_49966_(), 2);
                        }
                        if (!(scaledNoise - calciteBase >= threshold) || mutable.m_123342_() > 70 || mutable.m_123342_() < 40) continue;
                        context.m_159774_().m_7731_((BlockPos)mutable, ((BubbleMagmaBlock)((Object)BlockInit.BUBBLE_MAGMA.get())).m_49966_(), 2);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

