/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.event;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import com.mystic.atlantis.init.EffectsInit;
import com.mystic.atlantis.init.EnchantmentInit;
import com.mystic.atlantis.init.ItemInit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    public static final String NOT_FIRST_SPAWN_NBT = "atlantis.not_first_spawn";
    public static ResourceKey<Level> previousDimension;
    public static Map<ResourceLocation, Integer> map;

    public static boolean hasEnchantment(ItemStack itemStack, Enchantment enchantment) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        return enchantments.containsKey(enchantment);
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        ItemEntity item;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (item = (ItemEntity)entity).m_32055_().m_41720_() == ItemInit.SEASALT.get()) {
            Level world = item.m_9236_();
            ItemEntity item2 = new ItemEntity(world, item.m_20185_(), item.m_20186_(), item.m_20189_(), new ItemStack((ItemLike)ItemInit.SODIUM_NUGGET.get(), item.m_32055_().m_41613_()));
            if (!world.f_46443_) {
                world.m_7967_((Entity)item2);
                if (item2.m_6060_()) {
                    item2.m_20095_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void spikesEffectEvent(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            RandomSource random = player.m_217043_();
            Entity entity = event.getSource().m_7639_();
            if (player.m_21023_((MobEffect)EffectsInit.SPIKES.get()) && player.m_36325_()) {
                entity.m_6469_(player.m_269291_().m_269374_((Entity)player), (float)CommonEvents.getDamage(3, (Random)random));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (((Boolean)AtlantisConfig.INSTANCE.startInAtlantis.get()).booleanValue() && event.getEntity().m_20194_() != null) {
            ServerLevel atlantisLevel = event.getEntity().m_20194_().m_129880_(DimensionAtlantis.ATLANTIS_WORLD);
            CompoundTag tag = event.getEntity().getPersistentData();
            CompoundTag persistedTag = tag.m_128469_("PlayerPersisted");
            if (DimensionAtlantis.ATLANTIS_WORLD != null) {
                boolean isFirstTimeSpawning;
                boolean bl = isFirstTimeSpawning = !persistedTag.m_128471_(NOT_FIRST_SPAWN_NBT);
                if (isFirstTimeSpawning && atlantisLevel != null) {
                    persistedTag.m_128379_(NOT_FIRST_SPAWN_NBT, true);
                    tag.m_128365_("PlayerPersisted", (Tag)persistedTag);
                    Player player = event.getEntity();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CommonEvents.sendPlayerToDimension(serverPlayer, atlantisLevel, new Vec3((double)atlantisLevel.m_6018_().m_6106_().m_6789_(), 100.0, (double)atlantisLevel.m_6018_().m_6106_().m_6526_()));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            ServerLevel serverLevel = serverPlayer.m_284548_();
            if (DimensionAtlantis.ATLANTIS_DIMENSION != null && previousDimension == DimensionAtlantis.ATLANTIS_WORLD) {
                Optional bedPos;
                serverPlayer.m_9158_(DimensionAtlantis.ATLANTIS_WORLD, serverPlayer.m_20183_(), serverPlayer.m_6080_(), true, false);
                serverPlayer.m_284548_().m_8733_(serverPlayer.m_20183_(), 16.0f);
                if (serverPlayer.m_8961_() != null && (bedPos = Player.m_36130_((ServerLevel)DimensionAtlantis.ATLANTIS_DIMENSION, (BlockPos)serverPlayer.m_8961_(), (float)serverPlayer.m_8962_(), (boolean)serverPlayer.m_8964_(), (boolean)false)).isEmpty()) {
                    serverPlayer.m_9158_(DimensionAtlantis.ATLANTIS_WORLD, serverLevel.m_220360_(), serverPlayer.m_6080_(), true, false);
                    CommonEvents.sendPlayerToDimension(serverPlayer, DimensionAtlantis.ATLANTIS_DIMENSION, new Vec3((double)serverPlayer.m_8961_().m_123341_(), (double)serverPlayer.m_8961_().m_123342_(), (double)serverPlayer.m_8961_().m_123343_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDeathEvent(LivingDeathEvent event) {
        previousDimension = event.getEntity().m_9236_().m_46472_();
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack stack : player.m_6168_()) {
                if (!CommonEvents.hasEnchantment(stack, (Enchantment)EnchantmentInit.LIGHTNING_PROTECTION.get()) || !event.getSource().m_276093_(DamageTypes.f_268450_)) continue;
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
        }
    }

    public static ServerLevel getDimension(ResourceKey<Level> arg, ServerPlayer player) {
        return Objects.requireNonNull(player.m_20194_()).m_129880_(arg);
    }

    private static void sendPlayerToDimension(ServerPlayer serverPlayer, ServerLevel targetWorld, Vec3 targetVec) {
        targetWorld.m_46865_(new BlockPos((int)targetVec.f_82479_, (int)targetVec.f_82480_, (int)targetVec.f_82481_));
        serverPlayer.m_8999_(targetWorld, targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_(), serverPlayer.m_146908_(), serverPlayer.m_146909_());
    }

    private static int getDamage(int i, Random random) {
        return i > 10 ? i - 10 : 1 + random.nextInt(4);
    }

    private static boolean isAtlanteanBiome(ResourceKey<Biome> key) {
        return key.m_135782_().m_135827_().equals("atlantis");
    }
}

