/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.entities.GlittertailShrimpEntity;
import com.mystic.atlantis.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarfishEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.walk");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.idle");
    private static final RawAnimation EAT_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.eat");
    private static final RawAnimation JUMP_ANIMATION = RawAnimation.begin().thenLoop("animation.starfish.jump");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarfishEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6040_() {
        return true;
    }

    public static AttributeSupplier.Builder createStarfishAttributes() {
        return StarfishEntity.m_21552_().m_22268_(Attributes.f_22279_, 0.6);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean canSpawn(EntityType<?> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 65 && 70 >= pos.m_123342_() && world.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    protected boolean m_7341_(Entity entity) {
        return !entity.m_20160_() && !entity.m_20363_((Entity)this);
    }

    public void m_6083_() {
        Player player;
        Entity entity = this.m_20202_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_()) {
            this.m_8127_();
        }
        if (!(entity.m_6084_() || entity instanceof GlittertailShrimpEntity || entity instanceof Player || this.m_7341_(entity))) {
            this.m_8127_();
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            if (entity instanceof Player) {
                player = (Player)entity;
                this.m_6034_(player.m_20185_(), Math.max(player.m_20186_() + (double)player.m_20192_(), player.m_20186_()), player.m_20189_());
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 1, 5));
                if (player.m_21223_() > 1.0f) {
                    player.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f);
                }
                if (!player.m_6084_()) {
                    this.m_6038_();
                }
            } else if (entity instanceof GlittertailShrimpEntity) {
                GlittertailShrimpEntity shrimp = (GlittertailShrimpEntity)entity;
                this.m_6034_(shrimp.m_20185_(), Math.max(shrimp.m_20186_() + (double)shrimp.m_20192_(), shrimp.m_20186_()), shrimp.m_20189_());
                shrimp.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 1, 5));
                shrimp.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f);
                if (!shrimp.m_6084_()) {
                    this.m_6038_();
                }
            }
        }
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.f_21345_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{StarfishEntity.class}));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.SHRIMP.get()}), false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, GlittertailShrimpEntity.class, true));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == ItemInit.SHRIMP.get()) {
            if (player instanceof ServerPlayer) {
                if (this.m_6898_(((Item)ItemInit.SHRIMP.get()).m_7968_())) {
                    if (!this.m_9236_().f_46443_ && this.m_5957_()) {
                        this.m_142075_(player, hand, ((Item)ItemInit.SHRIMP.get()).m_7968_());
                        this.m_27595_(player);
                        this.m_146852_(GameEvent.f_223708_, (Entity)this);
                        this.m_142606_((ServerLevel)player.m_20193_(), (AgeableMob)this);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6898_(ItemStack stack) {
        return StarfishEntity.isTempting(stack);
    }

    private static boolean isTempting(ItemStack stack) {
        return stack.m_150930_((Item)ItemInit.SHRIMP.get());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        StarfishEntity starfishEntity = (StarfishEntity)entity;
        if (starfishEntity.m_27593_() && this.m_7848_(starfishEntity)) {
            return (StarfishEntity)starfishEntity.m_6095_().m_20615_((Level)world);
        }
        return entity;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_6710_((LivingEntity)this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (this.m_20159_()) {
            event.getController().setAnimation(EAT_ANIMATION);
        } else if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (this.m_6069_()) {
            event.getController().setAnimation(JUMP_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

