/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RubyclawCrabEntity
extends Animal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(RubyclawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(RubyclawCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final Ingredient TEMPT_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41867_});
    static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.walk");
    static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.idle");
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<RubyclawCrabEntity> mainController = new AnimationController((GeoAnimatable)this, "crabController", 2, this::mainPredicate);

    public RubyclawCrabEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public static AttributeSupplier.Builder createCrabAttributes() {
        return RubyclawCrabEntity.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void m_142278_(CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
    }

    public ItemStack m_28282_() {
        return ((Item)ItemInit.RUBYCLAW_CRAB_BUCKET.get()).m_7968_();
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_6040_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.mainController});
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public static boolean canSpawn(EntityType<?> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 65 && 70 >= pos.m_123342_() && world.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.f_19804_.m_135381_(VARIANT, (Object)(this.f_19796_.m_188503_(100) > 50 ? 1 : 2));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_20258_(CompoundTag nbt) {
        this.m_27497_(nbt.m_128471_("FromBucket"));
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
        super.m_20258_(nbt);
    }

    public CompoundTag m_20240_(CompoundTag nbt) {
        nbt.m_128379_("FromBucket", this.m_27487_());
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        return super.m_20240_(nbt);
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{RubyclawCrabEntity.class}));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.35));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.05, TEMPT_ITEMS, false));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Blocks.f_50037_.m_5456_()) {
            if (player instanceof ServerPlayer) {
                if (this.m_6898_(Blocks.f_50037_.m_5456_().m_7968_())) {
                    if (!this.m_9236_().f_46443_ && this.m_5957_()) {
                        this.m_142075_(player, hand, Blocks.f_50037_.m_5456_().m_7968_());
                        this.m_27595_(player);
                        this.m_146852_(GameEvent.f_223708_, (Entity)this);
                        this.m_142606_((ServerLevel)player.m_20193_(), (AgeableMob)this);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() == Items.f_42447_) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6898_(ItemStack stack) {
        return RubyclawCrabEntity.isTempting(stack);
    }

    private static boolean isTempting(ItemStack stack) {
        return TEMPT_ITEMS.test(stack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        RubyclawCrabEntity crab = (RubyclawCrabEntity)entity;
        if (crab.m_27593_() && this.m_7848_(crab)) {
            return (RubyclawCrabEntity)crab.m_6095_().m_20615_((Level)world);
        }
        return crab;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_6710_((LivingEntity)this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    private <P extends GeoAnimatable> PlayState mainPredicate(AnimationState<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (!this.isMovingSlowly()) {
            event.getController().setAnimation(IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

