/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.entities.RubyclawCrabEntity;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CoconutCrabEntity
extends RubyclawCrabEntity
implements NeutralMob,
GeoAnimatable {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<CoconutCrabEntity> mainController = new AnimationController((GeoAnimatable)this, "coconutCrabController", 2, this::mainPredicate);
    static final RawAnimation NUTON_ANIMATION = RawAnimation.begin().thenLoop("animation.coconut_crab.nuton");
    static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.walk");
    static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.crab.idle");
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public CoconutCrabEntity(EntityType<? extends RubyclawCrabEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder createCoconutCrabAttributes() {
        return CoconutCrabEntity.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.6);
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_();
    }

    @Override
    public boolean m_6785_(double distanceSquared) {
        return !this.m_8077_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void m_20258_(CompoundTag nbt) {
        super.m_20258_(nbt);
    }

    @Override
    public CompoundTag m_20240_(CompoundTag nbt) {
        return super.m_20240_(nbt);
    }

    @Override
    public boolean m_6573_(Player player) {
        return true;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.f_21345_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CoconutCrabEntity.class}));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41867_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CoconutCrabEntity)this).m_21674_(arg_0)));
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Blocks.f_50037_.m_5456_() && player instanceof ServerPlayer && this.m_6898_(Blocks.f_50037_.m_5456_().m_7968_()) && !this.m_9236_().f_46443_ && this.m_5957_()) {
            this.m_142075_(player, hand, Blocks.f_50037_.m_5456_().m_7968_());
            this.m_27595_(player);
            this.m_146852_(GameEvent.f_223708_, (Entity)this);
            this.m_142606_((ServerLevel)player.m_20193_(), (AgeableMob)this);
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return CoconutCrabEntity.isTempting(stack);
    }

    private static boolean isTempting(ItemStack stack) {
        return stack.m_150930_(Blocks.f_50037_.m_5456_());
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        CoconutCrabEntity crabEntity = (CoconutCrabEntity)entity;
        if (crabEntity.m_27593_() && this.m_7848_(crabEntity)) {
            return (CoconutCrabEntity)crabEntity.m_6095_().m_20615_((Level)world);
        }
        return entity;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_6710_((LivingEntity)this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, true));
    }

    @Override
    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    private <P extends GeoAnimatable> PlayState mainPredicate(AnimationState<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (!this.isMovingSlowly()) {
            if (this.f_19864_) {
                event.getController().setAnimation(NUTON_ANIMATION);
            } else {
                event.getController().setAnimation(IDLE_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    public void m_7870_(int i) {
        this.remainingPersistentAngerTime = i;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@javax.annotation.Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.mainController});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public double getTick(Object o) {
        return 0.0;
    }
}

