/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.dimension;

import com.mojang.datafixers.util.Pair;
import com.mystic.atlantis.biomes.AtlantisBiomeSource;
import com.mystic.atlantis.datagen.BiomeInit;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimensionAtlantis {
    public static ResourceKey<Level> ATLANTIS_WORLD = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("atlantis:atlantis"));
    public static final ResourceKey<DimensionType> ATLANTIS_DIMENSION_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("atlantis:atlantis"));
    public static ResourceKey<LevelStem> ATLANTIS_DIMENSION_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)new ResourceLocation("atlantis", "atlantis"));
    public static final ResourceLocation ATLANTIS_DIMENSION_EFFECT = new ResourceLocation("atlantis", "skyeffect");
    public static DimensionType ATLANTIS_TYPE;
    public static ResourceKey<NoiseGeneratorSettings> ATLANTIS_DIMENSION_NOISE_SETTING;
    public static ServerLevel ATLANTIS_DIMENSION;

    public static boolean isAtlantisDimension(Level world) {
        return world != null && world.m_46472_().equals(ATLANTIS_WORLD);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ATLANTIS_TYPE = (DimensionType)event.getServer().m_206579_().m_175515_(Registries.f_256787_).m_6246_(ATLANTIS_DIMENSION_TYPE_KEY);
        ATLANTIS_DIMENSION = event.getServer().m_129880_(ATLANTIS_WORLD);
    }

    public static void registerBiomeSources() {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)new ResourceLocation("atlantis", "atlantis_biome_source"), AtlantisBiomeSource.CODEC);
    }

    public DimensionAtlantis(BootstapContext<LevelStem> context) {
        HolderGetter holderGetter = context.m_255420_(Registries.f_256952_);
        HolderGetter holderGetter1 = context.m_255420_(Registries.f_256787_);
        HolderGetter holderGetter2 = context.m_255420_(Registries.f_256932_);
        context.m_255272_(ATLANTIS_DIMENSION_STEM, (Object)new LevelStem((Holder)holderGetter1.m_255043_(ATLANTIS_DIMENSION_TYPE_KEY), (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.GOO_LAGOONS_KEY)), Pair.of((Object)Climate.m_186788_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.COCONUT_ISLES_KEY)), Pair.of((Object)Climate.m_186788_((float)0.3f, (float)0.2f, (float)0.1f, (float)0.2f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.ATLANTEAN_GARDEN_KEY)), Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.1f, (float)0.2f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.ATLANTIS_BIOME_KEY)), Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.1f, (float)0.1f, (float)0.2f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.AQUAIEL_JELLYFISH_FIELDS_KEY)), Pair.of((Object)Climate.m_186788_((float)0.2f, (float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.ATLANTEAN_ISLANDS_BIOME_KEY)), Pair.of((Object)Climate.m_186788_((float)0.1f, (float)0.2f, (float)0.1f, (float)0.1f, (float)1.0f, (float)0.0f, (float)0.0f), (Object)holderGetter.m_255043_(BiomeInit.VOLCANIC_DARKSEA_KEY))))), (Holder)holderGetter2.m_255043_(ATLANTIS_DIMENSION_NOISE_SETTING))));
    }

    static {
        ATLANTIS_DIMENSION_NOISE_SETTING = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("atlantis", "atlantis"));
    }
}

