/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.dimension;

import com.mystic.atlantis.blocks.base.AtlanteanPortalBlock;
import com.mystic.atlantis.blocks.base.AtlanteanPortalFrame;
import com.mystic.atlantis.blocks.base.HardenedCalciteBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.dimension.AtlanteanITeleporter;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.POITypesInit;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class AtlanteanPortalForcer
implements AtlanteanITeleporter {
    private static final DirectionProperty FACING = AtlanteanPortalFrame.f_53042_;
    private static final BooleanProperty HAS_EYE = AtlanteanPortalFrame.f_53043_;
    protected final ServerLevel level;

    public AtlanteanPortalForcer(ServerLevel pLevel) {
        this.level = pLevel;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos pPos, boolean isInAtlantis, WorldBorder pWorldBorder) {
        PoiManager poimanager = this.level.m_8904_();
        int i = isInAtlantis ? 16 : 128;
        poimanager.m_27056_((LevelReader)this.level, pPos, i);
        Optional<PoiRecord> optional = poimanager.m_27166_(p_230634_ -> POITypesInit.ATLANTEAN_PORTAL.get() == p_230634_.get(), pPos, i, PoiManager.Occupancy.ANY).filter(p_192981_ -> pWorldBorder.m_61937_(p_192981_.m_27257_())).filter(p_192990_ -> this.level.m_8055_(p_192990_.m_27257_()).m_61138_(AtlanteanPortalBlock.AXIS)).findFirst();
        return optional.map(p_192975_ -> {
            BlockPos blockpos = p_192975_.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61365_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_192978_ -> this.level.m_8055_(p_192978_) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(BlockPos pPos, Direction.Axis pAxis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pAxis);
        double d0 = -1.0;
        BlockPos blockpos = pPos;
        double d1 = -1.0;
        BlockPos blockpos1 = pPos;
        WorldBorder worldborder = this.level.m_6857_();
        int i = Math.min(this.level.m_151558_(), this.level.m_141937_() + this.level.m_143344_()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.m_121935_((BlockPos)pPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockpos$mutableblockpos1.m_123341_(), blockpos$mutableblockpos1.m_123343_()));
            if (!worldborder.m_61937_((BlockPos)blockpos$mutableblockpos1) || !worldborder.m_61937_((BlockPos)blockpos$mutableblockpos1.m_122175_(direction, 1))) continue;
            blockpos$mutableblockpos1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= this.level.m_141937_(); --l) {
                blockpos$mutableblockpos1.m_142448_(l);
                if (!this.canPortalReplaceBlock(blockpos$mutableblockpos1)) continue;
                int i1 = l;
                while (l > this.level.m_141937_() && this.canPortalReplaceBlock(blockpos$mutableblockpos1.m_122173_(Direction.DOWN))) {
                    int j1;
                    if (l + 4 <= i && ((j1 = i1 - l) <= 0 || j1 >= 3)) {
                        blockpos$mutableblockpos1.m_142448_(l);
                        if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 0)) {
                            double d2 = pPos.m_123331_((Vec3i)blockpos$mutableblockpos1);
                            if (this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)blockpos$mutableblockpos1, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                                d0 = d2;
                                blockpos = blockpos$mutableblockpos1.m_7949_();
                            }
                            if (d0 == -1.0 && (d1 == -1.0 || d1 > d2)) {
                                d1 = d2;
                                blockpos1 = blockpos$mutableblockpos1.m_7949_();
                            }
                        }
                    }
                    --l;
                }
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
        }
        if (DimensionAtlantis.isAtlantisDimension((Level)this.level)) {
            this.makePortalOverworld(this.level, blockpos);
        } else {
            this.makePortalAtlantis(this.level, blockpos);
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pPos) {
        BlockState blockstate = this.level.m_8055_((BlockPos)pPos);
        return blockstate.m_247087_() && blockstate.m_60819_().m_76178_();
    }

    private boolean canHostFrame(BlockPos pOriginalPos, BlockPos.MutableBlockPos pOffsetPos, Direction pDirection, int pOffsetScale) {
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 3; ++j) {
                pOffsetPos.m_122154_((Vec3i)pOriginalPos, pDirection.m_122429_() * i + pDirection.m_122429_() * pOffsetScale, j, pDirection.m_122431_() * i + pDirection.m_122431_() * pOffsetScale);
                if (j < 0 && !this.level.m_8055_((BlockPos)pOffsetPos).m_280296_()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(pOffsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    private void makePortalAtlantis(ServerLevel pServerLevel, BlockPos blockpos) {
        int i = blockpos.m_123341_();
        int j = blockpos.m_123342_() - 2;
        int k = blockpos.m_123343_();
        BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 5), (int)(k + 2)).forEach(p_207578_ -> pServerLevel.m_46597_(p_207578_, Blocks.f_50016_.m_49966_()));
        AtlanteanPortalForcer.makePortalFrameAtlantis(pServerLevel, blockpos);
        BlockPos.m_121976_((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(p_184101_ -> pServerLevel.m_46597_(p_184101_, ((HardenedCalciteBlock)((Object)((Object)BlockInit.HARDENED_CALCITE_BLOCK.get()))).m_49966_()));
        BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 1), (int)(k + 1)).forEach(p_184101_ -> pServerLevel.m_46597_(p_184101_, ((AtlanteanPortalBlock)((Object)((Object)BlockInit.ATLANTEAN_PORTAL.get()))).m_49966_()));
    }

    private void makePortalOverworld(ServerLevel pServerLevel, BlockPos blockpos) {
        int i = blockpos.m_123341_();
        int j = blockpos.m_123342_() - 2;
        int k = blockpos.m_123343_();
        BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 5), (int)(k + 2)).forEach(p_207578_ -> pServerLevel.m_46597_(p_207578_, Blocks.f_49990_.m_49966_()));
        AtlanteanPortalForcer.makePortalFrameOverworld(pServerLevel, blockpos);
        BlockPos.m_121976_((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(p_184101_ -> pServerLevel.m_46597_(p_184101_, ((HardenedCalciteBlock)((Object)((Object)BlockInit.HARDENED_CALCITE_BLOCK.get()))).m_49966_()));
        BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 1), (int)(k + 1)).forEach(p_184101_ -> pServerLevel.m_46597_(p_184101_, ((AtlanteanPortalBlock)((Object)((Object)BlockInit.ATLANTEAN_PORTAL.get()))).m_49966_()));
    }

    public static void makePortalFrameAtlantis(ServerLevel pServerLevel, BlockPos blockpos) {
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(-1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(0, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(0, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        pServerLevel.m_46597_(blockpos.m_7918_(-1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static void makePortalFrameOverworld(ServerLevel pServerLevel, BlockPos blockpos) {
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(-1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(0, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(1, -1, 2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, 1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, 0), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(-2, -1, -1), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(0, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        pServerLevel.m_46597_(blockpos.m_7918_(-1, -1, -2), (BlockState)((BlockState)((BlockState)((Block)BlockInit.ATLANTEAN_PORTAL_FRAME.get()).m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)HAS_EYE, (Comparable)Boolean.valueOf(true))).m_61124_(Seabloom.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }
}

