/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.base.Coconut;
import com.mystic.atlantis.blocks.base.PalmLeavesBlock;
import com.mystic.atlantis.blocks.base.PalmLogBlock;
import com.mystic.atlantis.blocks.base.SeasaltChunkBlock;
import com.mystic.atlantis.datagen.WaterAttachedToLeavesDecorator;
import com.mystic.atlantis.feature.AtlantisFeature;
import com.mystic.atlantis.init.BlockInit;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.Direction;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.registries.RegistryObject;

public class ConfiguredFeaturesInit {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_CUPRUM_CONFIGURED = Atlantis.configuredFeatureKey("ancient_cuprum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AQUAMARINE_CONFIGURED = Atlantis.configuredFeatureKey("aquamarine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SUNKEN_GRAVEL_CONFIGURED = Atlantis.configuredFeatureKey("sunken_gravel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SALT_ROCK_GEODE_CONFIGURED = Atlantis.configuredFeatureKey("salt_rock_geode");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE_CONFIGURED = Atlantis.configuredFeatureKey("palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NYMPH_TREE_CONFIGURED = Atlantis.configuredFeatureKey("nymph_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWSTONES_CONFIGURED = Atlantis.configuredFeatureKey("glowstones");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SALTY_SEA_LAKE_CONFIGURED = Atlantis.configuredFeatureKey("salty_sea_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEABLOOM_CONFIGURED = Atlantis.configuredFeatureKey("seabloom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VOLCANOES_CONFIGURED = Atlantis.configuredFeatureKey("volcano");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ISLANDS_CONFIGURED = Atlantis.configuredFeatureKey("islands");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JETSTREAM_LAKE_CONFIGURED = Atlantis.configuredFeatureKey("jetstream_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHELL_BLOCK_CONFIGURED = Atlantis.configuredFeatureKey("shell_block");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GARDEN_FOLIAGE_CONFIGURED = Atlantis.configuredFeatureKey("garden_foliage");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEASHROOM_CONFIGURED = Atlantis.configuredFeatureKey("seashroom");

    public ConfiguredFeaturesInit(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ConfiguredFeaturesInit.registerOre(context, ANCIENT_CUPRUM_CONFIGURED, BlockInit.ANCIENT_CUPRUM_ORE, BlockInit.DEEPSLATE_ANCIENT_CUPRUM_ORE, 6, 0);
        ConfiguredFeaturesInit.registerOre(context, AQUAMARINE_CONFIGURED, BlockInit.AQUAMARINE_ORE, BlockInit.DEEPSLATE_AQUAMARINE_ORE, 4, 0);
        ConfiguredFeaturesInit.registerOre(context, SUNKEN_GRAVEL_CONFIGURED, BlockInit.SUNKEN_GRAVEL, BlockInit.SUNKEN_GRAVEL, 40, 0);
        ConfiguredFeaturesInit.register(context, SALT_ROCK_GEODE_CONFIGURED, Feature.f_159728_, new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.SEASALT_CHUNK.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.SEASALT_CHUNK.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.SEASALT_CHUNK.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.HARDENED_CALCITE_BLOCK.get())), List.of(((SeasaltChunkBlock)((Object)BlockInit.SEASALT_CHUNK.get())).m_49966_()), BlockTags.f_215825_, BlockTags.f_144260_), new GeodeLayerSettings(3.7, 4.2, 5.3, 6.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.085, false, (IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.f_146476_, -16, 16, 0.05, 1));
        ConfiguredFeaturesInit.register(context, NYMPH_TREE_CONFIGURED, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.NYMPH_LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(25, 20, 22), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.NYMPH_LEAVES.get())), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)3), 256), Optional.empty(), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1, OptionalInt.of(5))).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockInit.SEABED.get()))).m_68244_().m_68251_());
        ConfiguredFeaturesInit.register(context, PALM_TREE_CONFIGURED, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((PalmLogBlock)((Object)BlockInit.PALM_LOG.get())).m_49966_().m_61124_((Property)PalmLogBlock.f_55923_, (Comparable)Direction.Axis.Y))), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 2), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((BlockState)((BlockState)((PalmLeavesBlock)((Object)BlockInit.PALM_LEAVES.get())).m_49966_().m_61124_((Property)PalmLeavesBlock.f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)PalmLeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PalmLeavesBlock.f_221367_, (Comparable)Boolean.valueOf(false)))), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.f_146476_), Optional.empty(), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50062_)).m_68249_(List.of(new WaterAttachedToLeavesDecorator(0.25f, 0, 0, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Coconut)((Object)BlockInit.COCONUT.get())).m_49966_()), List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST)))).m_68244_().m_68251_());
        ConfiguredFeaturesInit.registerNone(context, GLOWSTONES_CONFIGURED, AtlantisFeature.GLOWSTONES_FEATURE);
        ConfiguredFeaturesInit.registerNone(context, ISLANDS_CONFIGURED, AtlantisFeature.ISLANDS_FEATURE);
        ConfiguredFeaturesInit.registerNone(context, VOLCANOES_CONFIGURED, AtlantisFeature.VOLCANOES_FEATURE);
        ConfiguredFeaturesInit.registerNone(context, SEABLOOM_CONFIGURED, AtlantisFeature.SEABLOOM_FEATURE);
        ConfiguredFeaturesInit.registerNone(context, GARDEN_FOLIAGE_CONFIGURED, AtlantisFeature.GARDEN_FOLIAGE_FEATURE);
        ConfiguredFeaturesInit.registerLake(context, JETSTREAM_LAKE_CONFIGURED, (Block)BlockInit.JETSTREAM_WATER.get(), Blocks.f_50069_);
        ConfiguredFeaturesInit.registerNone(context, SEASHROOM_CONFIGURED, AtlantisFeature.SEASHROOM_FEATURE);
        ConfiguredFeaturesInit.registerLake(context, SALTY_SEA_LAKE_CONFIGURED, (Block)BlockInit.SALTY_SEAWATER.get(), Blocks.f_50069_);
        ConfiguredFeaturesInit.registerNone(context, SHELL_BLOCK_CONFIGURED, AtlantisFeature.SHELL_BLOCK_FEATURE);
    }

    private static void registerLake(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Block fluid, Block barrier) {
        ConfiguredFeaturesInit.register(context, key, Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)fluid), (BlockStateProvider)BlockStateProvider.m_191382_((Block)barrier)));
    }

    private static <T extends Block, V extends Block> void registerOre(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, RegistryObject<Block> regular, RegistryObject<Block> deepslate, int size, int discardChanceOnAirExposure) {
        ConfiguredFeaturesInit.register(context, key, Feature.f_65731_, new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)((Block)regular.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144267_), (BlockState)((Block)deepslate.get()).m_49966_())), size, (float)discardChanceOnAirExposure));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    private static <T extends Feature<NoneFeatureConfiguration>> void registerNone(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, RegistryObject<T> holder) {
        context.m_255272_(key, (Object)new ConfiguredFeature((Feature)holder.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
    }
}

