/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class AtlantisMainProvider
extends BlockStateProvider {
    private final PackOutput packOutput;
    private final ExistingFileHelper existingFileHelper;
    List<Proxied> providers;

    @SafeVarargs
    public AtlantisMainProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper, Function<AtlantisMainProvider, Proxied> ... providers) {
        super(packOutput, "atlantis", existingFileHelper);
        this.packOutput = packOutput;
        this.existingFileHelper = existingFileHelper;
        this.providers = Stream.of(providers).map(provider -> (Proxied)((Object)((Object)provider.apply(this)))).collect(Collectors.toList());
    }

    protected void registerStatesAndModels() {
        for (Proxied provider : this.providers) {
            provider.registerStatesAndModels();
        }
    }

    public PackOutput getPackOutput() {
        return this.packOutput;
    }

    public ExistingFileHelper getExistingFileHelper() {
        return this.existingFileHelper;
    }

    public static abstract class Proxied
    extends BlockStateProvider {
        private final AtlantisMainProvider provider;

        public Proxied(AtlantisMainProvider provider) {
            super(provider.getPackOutput(), "atlantis", provider.getExistingFileHelper());
            this.provider = provider;
        }

        public BlockModelProvider models() {
            return this.provider.models();
        }

        public ItemModelProvider itemModels() {
            return this.provider.itemModels();
        }

        public VariantBlockStateBuilder getVariantBuilder(Block b) {
            return this.provider.getVariantBuilder(b);
        }

        public MultiPartBlockStateBuilder getMultipartBuilder(Block b) {
            return this.provider.getMultipartBuilder(b);
        }

        public ResourceLocation key(Block block) {
            return BuiltInRegistries.f_256975_.m_7981_((Object)block);
        }

        public boolean registered(Block block) {
            return this.provider.registeredBlocks.containsKey(block);
        }

        public abstract void registerStatesAndModels();
    }
}

