/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.blocks.BlockType;
import com.mystic.atlantis.blocks.ancient_cuprum.CuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumBulbBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumDoorBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumFullBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumGrateBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumSlabBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumStairsBlock;
import com.mystic.atlantis.blocks.ancient_cuprum.WeatheringCuprumTrapdoorBlock;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class AtlantisEnglishLanguageProvider
extends LanguageProvider {
    public AtlantisEnglishLanguageProvider(PackOutput generator) {
        super(generator, "atlantis", "en_us");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)BlockInit.ORICHALCUM_BLOCK, "Block of Orichalcum");
        this.addBlock((Supplier)BlockInit.WATERFALL_BLOCK, "Waterfall Block");
        this.addBlock((Supplier)BlockInit.WAVE_BLOCK, "Wave Block");
        this.addBlock((Supplier)BlockInit.CRYSTAL_TRANSFERENCE_BLOCK, "Crystal Transference Block");
        this.addBlock((Supplier)BlockInit.ATLANTEAN_PORTAL_FRAME, "Atlantean Portal Frame");
        this.addBlock((Supplier)BlockInit.ATLANTEAN_PORTAL, "Atlantean Portal");
        this.addBlock((Supplier)BlockInit.JETSTREAM_WATER, "Jetstream Water");
        this.addBlock((Supplier)BlockInit.SALTY_SEAWATER, "Salty Seawater");
        this.addBlock((Supplier)BlockInit.TUBEN_POT, "Tuben Pot");
        this.addBlock((Supplier)BlockInit.BELEN_POT, "Belen Pot");
        this.addBlock((Supplier)BlockInit.TOPER_POT, "Toper Pot");
        this.addBlock((Supplier)BlockInit.SNOWN_POT, "Snown Pot");
        this.addBlock((Supplier)BlockInit.HORPEN_POT, "Horpen Pot");
        this.addBlock((Supplier)BlockInit.CELEN_POT, "Celen Pot");
        this.addBlock((Supplier)BlockInit.OBEMO_POT, "Obemo Pot");
        this.addBlock((Supplier)BlockInit.COCONUT_SLICE, "Coconut Slice");
        this.addBlock((Supplier)BlockInit.COCONUT, "Coconut");
        this.addBlock((Supplier)BlockInit.CARVED_COCONUT, "Carved Coconut");
        this.addBlock((Supplier)BlockInit.SATIRE_LANTERN, "Satire Lantern");
        this.addBlock((Supplier)BlockInit.PALM_LOG, "Palm Log");
        this.addBlock((Supplier)BlockInit.STRIPPED_PALM_LOG, "Stripped Palm Log");
        this.addBlocksFromType(BlockInit.PALM_PLANKS, "Palm", true);
        this.addBlock((Supplier)BlockInit.STRIPPED_NYMPH_LOG, "Stripped Nymph Log");
        this.addBlocksFromType(BlockInit.NYMPH_PLANKS, "Nymph", true);
        this.addBlock((Supplier)BlockInit.SEASHROOM, "Seashroom");
        this.addBlock((Supplier)BlockInit.TUBER_UP, "Tuber Up");
        this.addBlock((Supplier)BlockInit.BLUE_LILY, "Blue Lily");
        this.addBlock((Supplier)BlockInit.BURNT_DEEP, "Burnt Deep");
        this.addBlock((Supplier)BlockInit.ANEMONE, "Anemone Block");
        this.addBlock((Supplier)BlockInit.OYSTER_SHELL_BLOCK, "Oyster Shell Block");
        this.addBlock((Supplier)BlockInit.NAUTILUS_SHELL_BLOCK, "Nautilus Shell Block");
        this.addBlock((Supplier)BlockInit.CRACKED_OYSTER_SHELL, "Cracked Oyster Shell");
        this.addBlock((Supplier)BlockInit.CRACKED_NAUTILUS_SHELL, "Cracked Nautilus Shell");
        this.addBlock((Supplier)BlockInit.CRACKED_MOSSY_OYSTER_SHELL, "Cracked Mossy Oyster Shell");
        this.addBlock((Supplier)BlockInit.CRACKED_MOSSY_NAUTILUS_SHELL, "Cracked Mossy Nautilus Shell");
        this.addBlock((Supplier)BlockInit.MOSSY_OYSTER_SHELL, "Mossy Oyster Shell");
        this.addBlock((Supplier)BlockInit.MOSSY_NAUTILUS_SHELL, "Mossy Nautilus Shell");
        this.addBlock((Supplier)BlockInit.SODIUM_BOMB, "Sodium Bomb");
        this.addBlock((Supplier)BlockInit.SEASALT_CHUNK, "Seasalt Chunk");
        this.addBlock((Supplier)BlockInit.SUNKEN_GRAVEL, "Sunken Gravel");
        this.addBlock((Supplier)BlockInit.CRACKED_GLOWSTONE, "Cracked Glowstone");
        this.addBlock((Supplier)BlockInit.DEAD_GLOWSTONE, "Dead Glowstone");
        this.addBlock((Supplier)BlockInit.ALGAE_DETRITUS_STONE, "Algae Detritus Stone");
        this.addBlock((Supplier)BlockInit.DETRITUS_SANDSTONE, "Detritus Sandstone");
        this.addBlock((Supplier)BlockInit.LUMINESCENT_PRISMARINE, "Luminescent Prismarine");
        this.addBlock((Supplier)BlockInit.BUBBLE_MAGMA, "Bubble Magma");
        this.addBlock((Supplier)BlockInit.PALM_LEAVES, "Palm Leaves");
        this.addBlock((Supplier)BlockInit.NYMPH_LEAVES, "Nymph Leaves");
        this.addBlock((Supplier)BlockInit.NYMPH_LOG, "Nymph Log");
        this.addBlock((Supplier)BlockInit.AQUAMARINE_ORE, "Aquamarine Ore");
        this.addBlock((Supplier)BlockInit.DEEPSLATE_AQUAMARINE_ORE, "Deepslate Aquamarine Ore");
        this.addBlock((Supplier)BlockInit.SEABED, "Seabed");
        this.addBlock((Supplier)BlockInit.OCEAN_LANTERN, "Ocean Lantern");
        this.addBlock((Supplier)BlockInit.SURGE_LANTERN, "Surge Lantern");
        this.addBlock((Supplier)BlockInit.ATLANTEAN_CORE, "Atlantean Core");
        this.addBlock((Supplier)BlockInit.BLOCK_OF_AQUAMARINE, "Block Of Aquamarine");
        this.addBlock((Supplier)BlockInit.CHISELED_GOLDEN_BLOCK, "Chiseled Golden Block");
        this.addBlock((Supplier)BlockInit.CHISELED_GOLDEN_AQUAMARINE, "Chiseled Golden Aquamarine");
        this.addBlock((Supplier)BlockInit.BLACK_PEARL_BLOCK, "Black Pearl Block");
        this.addBlock((Supplier)BlockInit.BLUE_PEARL_BLOCK, "Blue Pearl Block");
        this.addBlock((Supplier)BlockInit.BROWN_PEARL_BLOCK, "Brown Pearl Block");
        this.addBlock((Supplier)BlockInit.CYAN_PEARL_BLOCK, "Cyan Pearl Block");
        this.addBlock((Supplier)BlockInit.GRAY_PEARL_BLOCK, "Gray Pearl Block");
        this.addBlock((Supplier)BlockInit.GREEN_PEARL_BLOCK, "Green Pearl Block");
        this.addBlock((Supplier)BlockInit.LIGHT_BLUE_PEARL_BLOCK, "Light Blue Pearl Block");
        this.addBlock((Supplier)BlockInit.LIGHT_GRAY_PEARL_BLOCK, "Light Gray Pearl Block");
        this.addBlock((Supplier)BlockInit.LIME_PEARL_BLOCK, "Lime Pearl Block");
        this.addBlock((Supplier)BlockInit.MAGENTA_PEARL_BLOCK, "Magenta Pearl Block");
        this.addBlock((Supplier)BlockInit.ORANGE_PEARL_BLOCK, "Orange Pearl Block");
        this.addBlock((Supplier)BlockInit.PINK_PEARL_BLOCK, "Pink Pearl Block");
        this.addBlock((Supplier)BlockInit.PURPLE_PEARL_BLOCK, "Purple Pearl Block");
        this.addBlock((Supplier)BlockInit.RED_PEARL_BLOCK, "Red Pearl Block");
        this.addBlock((Supplier)BlockInit.WHITE_PEARL_BLOCK, "White Pearl Block");
        this.addBlock((Supplier)BlockInit.YELLOW_PEARL_BLOCK, "Yellow Pearl Block");
        this.addBlock((Supplier)BlockInit.SEABLOOM, "Seabloom");
        this.addBlock((Supplier)BlockInit.RED_SEABLOOM, "Red Seabloom");
        this.addBlock((Supplier)BlockInit.PURPLE_SEASHROOM, "Purple Seashroom");
        this.addBlock((Supplier)BlockInit.YELLOW_SEASHROOM, "Yellow Seashroom");
        this.addBlock((Supplier)BlockInit.YELLOW_SEABLOOM, "Yellow Seabloom");
        this.addBlock((Supplier)BlockInit.ALGAE, "Algae");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_STONE, "Aquatic Power Stone");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_LAMP, "Aquatic Power Lamp");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_TORCH, "Aquatic Power Torch");
        this.addBlock((Supplier)BlockInit.WALL_AQUATIC_POWER_TORCH, "Aquatic Power Torch");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_DUST_WIRE, "Aquatic Power Dust Wire");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_REPEATER, "Aquatic Power Repeater");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_TRIPWIRE_HOOK, "Aquatic Power Tripwire Hook");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_TRIPWIRE, "Aquatic Power Tripwire");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_LEVER, "Aquatic Power Lever");
        this.addBlock((Supplier)BlockInit.AQUATIC_POWER_COMPARATOR, "Aquatic Power Comparator");
        this.addBlock((Supplier)BlockInit.HARDENED_CALCITE_BLOCK, "Hardened Calcite Block");
        this.addBlock((Supplier)BlockInit.PUSH_BUBBLE_COLUMN, "Push Bubble Column");
        this.addBlock((Supplier)BlockInit.ALGAE_BLOCK, "Algae Block");
        this.addBlock((Supplier)BlockInit.CHISELED_AQUAMARINE_BLOCK, "Chiseled Aquamarine Block");
        this.addBlock((Supplier)BlockInit.LINGUISTIC_TABLE, "Linguistic Table");
        this.addBlock((Supplier)BlockInit.WRITING_TABLE, "Writing Table");
        this.addBlock((Supplier)BlockInit.NYMPH_SAPLING, "Nymph Sapling");
        this.addBlock((Supplier)BlockInit.PALM_SAPLING, "Palm Sapling");
        this.addBlock((Supplier)BlockInit.FIRE_MELON_FRUIT_SPIKED, "Fire Melon Fruit Spiked");
        this.addBlock((Supplier)BlockInit.FIRE_MELON_FRUIT, "Fire Melon Fruit");
        this.addBlock((Supplier)BlockInit.FIRE_MELON_STEM, "Fire Melon Stem");
        this.addBlock((Supplier)BlockInit.FIRE_MELON_TOP, "Fire Melon Top");
        this.addBlocksFromType(BlockInit.ANCIENT_CHERRY, "Ancient Cherry", true);
        this.addBlocksFromType(BlockInit.SEA_GLASS, "Sea Glass", false);
        this.addBlocksFromType(BlockInit.BLUE_SEA_GLASS, "Blue Sea Glass", false);
        this.addBlocksFromType(BlockInit.RED_SEA_GLASS, "Red Sea Glass", false);
        this.addBlocksFromType(BlockInit.ORANGE_SEA_GLASS, "Orange Sea Glass", false);
        this.addBlocksFromType(BlockInit.YELLOW_SEA_GLASS, "Yellow Sea Glass", false);
        this.addBlocksFromType(BlockInit.GREEN_SEA_GLASS, "Green Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIME_SEA_GLASS, "Lime Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIGHT_BLUE_SEA_GLASS, "Light Blue Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIGHT_GRAY_SEA_GLASS, "Light Gray Sea Glass", false);
        this.addBlocksFromType(BlockInit.MAGENTA_SEA_GLASS, "Magenta Sea Glass", false);
        this.addBlocksFromType(BlockInit.PURPLE_SEA_GLASS, "Purple Sea Glass", false);
        this.addBlocksFromType(BlockInit.PINK_SEA_GLASS, "Pink Sea Glass", false);
        this.addBlocksFromType(BlockInit.BLACK_SEA_GLASS, "Black Sea Glass", false);
        this.addBlocksFromType(BlockInit.GRAY_SEA_GLASS, "Gray Sea Glass", false);
        this.addBlocksFromType(BlockInit.WHITE_SEA_GLASS, "White Sea Glass", false);
        this.addBlocksFromType(BlockInit.BROWN_SEA_GLASS, "Brown Sea Glass", false);
        this.addBlocksFromType(BlockInit.CYAN_SEA_GLASS, "Cyan Sea Glass", false);
        this.addBlocksFromType(BlockInit.BLUE_PATTERNED_SEA_GLASS, "Blue Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.RED_PATTERNED_SEA_GLASS, "Red Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.ORANGE_PATTERNED_SEA_GLASS, "Orange Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.YELLOW_PATTERNED_SEA_GLASS, "Yellow Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.GREEN_PATTERNED_SEA_GLASS, "Green Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIME_PATTERNED_SEA_GLASS, "Lime Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIGHT_BLUE_PATTERNED_SEA_GLASS, "Light Blue Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.LIGHT_GRAY_PATTERNED_SEA_GLASS, "Light Gray Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.MAGENTA_PATTERNED_SEA_GLASS, "Magenta Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.PURPLE_PATTERNED_SEA_GLASS, "Purple Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.PINK_PATTERNED_SEA_GLASS, "Pink Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.BLACK_PATTERNED_SEA_GLASS, "Black Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.GRAY_PATTERNED_SEA_GLASS, "Gray Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.WHITE_PATTERNED_SEA_GLASS, "White Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.BROWN_PATTERNED_SEA_GLASS, "Brown Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.CYAN_PATTERNED_SEA_GLASS, "Cyan Patterned Sea Glass", false);
        this.addBlocksFromType(BlockInit.MONOCHROMATIC_SEA_GLASS, "Monochromatic Sea Glass", false);
        this.addBlocksFromType(BlockInit.MULTICOLOR_SEA_GLASS, "Multicolor Sea Glass", false);
        this.addBlocksFromType(BlockInit.ANCIENT_BAMBOO, "Ancient Bamboo", true);
        this.addBlocksFromType(BlockInit.ANCIENT_ACACIA, "Ancient Acacia", true);
        this.addBlocksFromType(BlockInit.ANCIENT_SPRUCE, "Ancient Spruce", true);
        this.addBlocksFromType(BlockInit.ANCIENT_BIRCH, "Ancient Birch", true);
        this.addBlocksFromType(BlockInit.ANCIENT_CRIMSON, "Ancient Crimson", true);
        this.addBlocksFromType(BlockInit.ANCIENT_WARPED, "Ancient Warped", true);
        this.addBlocksFromType(BlockInit.ANCIENT_JUNGLE, "Ancient Jungle", true);
        this.addBlocksFromType(BlockInit.ANCIENT_OAK, "Ancient Oak", true);
        this.addBlocksFromType(BlockInit.ANCIENT_DARK_OAK, "Ancient Dark Oak", true);
        this.addBlocksFromType(BlockInit.ANCIENT_MANGROVE, "Ancient Mangrove", true);
        this.addBlock(BlockInit.COQUINA);
        for (Map<DyeColor, RegistryObject<Block>> map : BlockInit.DYED_LINGUISTICS.values()) {
            for (DyeColor color : DyeColor.values()) {
                this.addBlock((Supplier)map.get(color), WordUtils.capitalize((String)((Block)map.get(color).get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            }
        }
        for (RegistryObject registryObject : BlockInit.NON_LINGUISTICS.values()) {
            this.addBlock((Supplier)registryObject, WordUtils.capitalize((String)((Block)registryObject.get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : BlockInit.COLORED_SHELL_BLOCKS.values()) {
            this.addBlock((Supplier)registryObject, WordUtils.capitalize((String)((Block)registryObject.get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : BlockInit.CRACKED_MOSSY_SHELL_BLOCKS.values()) {
            this.addBlock((Supplier)registryObject, WordUtils.capitalize((String)((Block)registryObject.get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : BlockInit.CRACKED_SHELL_BLOCKS.values()) {
            this.addBlock((Supplier)registryObject, WordUtils.capitalize((String)((Block)registryObject.get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        for (RegistryObject registryObject : BlockInit.MOSSY_SHELL_BLOCKS.values()) {
            this.addBlock((Supplier)registryObject, WordUtils.capitalize((String)((Block)registryObject.get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        this.add((Item)ItemInit.AQUAMARINE_HAMMER.get(), "Aquamarine Hammer");
        this.add("aquamarine_hammer.description", "An ancient hammer from long ago");
        this.add("aquamarine_hammer.tooltip", "Right click to break blocks in a 3x3 area");
        this.add((Item)ItemInit.ORICHALCUM_HAMMER.get(), "Orichalcum Hammer");
        this.add("orichalcum_hammer.description", "A hammer made from the rarest of materials");
        this.add("orichalcum_hammer.tooltip", "Right click to break blocks in a 5x5 area");
        this.add("enchantment.atlantis.deeper_depth", "Deeper Depth");
        this.add("item.minecraft.smithing_template.orichalcum_upgrade.ingredients", "Orichalcum Ingot");
        this.add("item.minecraft.smithing_template.orichalcum_upgrade.base_slot_description", "Add orichalcum armor, weapon, or tool");
        this.add("item.minecraft.smithing_template.orichalcum_upgrade.additions_slot_description", "Add Orichalcum Ingot");
        this.add("item.minecraft.smithing_template.orichalcum_upgrade.applies_to", "Aquamarine Equipment");
        this.add("upgrade.minecraft.orichalcum_upgrade", "Orichalcum Upgrade Smithing Template");
        this.add("enchantment.atlantis.lightning_protection", "Lightning Protection");
        this.add("container.writing", "Writing");
        this.add("container.linguistic", "Linguistic");
        this.add("effect.atlantis.spikes", "Spikes");
        this.add("effect.atlantis.spikes.description", "You attack with a thorns like effect");
        this.add((Item)ItemInit.ATLANTEAN_AMULET.get(), "Atlantean Amulet");
        this.add((Item)ItemInit.ATLANTEAN_SPEAR.get(), "Atlantean Spear");
        this.add((Item)ItemInit.PALM_BOAT.get(), "Palm Boat");
        this.add((Item)ItemInit.NYMPH_BOAT.get(), "Nymph Boat");
        this.add((Item)ItemInit.RUBYCLAW_CRAB_EGG.get(), "Rubyclaw Crab Egg");
        this.add((Item)ItemInit.AQUAIEL_JELLYFISH_EGG.get(), "Aquaiel Jellyfish Egg");
        this.add((Item)ItemInit.GLITTERTAIL_SHRIMP_EGG.get(), "Glittertail Shrimp Egg");
        this.add((Item)ItemInit.LEVIATHAN_EGG.get(), "Leviathan Egg");
        this.add((Item)ItemInit.THALASSIAN_SEAHORSE_EGG.get(), "Thalassian Seahorse Egg");
        this.add((Item)ItemInit.COCONUT_CRAB_EGG.get(), "Coconut Crab Egg");
        this.add((Item)ItemInit.STARFISH_EGG.get(), "Starfish Egg");
        this.add((Item)ItemInit.ZOMBIE_STARFISH_EGG.get(), "Zombie Starfish Egg");
        this.addRecord(ItemInit.PANBEE, "LudoCrypt - Panbee");
        this.addRecord(ItemInit.COLUMN_CAVITATION, "Firel - Column Cavitation");
        this.add((Item)ItemInit.BROKEN_SHELLS.get(), "Broken Shells");
        this.add((Item)ItemInit.SODIUM_NUGGET.get(), "Sodium Nugget");
        this.add((Item)ItemInit.SEASALT.get(), "Seasalt");
        this.add((Item)ItemInit.FIRE_MELON_JELLY_BOTTLE.get(), "Fire Melon Jelly Bottle");
        this.add((Item)ItemInit.JELLY_BOTTLE.get(), "Jelly Bottle");
        this.add((Item)ItemInit.AQUAMARINE_GEM.get(), "Aquamarine Gem");
        this.add((Item)ItemInit.ORICHALCUM_INGOT.get(), "Orichalcum Ingot");
        this.add((Item)ItemInit.ORICHALCUM_BLEND.get(), "Orichalcum Blend");
        this.add((Item)ItemInit.ORB_OF_ATLANTIS.get(), "Orb Of Atlantis");
        this.add((Item)ItemInit.ATLANTEAN_CRYSTAL.get(), "Flow-Water Crystal");
        this.add((Item)ItemInit.OCEAN_STONE.get(), "Ocean Stone");
        this.add((Item)ItemInit.DROP_OF_ATLANTIS.get(), "Drop Of Atlantis");
        this.add((Item)ItemInit.BROWN_WROUGHT_PATCHES.get(), "Brown Wrought Patches");
        this.add((Item)ItemInit.CRAB_LEGS.get(), "Crab Legs");
        this.add((Item)ItemInit.SHRIMP.get(), "Shrimp");
        this.add((Item)ItemInit.COOKED_SHRIMP.get(), "Cooked Shrimp");
        this.add((Item)ItemInit.AQUATIC_POWER_DUST.get(), "Aquatic Power Dust");
        this.add((Item)ItemInit.AQUAIEL_STRING.get(), "Aquariel String");
        this.add((Item)ItemInit.SUBMARINE.get(), "Submarine");
        this.add((Item)ItemInit.WATER_PILL.get(), "Water Pill");
        for (TrailsGroup trailsGroup : BlockInit.ANCIENT_CUPRUM.values()) {
            this.add((Block)trailsGroup.block().get(), WordUtils.capitalize((String)((WeatheringCuprumFullBlock)trailsGroup.block().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.chiseled().get(), WordUtils.capitalize((String)((WeatheringCuprumFullBlock)trailsGroup.chiseled().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.cut().get(), WordUtils.capitalize((String)((WeatheringCuprumFullBlock)trailsGroup.cut().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.cut_slab().get(), WordUtils.capitalize((String)((WeatheringCuprumSlabBlock)trailsGroup.cut_slab().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.cut_stairs().get(), WordUtils.capitalize((String)((WeatheringCuprumStairsBlock)trailsGroup.cut_stairs().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.trapdoor().get(), WordUtils.capitalize((String)((WeatheringCuprumTrapdoorBlock)trailsGroup.trapdoor().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.door().get(), WordUtils.capitalize((String)((WeatheringCuprumDoorBlock)trailsGroup.door().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.grate().get(), WordUtils.capitalize((String)((WeatheringCuprumGrateBlock)trailsGroup.grate().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.bulb().get(), WordUtils.capitalize((String)((WeatheringCuprumBulbBlock)trailsGroup.bulb().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_block().get(), WordUtils.capitalize((String)((Block)trailsGroup.waxed_block().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_chiseled().get(), WordUtils.capitalize((String)((Block)trailsGroup.waxed_chiseled().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_cut().get(), WordUtils.capitalize((String)((Block)trailsGroup.waxed_cut().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_cut_slab().get(), WordUtils.capitalize((String)((SlabBlock)trailsGroup.waxed_cut_slab().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_cut_stairs().get(), WordUtils.capitalize((String)((StairBlock)trailsGroup.waxed_cut_stairs().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_trapdoor().get(), WordUtils.capitalize((String)((TrapDoorBlock)trailsGroup.waxed_trapdoor().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_door().get(), WordUtils.capitalize((String)((DoorBlock)trailsGroup.waxed_door().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_grate().get(), WordUtils.capitalize((String)((Block)trailsGroup.waxed_grate().get()).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
            this.add((Block)trailsGroup.waxed_bulb().get(), WordUtils.capitalize((String)((CuprumBulbBlock)((Object)trailsGroup.waxed_bulb().get())).m_7705_().replace("block.atlantis.", "").replace("_", " ")));
        }
        this.addBlock((Supplier)BlockInit.ANCIENT_CUPRUM_ORE, "Ancient Cuprum Ore");
        this.addBlock((Supplier)BlockInit.DEEPSLATE_ANCIENT_CUPRUM_ORE, "Deepslate Ancient Cuprum Ore");
        this.addBlock((Supplier)BlockInit.RAW_ANCIENT_CUPRUM_BLOCK, "Block of Raw Ancient Cuprum");
        this.add((Item)ItemInit.ANCIENT_CUPRUM_INGOT.get(), "Ancient Cuprum Ingot");
        this.add((Item)ItemInit.RAW_ANCIENT_CUPRUM.get(), "Raw Ancient Cuprum");
        this.add("block.atlantis.nymph_sign", "Nymph Sign");
        this.add("block.atlantis.nymph_wall_sign", "Nymph Sign");
        this.add("block.atlantis.palm_sign", "Palm Sign");
        this.add("block.atlantis.palm_wall_sign", "Palm Sign");
        this.add((Item)ItemInit.FIRE_MELON_FRUIT.get(), "Fire Melon Fruit");
        this.add((Item)ItemInit.FIRE_MELON_FRUIT_SPIKED.get(), "Fire Melon Fruit Spiked");
        this.add((Item)ItemInit.FIRE_MELON_SEEDS.get(), "Fire Melon Seeds");
        this.add((Item)ItemInit.FIRE_MELON_SPIKE.get(), "Fire Melon Spike");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL.get(), "Linguistic Glyph Scroll");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_A.get(), "Linguistic Glyph Scroll A");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_B.get(), "Linguistic Glyph Scroll B");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_C.get(), "Linguistic Glyph Scroll C");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_D.get(), "Linguistic Glyph Scroll D");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_E.get(), "Linguistic Glyph Scroll E");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_F.get(), "Linguistic Glyph Scroll F");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_G.get(), "Linguistic Glyph Scroll G");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_H.get(), "Linguistic Glyph Scroll H");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_I.get(), "Linguistic Glyph Scroll I");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_J.get(), "Linguistic Glyph Scroll J");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_K.get(), "Linguistic Glyph Scroll K");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_L.get(), "Linguistic Glyph Scroll L");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_M.get(), "Linguistic Glyph Scroll M");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_N.get(), "Linguistic Glyph Scroll N");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_O.get(), "Linguistic Glyph Scroll O");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_P.get(), "Linguistic Glyph Scroll P");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_Q.get(), "Linguistic Glyph Scroll Q");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_R.get(), "Linguistic Glyph Scroll R");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_S.get(), "Linguistic Glyph Scroll S");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_T.get(), "Linguistic Glyph Scroll T");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_U.get(), "Linguistic Glyph Scroll U");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_V.get(), "Linguistic Glyph Scroll V");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_W.get(), "Linguistic Glyph Scroll W");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_X.get(), "Linguistic Glyph Scroll X");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_Y.get(), "Linguistic Glyph Scroll Y");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_Z.get(), "Linguistic Glyph Scroll Z");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_0.get(), "Linguistic Glyph Scroll 0");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_1.get(), "Linguistic Glyph Scroll 1");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_2.get(), "Linguistic Glyph Scroll 2");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_3.get(), "Linguistic Glyph Scroll 3");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_4.get(), "Linguistic Glyph Scroll 4");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_5.get(), "Linguistic Glyph Scroll 5");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_6.get(), "Linguistic Glyph Scroll 6");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_7.get(), "Linguistic Glyph Scroll 7");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_8.get(), "Linguistic Glyph Scroll 8");
        this.add((Item)ItemInit.LINGUISTIC_GLYPH_SCROLL_9.get(), "Linguistic Glyph Scroll 9");
        this.add((Item)ItemInit.JETSTREAM_WATER_BUCKET.get(), "Jetstream Water Bucket");
        this.add((Item)ItemInit.SALTY_SEAWATER_BUCKET.get(), "Salty Seawater Bucket");
        this.add((Item)ItemInit.RUBYCLAW_CRAB_BUCKET.get(), "Bucket of Rubyclaw Crab");
        this.add((Item)ItemInit.AQUAIEL_JELLYFISH_BUCKET.get(), "Bucket of Aquaiel Jellyfish");
        this.add((Item)ItemInit.GLITTERTAIL_SHRIMP_BUCKET.get(), "Bucket of Glittertail Shrimp");
        this.add((Item)ItemInit.THALASSIAN_SEAHORSE_BUCKET.get(), "Bucket of Thalassian Seahorse");
        this.add((Item)ItemInit.AQUAMARINE_AXE.get(), "Aquamarine Axe");
        this.add((Item)ItemInit.AQUAMARINE_PICKAXE.get(), "Aquamarine Pickaxe");
        this.add((Item)ItemInit.AQUAMARINE_SHOVEL.get(), "Aquamarine Shovel");
        this.add((Item)ItemInit.AQUAMARINE_HOE.get(), "Aquamarine Hoe");
        this.add((Item)ItemInit.AQUAMARINE_SWORD.get(), "Aquamarine Sword");
        this.add((Item)ItemInit.ORICHALCUM_AXE.get(), "Orichalcum Axe");
        this.add((Item)ItemInit.ORICHALCUM_PICKAXE.get(), "Orichalcum Pickaxe");
        this.add((Item)ItemInit.ORICHALCUM_SHOVEL.get(), "Orichalcum Shovel");
        this.add((Item)ItemInit.ORICHALCUM_HOE.get(), "Orichalcum Hoe");
        this.add((Item)ItemInit.ORICHALCUM_SWORD.get(), "Orichalcum Sword");
        this.add((Item)ItemInit.AQUAMARINE_HELMET.get(), "Aquamarine Helmet");
        this.add((Item)ItemInit.AQUAMARINE_CHESTPLATE.get(), "Aquamarine Chestplate");
        this.add((Item)ItemInit.AQUAMARINE_LEGGINGS.get(), "Aquamarine Leggings");
        this.add((Item)ItemInit.AQUAMARINE_BOOTS.get(), "Aquamarine Boots");
        this.add((Item)ItemInit.BROWN_WROUGHT_HELMET.get(), "Brown Wrought Helmet");
        this.add((Item)ItemInit.BROWN_WROUGHT_CHESTPLATE.get(), "Brown Wrought Chestplate");
        this.add((Item)ItemInit.BROWN_WROUGHT_LEGGINGS.get(), "Brown Wrought Leggings");
        this.add((Item)ItemInit.BROWN_WROUGHT_BOOTS.get(), "Brown Wrought Boots");
        this.add((Item)ItemInit.ORICHALCUM_UPGRADE_SMITHING_TEMPLATE.get(), "Orichalcum Upgrade Smithing Template");
        this.add((Item)ItemInit.ORICHALCUM_HELMET.get(), "Orichalcum Helmet");
        this.add((Item)ItemInit.ORICHALCUM_CHESTPLATE.get(), "Orichalcum Chestplate");
        this.add((Item)ItemInit.ORICHALCUM_LEGGINGS.get(), "Orichalcum Leggings");
        this.add((Item)ItemInit.ORICHALCUM_BOOTS.get(), "Orichalcum Boots");
        this.add((EntityType)AtlantisEntityInit.PALM_BOAT.get(), "Palm Boat");
        this.add((EntityType)AtlantisEntityInit.NYMPH_BOAT.get(), "Nymph Boat");
        this.add((EntityType)AtlantisEntityInit.RUBYCLAW_CRAB.get(), "Rubyclaw Crab");
        this.add((EntityType)AtlantisEntityInit.COCONUT_CRAB.get(), "Coconut Crab");
        this.add((EntityType)AtlantisEntityInit.AQUAIEL_JELLYFISH.get(), "Aquaiel Jellyfish");
        this.add((EntityType)AtlantisEntityInit.GLITTERTAIL_SHRIMP.get(), "Glittertail Shrimp");
        this.add((EntityType)AtlantisEntityInit.LEVIATHAN.get(), "Leviathan");
        this.add((EntityType)AtlantisEntityInit.THALASSIAN_SEAHORSE.get(), "Thalassian Seahorse");
        this.add((EntityType)AtlantisEntityInit.STARFISH.get(), "Starfish");
        this.add((EntityType)AtlantisEntityInit.ZOMBIE_STARFISH.get(), "Zombie Starfish");
        this.add((EntityType)AtlantisEntityInit.SODIUM_BOMB.get(), "Sodium Bomb");
        this.add((EntityType)AtlantisEntityInit.SUBMARINE.get(), "Submarine");
        this.add("biome.atlantis.atlantean_garden", "Atlantean Garden");
        this.add("biome.atlantis.atlantean_islands_biome", "Atlantean Islands");
        this.add("biome.atlantis.atlantis_biome", "Atlantis Biome");
        this.add("biome.atlantis.coconut_isles", "Coconut Isles");
        this.add("biome.atlantis.goo_lagoons", "Goo Lagoons");
        this.add("biome.atlantis.jellyfish_fields", "Jellyfish Fields");
        this.add("biome.atlantis.volcanic_darksea", "Volcanic Darksea");
        this.add("structure.atlantis.atlantean_village", "Atlantean Village");
        this.add("dimension.atlantis.atlantis", "Atlantis");
        this.add("structure.atlantis.configured_atlantean_fountain", "Atlantean Fountain");
        this.add("structure.atlantis.configured_atlantean_house_1", "Atlantean House Variant 1");
        this.add("structure.atlantis.configured_atlantean_house_3", "Atlantean House Variant 3");
        this.add("structure.atlantis.configured_atlantean_spire", "Atlantean Spire");
        this.add("structure.atlantis.configured_atlantean_temple", "Atlantean Temple");
        this.add("structure.atlantis.configured_atlantean_tower", "Atlantean Tower");
        this.add("structure.atlantis.configured_oyster_structure", "Giant Oyster");
        this.add("itemGroup.atlantis.general", "Atlantis");
        this.add("itemGroup.atlantis.glyph", "Glyphs");
        this.add("text.autoconfig.atlantis.option.calciteAcceleration", "Calcite Acceleration");
        this.add("text.autoconfig.atlantis.option.calciteThreshold", "Calcite Threshold");
        this.add("text.autoconfig.atlantis.option.general.calciteAcceleration", "Calcite Acceleration");
        this.add("text.autoconfig.atlantis.option.general.calciteAcceleration.@Tooltip", "How fast you start to speed up at. Must reload world for it to work!");
        this.add("text.autoconfig.atlantis.option.general.calciteThreshold", "Calcite Threshold");
        this.add("text.autoconfig.atlantis.option.general.calciteThreshold.@Tooltip", "The maximum speed you can be at. Must reload world for it to work!");
        this.add("text.autoconfig.atlantis.option.islandsOn", "Are islands on?");
        this.add("text.autoconfig.atlantis.option.maxCrabSpawnHeight", "Maximum Crab Spawn Height");
        this.add("text.autoconfig.atlantis.option.maxCrabSpawnHeight.@Tooltip", "The Maximum Height The Rubyclaw Crab Will Spawn At");
        this.add("text.autoconfig.atlantis.option.minCrabSpawnHeight", "Minimum Crab Spawn Height");
        this.add("text.autoconfig.atlantis.option.minCrabSpawnHeight.@Tooltip", "The Minimum Height The Rubyclaw Crab Will Spawn At");
        this.add("text.autoconfig.atlantis.option.volcanoesOn", "Are volcanoes on?");
        this.add("text.autoconfig.atlantis.title", "Atlantean Config");
    }

    private <T extends Item> void addRecord(RegistryObject<T> record, String s) {
        this.addItem((Supplier)record, "Music Disc");
        this.add("item." + record.getId().m_135827_() + "." + record.getId().m_135815_() + ".desc", s);
    }

    private void addBlocksFromType(BlockType type, String base, boolean isWood) {
        this.addBlock((Supplier)type.block(), base + (isWood ? " Planks" : ""));
        if (type.door() != null) {
            this.addBlock((Supplier)type.door(), base + " Door");
        }
        if (type.button() != null) {
            this.addBlock((Supplier)type.button(), base + " Button");
        }
        if (type.slab() != null) {
            this.addBlock((Supplier)type.slab(), base + " Slab");
        }
        if (type.stairs() != null) {
            this.addBlock((Supplier)type.stairs(), base + " Stairs");
        }
        if (type.fence() != null) {
            this.addBlock((Supplier)type.fence(), base + " Fence");
        }
        if (type.fenceGate() != null) {
            this.addBlock((Supplier)type.fenceGate(), base + " Fence Gate");
        }
        if (type.pressurePlate() != null) {
            this.addBlock((Supplier)type.pressurePlate(), base + " Pressure Plate");
        }
        if (type.trapDoor() != null) {
            this.addBlock((Supplier)type.trapDoor(), base + " Trapdoor");
        }
        if (type.wall() != null) {
            this.addBlock((Supplier)type.wall(), base + " Wall");
        }
    }

    private void addItem(RegistryObject<Item> registryObject) {
        this.addItem((Supplier)registryObject, WordUtils.capitalizeFully((String)registryObject.getId().m_135815_().replace("_", " ")));
    }

    private <T extends Block> void addBlock(RegistryObject<T> registryObject) {
        this.addBlock((Supplier)registryObject, WordUtils.capitalizeFully((String)registryObject.getId().m_135815_().replace("_", " ")));
    }

    private void add(RegistryObject<CreativeModeTab> tab, String entry) {
        this.add("itemGroup." + tab.getId().m_214298_(), entry);
    }
}

