/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.datagen;

import com.mystic.atlantis.blocks.ancient_cuprum.TrailsGroup;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class AtlantisBlockModelProvider
extends BlockModelProvider {
    public AtlantisBlockModelProvider(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "atlantis", existingFileHelper);
    }

    protected void registerModels() {
        BlockInit.ANCIENT_CUPRUM.values().stream().map(TrailsGroup::bulb).forEach(holder -> {
            this.cubeAll((RegistryObject)holder, "_unlit");
            this.cubeAll((RegistryObject)holder, "_lit");
            this.cubeAll((RegistryObject)holder, "_lit_powered");
            this.cubeAll((RegistryObject)holder, "_unlit_powered");
        });
        BlockInit.ANCIENT_CUPRUM.values().stream().map(TrailsGroup::waxed_bulb).forEach(holder -> {
            this.cubeAll((RegistryObject)holder, "_unlit");
            this.cubeAll((RegistryObject)holder, "_lit");
            this.cubeAll((RegistryObject)holder, "_lit_powered");
            this.cubeAll((RegistryObject)holder, "_unlit_powered");
        });
    }

    private <T extends Block> void cubeAll(RegistryObject<T> block, String name) {
        ResourceLocation texture = block.getId().m_266382_(name);
        this.cubeAll(texture.m_135815_(), this.blockTexture(texture));
    }

    private ResourceLocation blockTexture(ResourceLocation loc) {
        if (loc.m_135815_().contains("waxed")) {
            return new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_().replace("waxed_", ""));
        }
        return new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_());
    }
}

