/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.plants;

import com.mystic.atlantis.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Seabloom
extends BushBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public Seabloom(BlockBehaviour.Properties settings) {
        super(settings.m_60977_().m_60913_(0.2f, 0.4f).m_60918_(SoundType.f_56740_).m_60999_().m_60910_().m_60955_());
        ComposterBlock.f_51914_.put((Object)this, 0.65f);
        this.m_49966_().m_61124_(WATERLOGGED, (Comparable)Boolean.TRUE);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return !state.m_60812_(worldIn, pos).m_83263_(Direction.UP).m_83281_() || state.m_60783_(worldIn, pos, Direction.UP);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        if (this.isWaterAt(worldIn, pos)) {
            return this.m_6266_(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return blockstate;
        }
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_(WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_(WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.m_205709_((Object)Blocks.f_50016_);
        return HolderSet.m_205809_((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.m_8055_(targetPos).m_204341_(this.getAir()) || !this.canPlaceBlockAt(reader, targetPos);
    }

    public boolean canPlaceOn(BlockState targetState) {
        return targetState.m_60734_() == BlockInit.SEABED.get() || targetState.m_60734_() == Blocks.f_49994_ || targetState.m_60734_() == Blocks.f_50062_ || targetState.m_60734_() == Blocks.f_50034_ || targetState.m_60734_() == Blocks.f_50493_ || targetState.m_60734_() == Blocks.f_49992_;
    }

    public boolean canPlaceBlockAt(LevelReader reader, BlockPos targetPos) {
        BlockState targetState = reader.m_8055_(targetPos.m_7495_());
        if (reader.m_8055_(targetPos.m_7494_()).m_60713_(Blocks.f_49990_)) {
            return this.canPlaceOn(targetState);
        }
        return false;
    }
}

