/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.particles.ModParticleTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PushBubbleColumnBlock
extends Block
implements BucketPickup {
    public static final DirectionProperty PUSH = BlockStateProperties.f_61372_;
    public static final IntegerProperty DECAY = IntegerProperty.m_61631_((String)"decay", (int)0, (int)30);

    public PushBubbleColumnBlock(BlockBehaviour.Properties settings) {
        super(settings.m_280170_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DECAY, (Comparable)Integer.valueOf(0)));
    }

    public void m_7892_(BlockState targetState, Level level, BlockPos targetPos, Entity targetEntity) {
        BlockState aboveState = level.m_8055_(targetPos.m_7494_());
        if (aboveState.m_60795_()) {
            this.onBubbleColumnSurfaceCollision(targetEntity, (Direction)targetState.m_61143_((Property)PUSH));
            if (!level.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)targetPos.m_123341_() + level.f_46441_.m_188500_(), (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, (double)targetPos.m_123341_() + level.f_46441_.m_188500_(), (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_() + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 0.02);
                }
            }
        } else {
            this.onBubbleColumnCollision(targetEntity, (Direction)targetState.m_61143_((Property)PUSH));
        }
    }

    public static void update(ServerLevel level, BlockPos pos) {
        block0: for (Direction direction : Direction.values()) {
            BlockPos.MutableBlockPos bubblePos = pos.m_122032_();
            for (int i = 1; i < (Integer)AtlantisConfig.INSTANCE.maxDistanceOfPushBubbleColumn.get(); ++i) {
                bubblePos.m_122173_(direction);
                BlockState previousState = level.m_8055_(bubblePos.m_121945_(direction.m_122424_()));
                FluidState previousFluidState = level.m_6425_(bubblePos.m_121945_(direction.m_122424_()));
                BlockState targetState = level.m_8055_((BlockPos)bubblePos);
                BlockState newState = PushBubbleColumnBlock.getBubbleState(previousState, previousFluidState, targetState, direction);
                if (newState == null) continue block0;
                level.m_7731_((BlockPos)bubblePos, newState, 3);
            }
        }
    }

    @NotNull
    public FluidState m_5888_(@NotNull BlockState targetState) {
        return Fluids.f_76193_.m_76068_(false);
    }

    private static boolean isStillWater(BlockState state) {
        return state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76186_() >= 8 && state.m_60819_().m_76170_();
    }

    private static BlockState getBubbleState(BlockState previousState, FluidState fluidState, BlockState targetState, Direction curDir) {
        if (targetState.m_60713_((Block)BlockInit.BUBBLE_MAGMA.get())) {
            return null;
        }
        if (previousState.m_60713_((Block)BlockInit.BUBBLE_MAGMA.get())) {
            if (PushBubbleColumnBlock.isStillWater(targetState) || targetState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
                return (BlockState)((BlockState)((PushBubbleColumnBlock)((Object)BlockInit.PUSH_BUBBLE_COLUMN.get())).m_49966_().m_61124_((Property)PUSH, (Comparable)curDir)).m_61124_((Property)DECAY, (Comparable)((Integer)AtlantisConfig.INSTANCE.maxDistanceOfPushBubbleColumn.get()));
            }
        } else if (previousState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
            if ((Integer)previousState.m_61143_((Property)DECAY) == 0) {
                return Blocks.f_49990_.m_49966_();
            }
            if (!((Direction)previousState.m_61143_((Property)PUSH)).equals((Object)curDir)) {
                return null;
            }
            if (PushBubbleColumnBlock.isStillWater(targetState) || targetState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get())) {
                return (BlockState)((BlockState)((PushBubbleColumnBlock)((Object)BlockInit.PUSH_BUBBLE_COLUMN.get())).m_49966_().m_61124_((Property)PUSH, (Comparable)curDir)).m_61124_((Property)DECAY, (Comparable)Integer.valueOf((Integer)previousState.m_61143_((Property)DECAY) - 1));
            }
        } else if ((fluidState.m_76178_() || PushBubbleColumnBlock.isStillWater(previousState)) && (PushBubbleColumnBlock.isStillWater(targetState) || targetState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()))) {
            return Blocks.f_49990_.m_49966_();
        }
        return null;
    }

    public void m_214162_(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        double x = targetPos.m_123341_();
        double y = targetPos.m_123342_();
        double z = targetPos.m_123343_();
        switch ((Direction)targetState.m_61143_((Property)PUSH)) {
            case UP: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_UP.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
                break;
            }
            case DOWN: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_DOWN.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_NORTH.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_SOUTH.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_EAST.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.m_7107_((ParticleOptions)ModParticleTypes.PUSH_BUBBLESTREAM_WEST.get(), x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.0, 0.0);
            }
        }
        if (random.m_188503_(200) == 0) {
            level.m_7785_(x, y, z, SoundEvents.f_11776_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }

    public void m_7592_(Level level, BlockPos pos, Explosion pExplosion) {
        if (!level.m_5776_()) {
            PushBubbleColumnBlock.update((ServerLevel)level, pos);
        }
    }

    public BlockState m_7417_(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor level, BlockPos targetPos, BlockPos neighborPos) {
        level.m_186469_(targetPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        if (!this.m_7898_(targetState, (LevelReader)level, targetPos) && !neighborState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()) && PushBubbleColumnBlock.isStillWater(neighborState)) {
            level.m_186460_(targetPos, (Block)this, 1);
        }
        return super.m_7417_(targetState, curDir, neighborState, level, targetPos, neighborPos);
    }

    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        Direction pushDir = (Direction)targetState.m_61143_((Property)PUSH);
        BlockState relativeState = reader.m_8055_(targetPos.m_121945_(pushDir.m_122424_()));
        if (relativeState.m_60713_((Block)BlockInit.PUSH_BUBBLE_COLUMN.get()) && ((Direction)relativeState.m_61143_((Property)PUSH)).equals((Object)pushDir)) {
            return (Integer)relativeState.m_61143_((Property)DECAY) >= 0;
        }
        return relativeState.m_60713_((Block)BlockInit.BUBBLE_MAGMA.get());
    }

    public VoxelShape m_5940_(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState targetState) {
        return RenderShape.INVISIBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DECAY, PUSH});
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos targetPos, BlockState targetState) {
        level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public void onBubbleColumnSurfaceCollision(Entity targetEntity, Direction dragDir) {
        this.adjustEntityMovement(targetEntity, dragDir, (Double)AtlantisConfig.INSTANCE.magmaAcceleration.get(), (Double)AtlantisConfig.INSTANCE.magmaThreshold.get());
    }

    public void adjustEntityMovement(Entity entity, Direction dragDir, double magnitude, double limit) {
        Vec3 dMovement = entity.m_20184_();
        magnitude *= (double)dragDir.m_122421_().m_122540_();
        limit *= (double)dragDir.m_122421_().m_122540_();
        switch (dragDir.m_122434_()) {
            case X: {
                entity.m_20334_(this.getAdjustedMagLimit(dragDir.m_122421_(), magnitude + dMovement.f_82479_, limit), dMovement.f_82480_, dMovement.f_82481_);
                break;
            }
            case Y: {
                entity.m_20334_(dMovement.f_82479_, this.getAdjustedMagLimit(dragDir.m_122421_(), magnitude + dMovement.f_82480_, limit), dMovement.f_82481_);
                break;
            }
            case Z: {
                entity.m_20334_(dMovement.f_82479_, dMovement.f_82480_, this.getAdjustedMagLimit(dragDir.m_122421_(), magnitude + dMovement.f_82481_, limit));
            }
        }
    }

    public double getAdjustedMagLimit(Direction.AxisDirection curAxisDir, double magnitude, double limit) {
        if (curAxisDir == Direction.AxisDirection.POSITIVE) {
            return Math.max(magnitude, limit);
        }
        return Math.min(magnitude, limit);
    }

    public void onBubbleColumnCollision(Entity targetEntity, Direction dragDir) {
        this.adjustEntityMovement(targetEntity, dragDir, 0.06, 0.7);
        targetEntity.f_19789_ = 0.0f;
    }
}

