/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.base.NymphDoorBlock;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;

public class FireMelonSpikedFruitBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty AGE_4;
    public static final IntegerProperty AGE;
    public static final BooleanProperty SPIKED;
    protected static final VoxelShape[] EAST_AABB;
    protected static final VoxelShape[] WEST_AABB;
    protected static final VoxelShape[] NORTH_AABB;
    protected static final VoxelShape[] SOUTH_AABB;

    public FireMelonSpikedFruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SPIKED, (Comparable)Boolean.valueOf(true))).m_61124_(NymphDoorBlock.WATERLOGGED, (Comparable)Boolean.TRUE));
    }

    public boolean m_6724_(BlockState targetState) {
        return (Integer)targetState.m_61143_((Property)AGE) < 4;
    }

    public void m_213898_(BlockState targetState, ServerLevel level, BlockPos targetPos, RandomSource random) {
        int age = (Integer)targetState.m_61143_((Property)AGE);
        if (age < 4 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)targetPos, (BlockState)targetState, (level.f_46441_.m_188503_(4) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)targetPos, (BlockState)targetState);
        }
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.m_205709_((Object)Blocks.f_50016_);
        return HolderSet.m_205809_((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.m_8055_(targetPos).m_204341_(this.getAir());
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(NymphDoorBlock.WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        BlockState relativeState = reader.m_8055_(targetPos.m_121945_((Direction)targetState.m_61143_((Property)f_54117_)));
        if (this.isWaterAt(reader, targetPos)) {
            return relativeState.m_60713_((Block)BlockInit.FIRE_MELON_STEM.get());
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        switch ((Direction)targetState.m_61143_((Property)f_54117_)) {
            case SOUTH: {
                return SOUTH_AABB[0];
            }
            default: {
                return NORTH_AABB[0];
            }
            case WEST: {
                return WEST_AABB[0];
            }
            case EAST: 
        }
        return EAST_AABB[0];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState targetState = this.m_49966_();
        Level reader = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        for (Direction curLookingDirection : context.m_6232_()) {
            if (!curLookingDirection.m_122434_().m_122479_() || !(targetState = (BlockState)targetState.m_61124_((Property)f_54117_, (Comparable)curLookingDirection)).m_60710_((LevelReader)reader, clickedPos)) continue;
            return targetState;
        }
        return null;
    }

    public BlockState m_7417_(BlockState targetState, Direction curDir, BlockState neighbourState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighbourPos) {
        return curDir == targetState.m_61143_((Property)f_54117_) && !targetState.m_60710_((LevelReader)accessor, targetPos) ? Blocks.f_49990_.m_49966_() : super.m_7417_(targetState, curDir, neighbourState, accessor, targetPos, neighbourPos);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) < 4;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        level.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)targetState.m_61143_((Property)AGE) + 1)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, AGE, SPIKED, NymphDoorBlock.WATERLOGGED});
    }

    public boolean m_7357_(BlockState targetState, BlockGetter getter, BlockPos targetPos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState targetState, Level level, BlockPos targetPos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack mainHandStack = player.m_21120_(hand);
        if (mainHandStack.canPerformAction(ToolActions.SHEARS_CARVE) && ((Boolean)targetState.m_61143_((Property)SPIKED)).booleanValue()) {
            if (!level.f_46443_) {
                Direction resultDir = result.m_82434_();
                Direction oppositeDir = resultDir.m_122434_() == Direction.Axis.Y ? player.m_6350_().m_122424_() : resultDir;
                level.m_5594_(null, targetPos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)SPIKED, (Comparable)Boolean.valueOf(false)), 11);
                ItemEntity fireMelonSpikeItemEntity = new ItemEntity(level, (double)targetPos.m_123341_() + 0.5 + (double)oppositeDir.m_122429_() * 0.65, (double)targetPos.m_123342_() + 0.1, (double)targetPos.m_123343_() + 0.5 + (double)oppositeDir.m_122431_() * 0.65, new ItemStack((ItemLike)ItemInit.FIRE_MELON_SPIKE.get(), 1));
                fireMelonSpikeItemEntity.m_20334_(0.05 * (double)oppositeDir.m_122429_() + level.f_46441_.m_188500_() * 0.02, 0.05, 0.05 * (double)oppositeDir.m_122431_() + level.f_46441_.m_188500_() * 0.02);
                level.m_7967_((Entity)fireMelonSpikeItemEntity);
                mainHandStack.m_41622_(1, (LivingEntity)player, arg2x -> arg2x.m_21190_(hand));
                level.m_142346_((Entity)player, GameEvent.f_157781_, targetPos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(targetState, level, targetPos, player, hand, result);
    }

    static {
        AGE = AGE_4 = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
        SPIKED = BooleanProperty.m_61465_((String)"spiked");
        EAST_AABB = new VoxelShape[]{Block.m_49796_((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)12.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)};
        WEST_AABB = new VoxelShape[]{Block.m_49796_((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)12.0, (double)11.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)};
        NORTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)12.0, (double)7.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)};
        SOUTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), Block.m_49796_((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)12.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)};
    }
}

