/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base;

import com.mystic.atlantis.blocks.base.FireMelonSpikedFruitBlock;
import com.mystic.atlantis.blocks.base.NymphDoorBlock;
import com.mystic.atlantis.init.BlockInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FireMelonFruitBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    public static final BooleanProperty SPIKED = BooleanProperty.m_61465_((String)"spiked");
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.m_49796_((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)12.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.m_49796_((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)12.0, (double)11.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)12.0, (double)7.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), Block.m_49796_((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)12.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)};

    public FireMelonFruitBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(NymphDoorBlock.WATERLOGGED, (Comparable)Boolean.TRUE));
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.m_205709_((Object)Blocks.f_50016_);
        return HolderSet.m_205809_((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return reader.m_46801_(targetPos);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos targetPos) {
        BlockState targetState = reader.m_8055_(targetPos.m_121945_((Direction)state.m_61143_((Property)f_54117_)));
        if (this.isWaterAt(reader, targetPos)) {
            return targetState.m_60713_((Block)BlockInit.FIRE_MELON_STEM.get());
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        int age = (Integer)targetState.m_61143_((Property)AGE);
        switch ((Direction)targetState.m_61143_((Property)f_54117_)) {
            case SOUTH: {
                return SOUTH_AABB[age];
            }
            default: {
                return NORTH_AABB[age];
            }
            case WEST: {
                return WEST_AABB[age];
            }
            case EAST: 
        }
        return EAST_AABB[age];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] lookingDirections;
        BlockState targetState = this.m_49966_();
        Level reader = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        for (Direction direction : lookingDirections = context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(targetState = (BlockState)targetState.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)reader, clickedPos)) continue;
            return targetState;
        }
        return null;
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(NymphDoorBlock.WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public BlockState m_7417_(BlockState targetState, Direction targetDir, BlockState neighbourState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighbourPos) {
        return targetDir == targetState.m_61143_((Property)f_54117_) && !targetState.m_60710_((LevelReader)accessor, targetPos) ? Blocks.f_49990_.m_49966_() : super.m_7417_(targetState, targetDir, neighbourState, accessor, targetPos, neighbourPos);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos targetPos, BlockState targetState) {
        if ((Integer)targetState.m_61143_((Property)AGE) == 0) {
            level.m_7731_(targetPos, ((FireMelonSpikedFruitBlock)((Object)BlockInit.FIRE_MELON_FRUIT_SPIKED.get())).m_152465_(targetState), 4);
        } else {
            level.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)AGE, (Comparable)((Integer)targetState.m_61143_((Property)AGE))), 0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, AGE, NymphDoorBlock.WATERLOGGED});
    }

    public boolean m_7357_(BlockState targetState, BlockGetter getter, BlockPos targetPos, PathComputationType type) {
        return false;
    }
}

