/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.init.AtlantisEntityInit;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SodiumPrimedBombBlock
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(SodiumPrimedBombBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;

    public SodiumPrimedBombBlock(EntityType<? extends SodiumPrimedBombBlock> type, Level level) {
        super(type, level);
    }

    public SodiumPrimedBombBlock(Level level, double targetX, double targetY, double targetZ, @Nullable LivingEntity owner) {
        this((EntityType<? extends SodiumPrimedBombBlock>)((EntityType)AtlantisEntityInit.SODIUM_BOMB.get()), level);
        this.m_6034_(targetX, targetY, targetZ);
        double randOffset = level.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(randOffset) * 0.02, 0.2f, -Math.cos(randOffset) * 0.02);
        this.setFuse(80);
        this.f_19854_ = targetX;
        this.f_19855_ = targetY;
        this.f_19856_ = targetZ;
        this.owner = owner;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
        } else if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void explode() {
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, this.m_5842_(), Level.ExplosionInteraction.BLOCK);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128376_("Fuse", (short)this.getFuse());
    }

    protected void m_7378_(CompoundTag nbt) {
        this.setFuse(nbt.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float m_6380_(@NotNull Pose curPose, @NotNull EntityDimensions dimensions) {
        return 0.15f;
    }

    public void setFuse(int fuse) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)fuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

