/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.mystic.atlantis.blocks.aquatic_power.AquaticPowerLeverBlock;
import com.mystic.atlantis.blocks.plants.Seabloom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class AquaticPowerRepeaterBlock
extends RepeaterBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;

    public AquaticPowerRepeaterBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60966_().m_60918_(SoundType.f_56736_));
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.m_6425_(targetPos).m_205070_(FluidTags.f_13131_)) {
            BlockPos belowPos = targetPos.m_7495_();
            BlockState belowState = reader.m_8055_(belowPos);
            return this.canRunOnTop((BlockGetter)reader, belowPos, belowState);
        }
        return false;
    }

    public void m_214162_(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        if (((Boolean)targetState.m_61143_((Property)f_52496_)).booleanValue()) {
            Direction facingDir = (Direction)targetState.m_61143_((Property)f_54117_);
            double targetX = (double)targetPos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
            double targetY = (double)targetPos.m_123342_() + 0.4 + (random.m_188500_() - 0.5) * 0.2;
            double targetZ = (double)targetPos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.2;
            float potentialDelay = -5.0f;
            if (random.m_188499_()) {
                potentialDelay = (Integer)targetState.m_61143_((Property)f_55798_) * 2 - 1;
            }
            double dX = (potentialDelay /= 16.0f) * (float)facingDir.m_122429_();
            double dZ = potentialDelay * (float)facingDir.m_122431_();
            level.m_7106_((ParticleOptions)new DustParticleOptions(AquaticPowerLeverBlock.COLOR, 1.0f), targetX + dX, targetY, targetZ + dZ, 0.0, 0.0, 0.0);
        }
    }

    private boolean canRunOnTop(BlockGetter getter, BlockPos targetPos, BlockState targetFloorState) {
        return targetFloorState.m_60783_(getter, targetPos, Direction.UP) || targetFloorState.m_60713_(Blocks.f_50332_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_54117_, f_55798_, f_55797_, f_52496_});
    }
}

