/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.aquatic_power;

import com.google.common.collect.Sets;
import com.mystic.atlantis.blocks.plants.Seabloom;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.mixin.RedstoneAccessor;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class AquaticPowerDustBlock
extends RedStoneWireBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = Seabloom.WATERLOGGED;
    public static final Property<Integer> POWER = RedStoneWireBlock.f_55500_;
    private static Vec3[] COLOR = (Vec3[])Util.m_137469_((Object)new Vec3[16], vec3ds -> {
        for (int i = 0; i <= 15; ++i) {
            float f = (float)i / 15.0f;
            float r = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float g = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            float b = f * 0.6f + (f > 0.0f ? 0.4f : 0.3f);
            vec3ds[i] = new Vec3((double)r, (double)g, (double)b);
        }
    });

    public AquaticPowerDustBlock(BlockBehaviour.Properties settings) {
        super(settings.m_60910_().m_60966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55496_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)f_55497_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)f_55498_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)f_55499_, (Comparable)RedstoneSide.NONE)).m_61124_(POWER, (Comparable)Integer.valueOf(0))).m_61124_(WATERLOGGED, (Comparable)Boolean.TRUE));
        ((RedstoneAccessor)((Object)this)).setShouldSignal(true);
    }

    public void m_214162_(BlockState targetState, Level level, BlockPos targetPos, RandomSource random) {
        int power = (Integer)targetState.m_61143_(POWER);
        if (power != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide wireConnection = (RedstoneSide)targetState.m_61143_((Property)f_55501_.get(direction));
                switch (wireConnection) {
                    case UP: {
                        this.m_221922_(level, random, targetPos, COLOR[power], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.m_221922_(level, random, targetPos, COLOR[power], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.m_221922_(level, random, targetPos, COLOR[power], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    private void m_221922_(Level level, RandomSource random, BlockPos targetPos, Vec3 spawnVec, Direction curDir, Direction targetDir, float of1, float of2) {
        float offsetMod = of2 - of1;
        if (!(random.m_188501_() >= 0.2f * offsetMod)) {
            float offset = of1 + offsetMod * random.m_188501_();
            double targetX = 0.5 + (double)(0.4375f * (float)curDir.m_122429_()) + (double)(offset * (float)targetDir.m_122429_());
            double targetY = 0.5 + (double)(0.4375f * (float)curDir.m_122430_()) + (double)(offset * (float)targetDir.m_122430_());
            double targetZ = 0.5 + (double)(0.4375f * (float)curDir.m_122431_()) + (double)(offset * (float)targetDir.m_122431_());
            level.m_7106_((ParticleOptions)new DustParticleOptions(spawnVec.m_252839_(), 1.0f), (double)targetPos.m_123341_() + targetX, (double)targetPos.m_123342_() + targetY, (double)targetPos.m_123343_() + targetZ, 0.0, 0.0, 0.0);
        }
    }

    public int m_6378_(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        if (((RedstoneAccessor)((Object)this)).getShouldSignal() && curDir != Direction.DOWN) {
            int power = (Integer)targetState.m_61143_(POWER);
            if (power == 0) {
                return 0;
            }
            return curDir != Direction.UP && !((RedstoneSide)this.m_55514_(getter, targetState, targetPos).m_61143_((Property)f_55501_.get(curDir.m_122424_()))).m_61761_() ? 0 : power;
        }
        return 0;
    }

    public int m_6376_(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        return !((RedstoneAccessor)((Object)this)).getShouldSignal() ? 0 : targetState.m_60746_(getter, targetPos, curDir);
    }

    public void m_55530_(Level level, BlockPos targetPos, BlockState targetState) {
        int receivedPower = this.m_55527_(level, targetPos);
        if ((Integer)targetState.m_61143_(POWER) != receivedPower) {
            if (level.m_8055_(targetPos) == targetState) {
                level.m_7731_(targetPos, (BlockState)targetState.m_61124_(POWER, (Comparable)Integer.valueOf(receivedPower)), 2);
            }
            HashSet targetPositions = Sets.newHashSet();
            targetPositions.add(targetPos);
            Direction[] validDirections = Direction.values();
            for (Direction direction : validDirections) {
                targetPositions.add(targetPos.m_121945_(direction));
            }
            for (BlockPos targetPosition : targetPositions) {
                level.m_46672_(targetPosition, (Block)this);
            }
        }
    }

    public int m_55527_(Level level, BlockPos targetPos) {
        ((RedstoneAccessor)((Object)this)).setShouldSignal(false);
        int receivedPower = level.m_277086_(targetPos);
        ((RedstoneAccessor)((Object)this)).setShouldSignal(true);
        int calculatedPower = 0;
        if (receivedPower >= 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.m_8055_(targetPos.m_121945_(direction)).m_222976_().get() != Blocks.f_50088_ && level.m_8055_(targetPos.m_121945_(direction).m_7495_()).m_222976_().get() != Blocks.f_50088_ && level.m_8055_(targetPos.m_121945_(direction).m_7494_()).m_222976_().get() != Blocks.f_50088_) continue;
                return Math.max(receivedPower - 1, calculatedPower - 1);
            }
            return receivedPower;
        }
        if (receivedPower >= 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos relativePos = targetPos.m_121945_(direction);
                BlockState relativeState = level.m_8055_(relativePos);
                calculatedPower = Math.max(calculatedPower, this.m_55648_(relativeState));
                BlockPos aboveTargetPos = targetPos.m_7494_();
                if (relativeState.m_60796_((BlockGetter)level, relativePos) && !level.m_8055_(aboveTargetPos).m_60796_((BlockGetter)level, aboveTargetPos)) {
                    calculatedPower = Math.max(calculatedPower, this.m_55648_(level.m_8055_(relativePos.m_7494_())));
                    continue;
                }
                if (relativeState.m_60796_((BlockGetter)level, relativePos)) continue;
                calculatedPower = Math.max(calculatedPower, this.m_55648_(level.m_8055_(relativePos.m_7495_())));
            }
            if (receivedPower == 0) {
                return Math.max(receivedPower, calculatedPower - 1);
            }
            return Math.max(receivedPower - 1, calculatedPower - 1);
        }
        return 0;
    }

    public boolean m_7899_(BlockState targetState) {
        return ((RedstoneAccessor)((Object)this)).getShouldSignal();
    }

    private int m_55648_(BlockState targetState) {
        if (targetState.m_60713_(Blocks.f_50088_)) {
            return (Integer)targetState.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        if (targetState.m_60713_((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get())) {
            return (Integer)targetState.m_61143_(POWER);
        }
        return 0;
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.m_6425_(targetPos).m_205070_(FluidTags.f_13131_)) {
            BlockPos belowPos = targetPos.m_7495_();
            BlockState belowState = reader.m_8055_(belowPos);
            return this.m_55612_((BlockGetter)reader, belowPos, belowState);
        }
        return false;
    }

    private boolean m_55612_(BlockGetter getter, BlockPos targetPos, BlockState targetFloorState) {
        return targetFloorState.m_60783_(getter, targetPos, Direction.UP) || targetFloorState.m_60713_(Blocks.f_50332_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_55497_, f_55496_, f_55498_, f_55499_, POWER});
    }
}

