/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class AtlantisBiomeSource
extends BiomeSource {
    public static final Codec<AtlantisBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(AtlantisBiomeSource::biomeHolderLookup), (App)Codec.intRange((int)1, (int)20).fieldOf("biome_size").orElse((Object)2).forGetter(AtlantisBiomeSource::biomeSize), (App)Codec.LONG.fieldOf("seed").stable().forGetter(AtlantisBiomeSource::seed)).apply((Applicative)instance, AtlantisBiomeSource::new));
    public static final ResourceLocation ATLANTEAN_GARDEN = new ResourceLocation("atlantis", "atlantean_garden");
    public static final ResourceLocation ATLANTIS_BIOME = new ResourceLocation("atlantis", "atlantis_biome");
    public static final ResourceLocation JELLYFISH_FIELDS = new ResourceLocation("atlantis", "jellyfish_fields");
    public static final ResourceLocation ATLANTEAN_ISLANDS = new ResourceLocation("atlantis", "atlantean_islands_biome");
    public static final ResourceLocation VOLCANIC_DARKSEA = new ResourceLocation("atlantis", "volcanic_darksea");
    public static final ResourceLocation GOO_LAGOONS = new ResourceLocation("atlantis", "goo_lagoons");
    public static final ResourceLocation COCONUT_ISLES = new ResourceLocation("atlantis", "coconut_isles");
    private final HolderLookup.RegistryLookup<Biome> biomeHolderLookup;
    private final long seed;
    private final int biomeSize;

    public AtlantisBiomeSource(HolderLookup.RegistryLookup<Biome> biomeRegistry, int biomeSize, long seed) {
        this.biomeHolderLookup = biomeRegistry;
        this.biomeSize = biomeSize;
        this.seed = seed;
    }

    private Holder<Biome> getHolderBiome(ResourceLocation resourceLocationBiome) {
        return this.biomeHolderLookup.m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourceLocationBiome));
    }

    @NotNull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.of(GOO_LAGOONS, VOLCANIC_DARKSEA, JELLYFISH_FIELDS, ATLANTIS_BIOME, ATLANTEAN_GARDEN, ATLANTEAN_ISLANDS, COCONUT_ISLES).map(this::getHolderBiome);
    }

    @NotNull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler noise) {
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.5) {
            return this.getHolderBiome(GOO_LAGOONS);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.4 && (double)((int)noise.m_183445_(x, y, z).f_187003_()) < 0.5) {
            return this.getHolderBiome(VOLCANIC_DARKSEA);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.3 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.4) {
            return this.getHolderBiome(JELLYFISH_FIELDS);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.2 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.3) {
            return this.getHolderBiome(ATLANTIS_BIOME);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.1 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.2) {
            if ((double)((int)noise.m_183445_(x, y, z).f_187007_()) == 0.0) {
                return this.getHolderBiome(COCONUT_ISLES);
            }
            return this.getHolderBiome(ATLANTEAN_ISLANDS);
        }
        return this.getHolderBiome(ATLANTEAN_GARDEN);
    }

    public long seed() {
        return this.seed;
    }

    public int biomeSize() {
        return this.biomeSize;
    }

    public HolderLookup.RegistryLookup<Biome> biomeHolderLookup() {
        return this.biomeHolderLookup;
    }
}

