/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class AtlantisDimensionalEffect
extends DimensionSpecialEffects {
    public static AtlantisDimensionalEffect INSTANCE = new AtlantisDimensionalEffect();
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("atlantis:textures/environment/sun.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("atlantis:textures/environment/moon_phases.png");
    @Nullable
    private VertexBuffer starBuffer;

    private AtlantisDimensionalEffect() {
        super(255.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public boolean renderSky(@NotNull ClientLevel world, int ticks, float tickDelta, PoseStack matrixStack, @NotNull Camera camera, @NotNull Matrix4f projectionMatrix, boolean isFoggy, @NotNull Runnable setupFog) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        matrixStack.m_85836_();
        this.drawSun(tickDelta, matrixStack, world);
        this.drawMoonPhases(tickDelta, matrixStack, world);
        this.createStars();
        matrixStack.m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        return true;
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder pBuilder) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                pBuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return pBuilder.m_231175_();
    }

    public void drawSun(float partialTicks, PoseStack matrix, ClientLevel world) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        Tesselator tessellator = Tesselator.m_85913_();
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_TEXTURES);
        matrix.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        matrix.m_252781_(Axis.f_252529_.m_252977_(world.m_46942_(partialTicks) * 360.0f));
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        bufferbuilder.m_166779_(drawMode, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
    }

    public void drawMoonPhases(float partialTicks, PoseStack matrix, ClientLevel world) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        Tesselator tessellator = Tesselator.m_85913_();
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_PHASES_TEXTURES);
        matrix.m_252781_(Axis.f_252529_.m_252977_(world.m_46942_(partialTicks) * 360.0f * 0.0015f));
        int k1 = world.m_46941_();
        int i2 = k1 % 4;
        int k2 = k1 / 4 % 2;
        float f22 = (float)(i2 + 0) / 4.0f;
        float f23 = (float)(k2 + 0) / 2.0f;
        float f24 = (float)(i2 + 1) / 4.0f;
        float f14 = (float)(k2 + 1) / 2.0f;
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        bufferbuilder.m_166779_(drawMode, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -size, -100.0f, size).m_7421_(f24, f14).m_5752_();
        bufferbuilder.m_252986_(matrix4f, size, -100.0f, size).m_7421_(f22, f14).m_5752_();
        bufferbuilder.m_252986_(matrix4f, size, -100.0f, -size).m_7421_(f22, f23).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -size, -100.0f, -size).m_7421_(f24, f23).m_5752_();
        tessellator.m_85914_();
    }

    public float m_108871_() {
        return 450.0f;
    }

    @NotNull
    public Vec3 m_5927_(Vec3 p_108908_, float p_108909_) {
        return p_108908_.m_82542_((double)(p_108909_ * 0.94f + 0.06f), (double)(p_108909_ * 0.94f + 0.06f), (double)(p_108909_ * 0.91f + 0.09f));
    }

    public boolean m_5781_(int p_108905_, int p_108906_) {
        return false;
    }
}

