/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mystic.atlantis.TagsInit;
import com.mystic.atlantis.blocks.aquatic_power.SodiumPrimedBombBlock;
import com.mystic.atlantis.blocks.base.ExtendedBlockEntity;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.datagen.Providers;
import com.mystic.atlantis.datagen.WaterAttachedToLeavesDecorator;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import com.mystic.atlantis.feature.AtlantisFeature;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.AtlantisModifierInit;
import com.mystic.atlantis.init.AtlantisSoundEventInit;
import com.mystic.atlantis.init.BlockEntityInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.EffectsInit;
import com.mystic.atlantis.init.EnchantmentInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.FluidTypesInit;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.init.POITypesInit;
import com.mystic.atlantis.init.PaintingVariantsInit;
import com.mystic.atlantis.init.RecipesInit;
import com.mystic.atlantis.particles.ModParticleTypes;
import com.mystic.atlantis.screen.LinguisticScreen;
import com.mystic.atlantis.screen.WritingScreen;
import com.mystic.atlantis.structures.AtlantisStructures;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLib;

@Mod(value="atlantis")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atlantis {
    public static final Logger LOGGER = LogManager.getLogger((String)"atlantis");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECO_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"atlantis");
    public static final RegistryObject<TreeDecoratorType<WaterAttachedToLeavesDecorator>> WATER_ATTACH_TO_LEAVES = TREE_DECO_TYPES.register("water_attached_to_leaves", () -> new TreeDecoratorType(WaterAttachedToLeavesDecorator.CODEC));

    public Atlantis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onCommonSet);
        bus.addListener(this::onClientSet);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtlantisConfig.CONFIG_SPEC);
        ModParticleTypes.PARTICLES.register(bus);
        this.onInitialize(bus);
        TREE_DECO_TYPES.register(bus);
        AtlantisFeature.init(bus);
        AtlantisStructures.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        Providers.init(bus);
    }

    public static void registerDispenserBehavior() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)BlockInit.SODIUM_BOMB.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            @NotNull
            protected ItemStack m_7498_(@NotNull BlockSource p_123425_, @NotNull ItemStack p_123426_) {
                ServerLevel level = p_123425_.m_7727_();
                BlockPos blockpos = p_123425_.m_7961_().m_121945_((Direction)p_123425_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                SodiumPrimedBombBlock primedtnt = new SodiumPrimedBombBlock((Level)level, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, null);
                level.m_7967_((Entity)primedtnt);
                level.m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157810_, blockpos);
                p_123426_.m_41774_(1);
                return p_123426_;
            }
        });
    }

    @SubscribeEvent
    public void loadCompleted(FMLLoadCompleteEvent event) {
        ModContainer atlantisContainer = (ModContainer)ModList.get().getModContainerById("atlantis").orElseThrow(() -> new IllegalStateException("Atlantis Mod Container missing after loadCompleted"));
        atlantisContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, previousScreen) -> (Screen)AutoConfig.getConfigScreen(AtlantisConfig.class, (Screen)previousScreen).get()));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Atlantis.id(name));
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("atlantis", id);
    }

    public void onInitialize(IEventBus bus) {
        GeckoLib.initialize();
        BlockInit.init(bus);
        ItemInit.init(bus);
        PaintingVariantsInit.init(bus);
        AtlantisModifierInit.init(bus);
        BlockEntityInit.init(bus);
        FluidTypesInit.init(bus);
        FluidInit.init(bus);
        AtlantisGroupInit.init(bus);
        AtlantisEntityInit.init(bus);
        AtlantisSoundEventInit.init(bus);
        EffectsInit.init(bus);
        EnchantmentInit.init(bus);
        MenuTypeInit.init(bus);
        RecipesInit.init(bus);
        POITypesInit.init(bus);
    }

    private void onClientSet(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeInit.LINGUISTIC.get()), LinguisticScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeInit.WRITING.get()), WritingScreen::new);
        });
    }

    private void onCommonSet(FMLCommonSetupEvent event) {
        TagsInit.init();
        event.enqueueWork(DimensionAtlantis::registerBiomeSources);
        ((ExtendedBlockEntity)BlockEntityType.f_58924_).addAdditionalValidBlock((Block)BlockInit.NYMPH_SIGN.get(), (Block)BlockInit.NYMPH_WALL_SIGN.get());
        ((ExtendedBlockEntity)BlockEntityType.f_58924_).addAdditionalValidBlock((Block)BlockInit.PALM_SIGN.get(), (Block)BlockInit.PALM_WALL_SIGN.get());
        Atlantis.registerDispenserBehavior();
    }
}

