/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.head;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class DrinkingHatItem
extends WearableArtifactItem {
    private final ModGameRules.DoubleValue drinkingDurationMultiplier;
    private final ModGameRules.DoubleValue eatingDurationMultiplier;
    private final boolean hasSpecialTooltip;

    public DrinkingHatItem(ModGameRules.DoubleValue drinkingDurationMultiplier, ModGameRules.DoubleValue eatingDurationMultiplier, boolean hasSpecialTooltip) {
        this.drinkingDurationMultiplier = drinkingDurationMultiplier;
        this.eatingDurationMultiplier = eatingDurationMultiplier;
        this.hasSpecialTooltip = hasSpecialTooltip;
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return !this.drinkingDurationMultiplier.fuzzyEquals(1.0) || !this.eatingDurationMultiplier.fuzzyEquals(1.0);
    }

    @Override
    protected void addTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (this.hasSpecialTooltip) {
            tooltip.add(this.tooltipLine("special", new Object[0]).m_130940_(ChatFormatting.ITALIC));
            this.addEffectsTooltip(stack, tooltip);
        } else {
            super.addTooltip(stack, tooltip);
        }
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (!this.drinkingDurationMultiplier.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("drinking", new Object[0]));
        }
        if (!this.eatingDurationMultiplier.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("eating", new Object[0]));
        }
    }

    @Override
    protected String getTooltipItemName() {
        return "drinking_hat";
    }

    public double getDurationMultiplier(UseAnim action) {
        if (action == UseAnim.DRINK) {
            return this.drinkingDurationMultiplier.get();
        }
        return this.eatingDurationMultiplier.get();
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11770_;
    }

    public static int getDrinkingHatUseDuration(LivingEntity entity, UseAnim action, int duration) {
        return Math.min(DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.PLASTIC_DRINKING_HAT.get()), DrinkingHatItem.getDrinkingHatUseDuration(entity, action, duration, ModItems.NOVELTY_DRINKING_HAT.get()));
    }

    private static int getDrinkingHatUseDuration(LivingEntity entity, UseAnim action, int duration, DrinkingHatItem drinkingHat) {
        if (!drinkingHat.isEquippedBy(entity) || action != UseAnim.EAT && action != UseAnim.DRINK || drinkingHat.getDurationMultiplier(action) == 1.0) {
            return duration;
        }
        return Math.max(1, (int)((double)duration * drinkingHat.getDurationMultiplier(action)));
    }
}

