/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.torch;

import net.larsmans.infinitybuttons.block.custom.button.AbstractHorizontalButton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TorchButton
extends AbstractHorizontalButton {
    protected static final VoxelShape BOUNDING_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected final ParticleOptions particle;
    public final Block jadeBlock;

    public TorchButton(BlockBehaviour.Properties properties, ParticleOptions particle, Block jadeBlock) {
        super(properties, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE, BOUNDING_SHAPE);
        this.particle = particle;
        this.jadeBlock = jadeBlock;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDING_SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pos) {
        return TorchButton.m_49863_((LevelReader)pLevel, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction = (Direction)stateIn.m_61143_((Property)f_54117_);
        if (((Boolean)stateIn.m_61143_((Property)PRESSED)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.63;
            double d2 = (double)pos.m_123343_() + 0.5;
            Direction direction2 = direction.m_122424_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.23 * (double)direction2.m_122429_(), d1, d2 + 0.23 * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
            worldIn.m_7106_(this.particle, d0 + 0.23 * (double)direction2.m_122429_(), d1, d2 + 0.23 * (double)direction2.m_122431_(), 0.0, 0.0, 0.0);
        } else {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + 0.7;
            double f = (double)pos.m_123343_() + 0.5;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 0.0, 0.0, 0.0);
            worldIn.m_7106_(this.particle, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getPressDuration() {
        return 50;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return SoundEvents.f_12632_;
    }

    @Override
    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)PRESSED) != false && Direction.DOWN.m_122424_() == side ? 15 : 0;
    }

    @Override
    public void updateNeighbors(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
        worldIn.m_46672_(pos.m_121945_(Direction.DOWN), (Block)this);
    }
}

