/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.emergencybutton;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.advancement.InfinityButtonsTriggers;
import net.larsmans.infinitybuttons.block.custom.emergencybutton.EmergencyButton;
import net.larsmans.infinitybuttons.block.custom.emergencybutton.SEBStateEnum;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.larsmans.infinitybuttons.config.InfinityButtonsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SafeEmergencyButton
extends FaceAttachedHorizontalDirectionalBlock {
    InfinityButtonsConfig config = (InfinityButtonsConfig)AutoConfig.getConfigHolder(InfinityButtonsConfig.class).getConfig();
    public static final EnumProperty<SEBStateEnum> STATE = EnumProperty.m_61587_((String)"state", SEBStateEnum.class);
    private static final VoxelShape STONE_DOWN = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final VoxelShape STONE_UP = Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape STONE_NORTH = Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    private static final VoxelShape STONE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private static final VoxelShape STONE_SOUTH = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    private static final VoxelShape STONE_WEST = Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    private static final VoxelShape FLOOR_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)STONE_DOWN);
    private static final VoxelShape FLOOR_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (VoxelShape)STONE_DOWN);
    private static final VoxelShape FLOOR_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape)STONE_DOWN);
    private static final VoxelShape CEILING_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (VoxelShape)STONE_UP);
    private static final VoxelShape CEILING_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (VoxelShape)STONE_UP);
    private static final VoxelShape CEILING_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (VoxelShape)STONE_UP);
    private static final VoxelShape NORTH_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)15.0), (VoxelShape)STONE_NORTH);
    private static final VoxelShape NORTH_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)STONE_NORTH);
    private static final VoxelShape NORTH_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)15.0), (VoxelShape)STONE_NORTH);
    private static final VoxelShape EAST_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (VoxelShape)STONE_EAST);
    private static final VoxelShape EAST_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), (VoxelShape)STONE_EAST);
    private static final VoxelShape EAST_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), (VoxelShape)STONE_EAST);
    private static final VoxelShape SOUTH_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)8.0), (VoxelShape)STONE_SOUTH);
    private static final VoxelShape SOUTH_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)5.0), (VoxelShape)STONE_SOUTH);
    private static final VoxelShape SOUTH_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), (VoxelShape)STONE_SOUTH);
    private static final VoxelShape WEST_CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), (VoxelShape)STONE_WEST);
    private static final VoxelShape WEST_OPEN_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)STONE_WEST);
    private static final VoxelShape WEST_PRESSED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (VoxelShape)STONE_WEST);

    public SafeEmergencyButton(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)SEBStateEnum.CLOSED))).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{STATE, f_54117_, f_53179_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        block0 : switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                    case CLOSED: {
                        return FLOOR_CLOSED_SHAPE;
                    }
                    case OPEN: {
                        return FLOOR_OPEN_SHAPE;
                    }
                    case PRESSED: {
                        return FLOOR_PRESSED_SHAPE;
                    }
                }
                break;
            }
            case CEILING: {
                switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                    case CLOSED: {
                        return CEILING_CLOSED_SHAPE;
                    }
                    case OPEN: {
                        return CEILING_OPEN_SHAPE;
                    }
                    case PRESSED: {
                        return CEILING_PRESSED_SHAPE;
                    }
                }
                break;
            }
            case WALL: {
                switch (direction) {
                    case NORTH: {
                        switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                            case CLOSED: {
                                return NORTH_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return NORTH_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return NORTH_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case EAST: {
                        switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                            case CLOSED: {
                                return EAST_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return EAST_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return EAST_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case SOUTH: {
                        switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                            case CLOSED: {
                                return SOUTH_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return SOUTH_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return SOUTH_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case WEST: {
                        switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
                            case CLOSED: {
                                return WEST_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return WEST_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return WEST_PRESSED_SHAPE;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        GameType gameMode = GameType.f_151492_;
        if (worldIn.f_46443_) {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            assert (connection != null);
            gameMode = Objects.requireNonNull(connection.m_104949_(player.m_36316_().getId())).m_105325_();
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            gameMode = serverPlayer.f_8941_.m_9290_();
        }
        if (gameMode == GameType.SPECTATOR) {
            return InteractionResult.FAIL;
        }
        switch ((SEBStateEnum)((Object)state.m_61143_(STATE))) {
            case PRESSED: {
                return InteractionResult.CONSUME;
            }
            case OPEN: {
                if (player.m_6144_()) {
                    this.closeCase(state, worldIn, pos);
                    this.playToggleSound(player, (LevelAccessor)worldIn, pos, false);
                    break;
                }
                this.powerBlock(state, worldIn, pos);
                this.playClickSound(player, (LevelAccessor)worldIn, pos, true);
                EmergencyButton.emergencySound(worldIn, pos);
                if (player instanceof ServerPlayer) {
                    InfinityButtonsTriggers.EMERGENCY_TRIGGER.trigger((ServerPlayer)player);
                }
                if (!worldIn.f_46443_ && this.config.alarmVillagerPanic) {
                    List<LivingEntity> villagers = new ArrayList();
                    if (this.config.alarmSoundType == AlarmEnum.GLOBAL) {
                        villagers = new ArrayList();
                        List villagersDup = worldIn.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(512.0), entity -> entity.m_6095_() == EntityType.f_20492_);
                        for (Player player1 : worldIn.m_6907_()) {
                            villagersDup.addAll(worldIn.m_6443_(LivingEntity.class, new AABB(player1.m_20097_()).m_82400_(512.0), entity -> entity.m_6095_() == EntityType.f_20492_));
                        }
                        for (LivingEntity villager : villagersDup) {
                            if (villagers.contains(villager)) continue;
                            villagers.add(villager);
                        }
                    }
                    if (this.config.alarmSoundType == AlarmEnum.RANGE) {
                        villagers = worldIn.m_6443_(LivingEntity.class, new AABB(pos).m_82400_((double)this.config.alarmSoundRange), entity -> entity.m_6095_() == EntityType.f_20492_);
                    }
                    for (LivingEntity villager : villagers) {
                        if (!(villager instanceof Villager)) continue;
                        Villager villagerEntity = (Villager)villager;
                        villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)worldIn.m_46467_());
                    }
                }
                worldIn.m_142346_((Entity)player, GameEvent.f_223702_, pos);
                break;
            }
            case CLOSED: {
                if (player.m_6144_()) {
                    this.openCase(state, worldIn, pos);
                    this.playToggleSound(player, (LevelAccessor)worldIn, pos, true);
                    break;
                }
                player.m_5661_((Component)InfinityButtonsUtil.SAFE_EMERGENCY_BUTTON_ACTIONBAR_TEXT, true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void openCase(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)SEBStateEnum.OPEN)), 3);
        this.updateNeighbors(state, world, pos);
    }

    public void closeCase(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)SEBStateEnum.CLOSED)), 3);
        this.updateNeighbors(state, world, pos);
    }

    public void powerBlock(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)SEBStateEnum.PRESSED)), 3);
        this.updateNeighbors(state, world, pos);
        world.m_186460_(pos, (Block)this, 10);
    }

    protected void playClickSound(@javax.annotation.Nullable Player playerIn, LevelAccessor worldIn, BlockPos pos, boolean pressed) {
        worldIn.m_5594_((Player)(pressed ? playerIn : null), pos, SoundEvents.f_11708_, SoundSource.BLOCKS, 1.0f, pressed ? 0.6f : 0.5f);
    }

    protected void playToggleSound(@javax.annotation.Nullable Player playerIn, LevelAccessor world, BlockPos pos, boolean pressed) {
        world.m_5594_((Player)(pressed ? playerIn : null), pos, pressed ? SoundEvents.f_12012_ : SoundEvents.f_12011_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean moved) {
        if (moved || state.m_60713_(newState.m_60734_())) {
            return;
        }
        if (state.m_61143_(STATE) == SEBStateEnum.PRESSED) {
            this.updateNeighbors(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, moved);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_61143_(STATE) == SEBStateEnum.PRESSED ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.m_61143_(STATE) == SEBStateEnum.PRESSED && EmergencyButton.m_53200_((BlockState)blockState) == side ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (state.m_61143_(STATE) == SEBStateEnum.PRESSED) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)SEBStateEnum.OPEN)), 3);
            this.updateNeighbors(state, (Level)worldIn, pos);
            this.playClickSound(null, (LevelAccessor)worldIn, pos, false);
            worldIn.m_142346_(null, GameEvent.f_223703_, pos);
        }
    }

    private void updateNeighbors(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
        worldIn.m_46672_(pos.m_121945_(SafeEmergencyButton.m_53200_((BlockState)state).m_122424_()), (Block)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        InfinityButtonsUtil.tooltip(pTooltip, "safe_emergency_button");
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

