/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom;

import net.larsmans.infinitybuttons.block.custom.button.AbstractLeverableButton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampButton
extends AbstractLeverableButton {
    private static final VoxelShape FLOOR_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)15.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0), (VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)8.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape)Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0));

    public LampButton(BlockBehaviour.Properties properties, boolean lever) {
        super(lever, properties);
    }

    @Override
    public int getPressDuration() {
        return 20;
    }

    @Override
    protected SoundEvent getSoundEvent(boolean pressed) {
        return pressed ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return FLOOR_SHAPE;
            }
            case WALL: {
                switch (direction) {
                    case NORTH: {
                        return NORTH_SHAPE;
                    }
                    case EAST: {
                        return EAST_SHAPE;
                    }
                    case SOUTH: {
                        return SOUTH_SHAPE;
                    }
                }
                return WEST_SHAPE;
            }
        }
        return CEILING_SHAPE;
    }
}

