/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PacketContext {
    private final NetworkEvent.Context context;

    public PacketContext(NetworkEvent.Context context) {
        this.context = context;
    }

    public CoreSide getHandlingSide() {
        return this.context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public CoreSide getOriginatingSide() {
        return this.context.getDirection().getOriginationSide() == LogicalSide.CLIENT ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public Player getPlayer() {
        if (this.getHandlingSide().isClient()) {
            return ClientUtils.getPlayer();
        }
        return this.context.getSender();
    }

    @Deprecated
    public Player getSendingPlayer() {
        return this.context.getSender();
    }

    public Level getWorld() {
        return this.getHandlingSide() == CoreSide.CLIENT ? ClientUtils.getWorld() : this.getSendingPlayer().m_9236_();
    }

    public void queueTask(Runnable task) {
        if (this.getHandlingSide() == CoreSide.SERVER) {
            this.context.enqueueWork(task);
        } else {
            ClientUtils.queueTask(task);
        }
    }

    @Deprecated
    public NetworkEvent.Context getUnderlyingContext() {
        return this.context;
    }
}

