/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.CustomSlot;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class CustomSlotImpl
extends Slot
implements CustomSlot {
    private static final Container EMPTY_CONTAINER = new Container(){

        public int m_6643_() {
            return 0;
        }

        public boolean m_7983_() {
            return true;
        }

        public ItemStack m_8020_(int i) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int i, int j) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int i) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int i, ItemStack itemStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return false;
        }

        public void m_6211_() {
        }
    };
    private final int width;
    private final int height;
    private final Supplier<ItemStack> getter;
    private final Consumer<ItemStack> setter;
    private final ToIntFunction<ItemStack> inserter;
    private final Function<Integer, ItemStack> extractor;
    private final ToIntFunction<ItemStack> capacity;
    private final Predicate<ItemStack> filter;
    private final CustomSlot.SlotChangeListener onInsert;
    private final CustomSlot.SlotChangeListener onExtract;
    private final boolean canInsert;
    private final boolean canExtract;
    private final boolean scaleItemToSize;
    private final boolean showBackground;
    private final boolean showItem;
    private final boolean showHighlight;
    private boolean active = true;

    static CustomSlot.Builder builder() {
        return new BuilderImpl();
    }

    private CustomSlotImpl(Container vanillaContainer, int vanillaSlot, int x, int y, int width, int height, Supplier<ItemStack> getter, Consumer<ItemStack> setter, ToIntFunction<ItemStack> inserter, Function<Integer, ItemStack> extractor, ToIntFunction<ItemStack> capacity, Predicate<ItemStack> filter, CustomSlot.SlotChangeListener onInsert, CustomSlot.SlotChangeListener onExtract, boolean canInsert, boolean canExtract, boolean scaleItemToSize, boolean showBackground, boolean showItem, boolean showHighlight) {
        super(vanillaContainer == null ? EMPTY_CONTAINER : vanillaContainer, vanillaSlot, x, y);
        this.width = width;
        this.height = height;
        this.getter = getter == null ? () -> ItemStack.f_41583_ : getter;
        Consumer<ItemStack> consumer = this.setter = setter == null ? stack -> {} : setter;
        ToIntFunction<ItemStack> toIntFunction = inserter == null ? (setter == null ? stack -> 0 : stack -> {
            if (stack.m_41619_()) {
                return 0;
            }
            ItemStack currentStack = this.getter.get();
            if (!currentStack.m_41619_() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack)) {
                return 0;
            }
            int inserted = Math.min(stack.m_41613_(), stack.m_41741_() - currentStack.m_41613_());
            if (capacity != null) {
                inserted = Math.min(inserted, capacity.applyAsInt((ItemStack)stack));
            }
            setter.accept(stack.m_255036_(currentStack.m_41613_() + inserted));
            return inserted;
        }) : (this.inserter = inserter);
        this.extractor = extractor == null ? (setter == null ? amount -> ItemStack.f_41583_ : amount -> {
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            ItemStack currentStack = this.getter.get();
            if (currentStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int extracted = Math.min(amount, currentStack.m_41613_());
            ItemStack extractedStack = currentStack.m_255036_(extracted);
            setter.accept(currentStack.m_255036_(currentStack.m_41613_() - extracted));
            return extractedStack;
        }) : extractor;
        this.capacity = capacity == null ? stack -> stack.m_41619_() ? 64 : stack.m_41741_() : capacity;
        this.filter = filter == null ? stack -> true : filter;
        this.onInsert = onInsert == null ? (oldStack, newStack) -> {} : onInsert;
        this.onExtract = onExtract == null ? (oldStack, newStack) -> {} : onExtract;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
        this.scaleItemToSize = scaleItemToSize;
        this.showBackground = showBackground;
        this.showItem = showItem;
        this.showHighlight = showHighlight;
    }

    @Override
    public Slot getVanillaSlot() {
        return this;
    }

    @Override
    public void move(int x, int y) {
        this.f_40220_ = x;
        this.f_40221_ = y;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int getX() {
        return this.f_40220_;
    }

    @Override
    public int getY() {
        return this.f_40221_;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean scaleItemToSize() {
        return this.scaleItemToSize;
    }

    @Override
    public boolean showBackground() {
        return this.showBackground;
    }

    @Override
    public boolean showItem() {
        return this.showItem;
    }

    @Override
    public boolean showHighlight() {
        return this.showHighlight;
    }

    public boolean m_5857_(ItemStack stack) {
        return this.canInsert && this.filter.test(stack);
    }

    @Override
    public ItemStack m_7993_() {
        return this.getter.get();
    }

    public void m_5852_(ItemStack stack) {
        ItemStack original = this.getter.get();
        this.setter.accept(stack);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.m_41728_((ItemStack)original, (ItemStack)newStack)) {
            if (newStack.m_41619_()) {
                this.onExtract.onChange(original, newStack);
            } else {
                this.onInsert.onChange(original, newStack);
            }
        }
    }

    public int m_6641_() {
        return this.capacity.applyAsInt(ItemStack.f_41583_);
    }

    public int m_5866_(ItemStack stack) {
        return this.capacity.applyAsInt(stack);
    }

    public ItemStack m_6201_(int amount) {
        return this.extractor.apply(amount);
    }

    public boolean m_8010_(Player player) {
        return this.canExtract;
    }

    @Override
    public boolean m_6659_() {
        return this.active;
    }

    public Optional<ItemStack> m_150641_(int amount, int ignored, Player player) {
        if (!this.m_8010_(player)) {
            return Optional.empty();
        }
        ItemStack original = this.getter.get();
        ItemStack extracted = this.extractor.apply(amount);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.m_41728_((ItemStack)original, (ItemStack)newStack)) {
            this.onInsert.onChange(original, newStack);
        }
        return extracted.m_41619_() ? Optional.empty() : Optional.of(extracted);
    }

    public ItemStack m_150656_(ItemStack stack, int amount) {
        if (stack.m_41619_() || !this.m_5857_(stack)) {
            return stack;
        }
        ItemStack original = this.getter.get();
        int inserted = this.inserter.applyAsInt(stack.m_255036_(amount));
        stack.m_41774_(inserted);
        ItemStack newStack = this.getter.get();
        if (!ItemStack.m_41728_((ItemStack)original, (ItemStack)newStack)) {
            this.onExtract.onChange(original, newStack);
        }
        return stack;
    }

    public boolean m_280329_() {
        return this.showBackground;
    }

    private static class BuilderImpl
    implements CustomSlot.Builder {
        private int x;
        private int y;
        private int width = 18;
        private int height = 18;
        private Supplier<ItemStack> getter;
        private Consumer<ItemStack> setter;
        private ToIntFunction<ItemStack> inserter;
        private Function<Integer, ItemStack> extractor;
        private ToIntFunction<ItemStack> capacity;
        private Predicate<ItemStack> filter;
        private CustomSlot.SlotChangeListener onInsert;
        private CustomSlot.SlotChangeListener onExtract;
        private boolean canInsert = true;
        private boolean canExtract = true;
        private boolean scaleItemToSize = false;
        private boolean showBackground = true;
        private boolean showItem = true;
        private boolean showHighlight = true;
        private Container vanillaContainer;
        private int vanillaSlot;

        private BuilderImpl() {
        }

        @Override
        public CustomSlot.Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int size) {
            return this.size(size, size);
        }

        @Override
        public CustomSlot.Builder getter(Supplier<ItemStack> getter) {
            this.getter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder setter(Consumer<ItemStack> getter) {
            this.setter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder inserter(ToIntFunction<ItemStack> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public CustomSlot.Builder extractor(Function<Integer, ItemStack> extractor) {
            this.extractor = extractor;
            return this;
        }

        @Override
        public CustomSlot.Builder capacity(ToIntFunction<ItemStack> capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public CustomSlot.Builder filter(Predicate<ItemStack> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CustomSlot.Builder onInsert(CustomSlot.SlotChangeListener onInsert) {
            this.onInsert = onInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder onExtract(CustomSlot.SlotChangeListener onExtract) {
            this.onExtract = onExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder onChange(CustomSlot.SlotChangeListener onChange) {
            return this.onInsert(onChange).onExtract(onChange);
        }

        @Override
        public CustomSlot.Builder vanillaContainer(int index, Container container) {
            this.getter(() -> container.m_8020_(index));
            this.setter(stack -> {
                container.m_6836_(index, stack);
                container.m_6596_();
            });
            this.inserter(stack -> {
                if (stack.m_41619_()) {
                    return 0;
                }
                ItemStack currentStack = container.m_8020_(index);
                int amount = Math.min(stack.m_41613_(), container.m_6893_() - currentStack.m_41613_());
                if (amount <= 0 || !currentStack.m_41619_() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentStack)) {
                    return 0;
                }
                container.m_6836_(index, stack.m_255036_(currentStack.m_41613_() + amount));
                container.m_6596_();
                return amount;
            });
            this.extractor(amount -> {
                ItemStack extracted = container.m_7407_(index, amount.intValue());
                if (!extracted.m_41619_()) {
                    if (container.m_8020_(index).m_41619_()) {
                        container.m_6836_(index, ItemStack.f_41583_);
                    }
                    container.m_6596_();
                }
                return extracted;
            });
            this.capacity(stack -> container.m_6893_());
            this.vanillaContainer = container;
            this.vanillaSlot = index;
            return this;
        }

        @Override
        public CustomSlot.Builder playerInventory(int index, Inventory inventory) {
            return this.vanillaContainer(index, (Container)inventory);
        }

        @Override
        public CustomSlot.Builder itemHandler(int index, Supplier<IItemHandler> handlerSupplier) {
            this.getter(() -> ((IItemHandler)handlerSupplier.get()).getStackInSlot(0));
            this.inserter(stack -> {
                if (stack.m_41619_()) {
                    return 0;
                }
                IItemHandler handler = (IItemHandler)handlerSupplier.get();
                int initialCount = stack.m_41613_();
                ItemStack leftover = handler.insertItem(0, stack, false);
                if (stack.m_41613_() != initialCount) {
                    throw new RuntimeException("Item handler of class '" + handler.getClass() + "' modified input stack to #insertItem!");
                }
                return initialCount - leftover.m_41613_();
            });
            this.extractor(amount -> {
                if (amount <= 0) {
                    return ItemStack.f_41583_;
                }
                IItemHandler handler = (IItemHandler)handlerSupplier.get();
                return handler.extractItem(index, amount.intValue(), false);
            });
            this.capacity(stack -> ((IItemHandler)handlerSupplier.get()).getSlotLimit(0));
            return this;
        }

        @Override
        public CustomSlot.Builder canInsert(boolean canInsert) {
            this.canInsert = canInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder canExtract(boolean canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder canInsertExtract(boolean mutable) {
            return this.canExtract(mutable).canInsert(mutable);
        }

        @Override
        public CustomSlot.Builder scaleItemToSize(boolean scaleItemToSize) {
            this.scaleItemToSize = scaleItemToSize;
            return this;
        }

        @Override
        public CustomSlot.Builder scaleItemToSize() {
            return this.scaleItemToSize(true);
        }

        @Override
        public CustomSlot.Builder showBackground(boolean showBackground) {
            this.showBackground = showBackground;
            return this;
        }

        @Override
        public CustomSlot.Builder noBackground() {
            this.showBackground = false;
            return this;
        }

        @Override
        public CustomSlot.Builder showItem(boolean showItem) {
            this.showItem = showItem;
            return this;
        }

        @Override
        public CustomSlot.Builder showHighlight(boolean showHighlight) {
            this.showHighlight = showHighlight;
            return this;
        }

        @Override
        public CustomSlot build() {
            return new CustomSlotImpl(this.vanillaContainer, this.vanillaSlot, this.x, this.y, this.width, this.height, this.getter, this.setter, this.inserter, this.extractor, this.capacity, this.filter, this.onInsert, this.onExtract, this.canInsert, this.canExtract, this.scaleItemToSize, this.showBackground, this.showItem, this.showHighlight);
        }
    }
}

