/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.block_entity.SpawnerAccessHelper;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class VanillaSpawnerHandler
extends ProbabilityDataHandler<VanillaSpawnerHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.SPAWNER, parser -> {
        parser.add("entity", Registries.f_256939_, EntityType.f_20510_);
        parser.add("generation_chance", 1.0f, 0.0f, 1.0f);
        parser.addShort("min_spawn_delay", (short)200, (short)0, (short)Short.MAX_VALUE);
        parser.addShort("max_spawn_delay", (short)800, (short)0, (short)Short.MAX_VALUE);
        parser.addShort("spawn_count", (short)4, (short)0, (short)Short.MAX_VALUE);
        parser.addShort("max_nearby_entities", (short)6, (short)0, (short)Short.MAX_VALUE);
        parser.addShort("required_player_range", (short)16, (short)0, (short)Short.MAX_VALUE);
        parser.addShort("spawn_range", (short)4, (short)0, (short)Short.MAX_VALUE);
        parser.add("tag", new CompoundTag());
    });
    private final ResourceKey<EntityType<?>> entityType;
    private final short minSpawnDelay;
    private final short maxSpawnDelay;
    private final short spawnCount;
    private final short maxNearbyEntities;
    private final short requiredPlayerRange;
    private final short spawnRange;
    private final CompoundTag tag;

    public VanillaSpawnerHandler(DataMap data) {
        super(data, "generation_chance");
        this.entityType = data.get("entity", Registries.f_256939_);
        this.minSpawnDelay = data.getShort("min_spawn_delay");
        this.maxSpawnDelay = (short)Math.max(this.minSpawnDelay, data.getShort("max_spawn_delay"));
        this.spawnCount = data.getShort("spawn_count");
        this.maxNearbyEntities = data.getShort("max_nearby_entities");
        this.requiredPlayerRange = data.getShort("required_player_range");
        this.spawnRange = data.getShort("spawn_range");
        this.tag = data.get("tag", CompoundTag.class);
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            EntityType entity = (EntityType)level.m_9598_().m_175515_(Registries.f_256939_).m_6246_(this.entityType);
            if (entity != null) {
                spawner.m_252803_(entity, rand);
            }
            SpawnerAccessHelper.setMinSpawnDelay(spawner, null, pos, this.minSpawnDelay);
            SpawnerAccessHelper.setMaxSpawnDelay(spawner, null, pos, this.maxSpawnDelay);
            SpawnerAccessHelper.setSpawnCount(spawner, null, pos, this.spawnCount);
            SpawnerAccessHelper.setMaxNearbyEntities(spawner, null, pos, this.maxNearbyEntities);
            SpawnerAccessHelper.setRequiredPlayerRange(spawner, null, pos, this.requiredPlayerRange);
            SpawnerAccessHelper.setSpawnRange(spawner, null, pos, this.spawnRange);
            spawner.m_142466_(this.tag);
            spawner.m_6596_();
        }
        if (level instanceof ServerLevel) {
            BlockState updatedState = level.m_8055_(pos);
            ((ServerLevel)level).m_7260_(pos, updatedState, updatedState, 3);
        }
    }
}

