/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.util;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static String escapeString(String string) {
        return string.toLowerCase(Locale.ROOT).replaceAll("[^a-z\\d_.-]", "");
    }

    public static String toTitle(String string) {
        return StringUtils.capitalize((String)string.replace("_", " "));
    }

    public static String getPlayerName(Player player) {
        return Utils.escapeString(player.m_36316_().getName());
    }

    public static boolean isPlayerMelody(ResourceLocation identifier) {
        return identifier.m_135827_().equals("player");
    }

    public static boolean ownsMelody(ResourceLocation identifier, Player player) {
        return Utils.isPlayerMelody(identifier) && identifier.m_135815_().startsWith(Utils.getPlayerName(player) + "/");
    }

    public static boolean canDelete(ResourceLocation identifier, Player player) {
        return Utils.ownsMelody(identifier, player) || Utils.isPlayerMelody(identifier) && player.m_20310_(2);
    }

    public static String removeLastPart(String input, String delimiter) {
        int lastDotIndex = input.lastIndexOf(delimiter);
        if (lastDotIndex != -1) {
            return input.substring(0, lastDotIndex);
        }
        return input;
    }

    public static String getLastPart(String input, String delimiter) {
        int lastDotIndex = input.lastIndexOf(delimiter);
        if (lastDotIndex != -1) {
            return input.substring(lastDotIndex + delimiter.length());
        }
        return input;
    }
}

