/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.projectile;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SonarWave
extends Entity {
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(SonarWave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float growProgress = 0.0f;
    private float prevGrowProgress = 0.0f;

    public SonarWave(EntityType<? extends SonarWave> type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
    }

    public SonarWave(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends SonarWave>)((EntityType)UAEntityTypes.SONAR_WAVE.get()), worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public SonarWave(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends SonarWave>)((EntityType)UAEntityTypes.SONAR_WAVE.get()), world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(OWNER_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.getThrasherOwner() != null) {
            List entities = this.m_9236_().m_6249_((Entity)this.getThrasherOwner(), this.m_20191_().m_82400_((double)this.growProgress), Thrasher.ENEMY_MATCHER);
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || this.getThrasherOwner().m_5448_() != null) continue;
                this.getThrasherOwner().m_6710_((LivingEntity)entity);
            }
        }
        Vec3 motion = this.m_20184_();
        float horizontalMotionMagnitude = Mth.m_14116_((float)((float)motion.m_165925_()));
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            this.m_146922_((float)(Mth.m_14136_((double)motionX, (double)motionZ) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)motionY, (double)horizontalMotionMagnitude) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        this.m_146922_((float)(Mth.m_14136_((double)motionX, (double)motionZ) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)motionY, (double)horizontalMotionMagnitude) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        this.prevGrowProgress = this.growProgress;
        this.growProgress = this.growProgress < 0.1f ? (this.growProgress += 0.025f) : (this.growProgress += 0.1f);
        if (this.f_19797_ > 40) {
            this.m_146870_();
        }
    }

    protected void m_20314_(double x, double y, double z) {
    }

    public void fireSonarWave(Thrasher thrasher) {
        float xMotion = -Mth.m_14031_((float)(thrasher.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(thrasher.m_146909_() * ((float)Math.PI / 180)));
        float yMotion = -Mth.m_14031_((float)(thrasher.m_146909_() * ((float)Math.PI / 180)));
        float zMotion = Mth.m_14089_((float)(thrasher.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(thrasher.m_146909_() * ((float)Math.PI / 180)));
        Vec3 motion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion).m_82541_().m_82490_(0.75);
        this.m_20256_(motion);
        this.setOwnerId(thrasher.m_19879_());
        this.m_6034_(thrasher.m_20185_() + (double)xMotion, thrasher.m_20186_(), thrasher.m_20189_() + (double)zMotion);
        float motionSqrt = Mth.m_14116_((float)((float)motion.m_165925_()));
        this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232));
        this.m_146922_((float)(Mth.m_14136_((double)motion.f_82480_, (double)motionSqrt) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void m_20321_(boolean downwards) {
    }

    public void m_6845_(boolean downwards) {
    }

    protected void m_5841_() {
    }

    public boolean m_6063_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrowProgress() {
        return Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)this.prevGrowProgress, (float)this.growProgress);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setOwnerId(compound.m_128451_("OwnerId"));
        this.growProgress = compound.m_128457_("GrowProgress");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("OwnerId", this.getOwnerId());
        compound.m_128350_("GrowProgress", this.growProgress);
    }

    public void setOwnerId(int id) {
        this.m_20088_().m_135381_(OWNER_ID, (Object)id);
    }

    public int getOwnerId() {
        return (Integer)this.m_20088_().m_135370_(OWNER_ID);
    }

    @Nullable
    public Thrasher getThrasherOwner() {
        Entity owner = this.m_9236_().m_6815_(this.getOwnerId());
        if (owner instanceof Thrasher) {
            return (Thrasher)owner;
        }
        return null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

