/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.util.JellyfishSizeMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class ColoredSizableJellyfish
extends AbstractJellyfish {
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ColoredSizableJellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(ColoredSizableJellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final JellyfishSizeMap NATURAL_SIZES = new JellyfishSizeMap(new TreeMap<Float, Integer>((Map<Float, Integer>)ImmutableMap.of((Object)Float.valueOf(0.5f), (Object)3, (Object)Float.valueOf(0.65f), (Object)3, (Object)Float.valueOf(1.0f), (Object)34)));

    public ColoredSizableJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(this.getDefaultSize()));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (SIZE.equals(key)) {
            this.m_6210_();
        }
    }

    @Override
    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.addAdditionalSaveDataSharedWithBucket(compoundTag);
        compoundTag.m_128405_("JellyColor", this.getColor());
        compoundTag.m_128350_("Size", this.getSize());
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.readAdditionalSaveDataSharedWithBucket(compoundTag);
        this.setColor(compoundTag.m_128451_("JellyColor"));
        this.setSize(compoundTag.m_128457_("Size"), false);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        boolean updateSize = false;
        RandomSource rand = this.m_217043_();
        int color = rand.m_188503_(3);
        float size = this.getNaturalSizeMap().randomSize(rand);
        boolean fromBucket = this.m_27487_();
        if (dataTag == null || !fromBucket) {
            if (spawnDataIn instanceof SpawnData) {
                size = ((SpawnData)spawnDataIn).size;
                color = ((SpawnData)spawnDataIn).color;
            } else if (!fromBucket) {
                spawnDataIn = new SpawnData(size, color);
                updateSize = true;
            }
        }
        this.setSize(size, updateSize);
        this.setColor(color);
        return spawnDataIn;
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public JellyfishSizeMap getNaturalSizeMap() {
        return NATURAL_SIZES;
    }

    public void setSize(float size, boolean updateHealth) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(this.getHealthSizeMultiplier() * size));
        if (updateHealth) {
            this.m_21153_(this.m_21233_());
        }
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    protected abstract float getDefaultSize();

    protected abstract float getHealthSizeMultiplier();

    static class SpawnData
    implements SpawnGroupData {
        private final float size;
        private final int color;

        private SpawnData(float size, int color) {
            this.size = size;
            this.color = color;
        }
    }
}

