/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.CassiopeaHideInSeagrassGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.CassiopeaJellyfishFlipGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.JellyfishRandomSwimmingGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.ColoredSizableJellyfish;
import com.teamabnormals.upgrade_aquatic.core.other.UADamageTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;

public class CassiopeaJellyfish
extends ColoredSizableJellyfish {
    public int upsideDownCooldown;
    public int hideCooldown;

    public CassiopeaJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractJellyfish.createAttributes().m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CassiopeaHideInSeagrassGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CassiopeaJellyfishFlipGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new JellyfishRandomSwimmingGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasUpsideDownCooldown()) {
            --this.upsideDownCooldown;
        }
        if (this.hasHideCooldown()) {
            --this.hideCooldown;
        }
    }

    @Override
    public void addAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.addAdditionalSaveDataSharedWithBucket(compoundTag);
        compoundTag.m_128405_("UpsideDownCooldown", this.upsideDownCooldown);
        compoundTag.m_128405_("HideCooldown", this.hideCooldown);
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.readAdditionalSaveDataSharedWithBucket(compoundTag);
        this.upsideDownCooldown = compoundTag.m_128451_("UpsideDownCooldown");
        this.hideCooldown = compoundTag.m_128451_("HideCooldown");
    }

    public boolean hasUpsideDownCooldown() {
        return this.upsideDownCooldown > 0;
    }

    public boolean hasHideCooldown() {
        return this.hideCooldown > 0;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getSize());
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public int m_5792_() {
        return 3;
    }

    public String getVariantName() {
        return switch (this.getColor()) {
            default -> "cassiopea";
            case 1 -> "blue_cassiopea";
            case 2 -> "white_cassiopea";
        };
    }

    @Override
    public AbstractJellyfish.BucketDisplayInfo getBucketDisplayInfo() {
        JellyTorchBlock.JellyTorchType jellyTorchType = this.getJellyTorchType();
        return this.bucketDisplayInfo(this.getVariantName(), jellyTorchType.ordinal(), jellyTorchType);
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return switch (this.getColor()) {
            default -> JellyTorchBlock.JellyTorchType.GREEN;
            case 1 -> JellyTorchBlock.JellyTorchType.BLUE;
            case 2 -> JellyTorchBlock.JellyTorchType.WHITE;
        };
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() < 1.0f ? 0.9f : 0.8f;
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if ((this.m_5448_() == livingEntity || this.m_21188_() == livingEntity) && this.m_217043_().m_188501_() < 0.5f) {
            return livingEntity.m_6469_(UADamageTypes.jellyfishSting(this.m_9236_(), (Entity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        }
        return false;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 6.0f;
    }

    @Override
    protected float getDefaultSize() {
        return 0.85f;
    }
}

