/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.blueprint.common.entity.ai.PredicateAttackGoal;
import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.JellyfishRandomSwimmingGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.ColoredSizableJellyfish;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BoxJellyfish
extends ColoredSizableJellyfish {
    private int huntingCooldown;

    public BoxJellyfish(EntityType<? extends BoxJellyfish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractJellyfish.createAttributes().m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 4.0, true){

            public void m_8041_() {
                super.m_8041_();
                if (this.f_25540_.m_5448_() == null) {
                    ((BoxJellyfish)this.f_25540_).setHuntingCooldown();
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new JellyfishRandomSwimmingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new PredicateAttackGoal((Mob)this, AbstractFish.class, 150, true, true, null, owner -> !((BoxJellyfish)((Object)owner)).hasCooldown() && !((BoxJellyfish)((Object)owner)).hasHuntingCooldown()));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasHuntingCooldown()) {
            --this.huntingCooldown;
        }
    }

    @Override
    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.addAdditionalSaveDataSharedWithBucket(compoundTag);
        compoundTag.m_128405_("HuntingCooldown", this.huntingCooldown);
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        super.readAdditionalSaveDataSharedWithBucket(compoundTag);
        this.huntingCooldown = compoundTag.m_128451_("HuntingCooldown");
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getSize());
    }

    public void setHuntingCooldown() {
        this.huntingCooldown = this.m_217043_().m_188503_(1600) + 1200;
    }

    public boolean hasHuntingCooldown() {
        return this.huntingCooldown > 0;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            Entity entity = source.m_7639_();
            if (!(!(entity instanceof LivingEntity) || this.m_5448_() != null || entity.m_5833_() || entity instanceof Player && ((Player)entity).m_7500_())) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    public String getVariantName() {
        return switch (this.getColor()) {
            default -> "box";
            case 1 -> "red_box";
            case 2 -> "white_box";
        };
    }

    @Override
    public AbstractJellyfish.BucketDisplayInfo getBucketDisplayInfo() {
        JellyTorchBlock.JellyTorchType jellyTorchType = this.getJellyTorchType();
        return this.bucketDisplayInfo(this.getVariantName(), jellyTorchType.ordinal(), jellyTorchType);
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return switch (this.getColor()) {
            default -> JellyTorchBlock.JellyTorchType.BLUE;
            case 1 -> JellyTorchBlock.JellyTorchType.RED;
            case 2 -> JellyTorchBlock.JellyTorchType.WHITE;
        };
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() >= 1.0f ? 0.05f : (this.getSize() < 0.5f ? 0.1f : 0.15f);
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if (super.stingEntity(livingEntity)) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 1));
            if (this.m_5448_() == null) {
                this.m_6710_(livingEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    protected float getDefaultSize() {
        return 1.0f;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 8.0f;
    }

    public int m_5792_() {
        return 3;
    }
}

