/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.item.BeholderEyeEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BeholderSyncMessage {
    public int beholderId;
    public boolean active;

    public BeholderSyncMessage(int beholderId, boolean active) {
        this.beholderId = beholderId;
        this.active = active;
    }

    public BeholderSyncMessage() {
    }

    public static BeholderSyncMessage read(FriendlyByteBuf buf) {
        return new BeholderSyncMessage(buf.readInt(), buf.readBoolean());
    }

    public static void write(BeholderSyncMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.beholderId);
        buf.writeBoolean(message.active);
    }

    public static void handle(BeholderSyncMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerLevel serverLevel;
            Entity watcher;
            ServerPlayer playerSided = ((NetworkEvent.Context)context.get()).getSender();
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                playerSided = AlexsCaves.PROXY.getClientSidePlayer();
            }
            if ((watcher = (serverLevel = ServerLifecycleHooks.getCurrentServer().m_129880_(playerSided.m_9236_().m_46472_())).m_6815_(message.beholderId)) instanceof BeholderEyeEntity) {
                BeholderEyeEntity beholderEye = (BeholderEyeEntity)watcher;
                Entity beholderEyePlayer = beholderEye.getUsingPlayer();
                beholderEye.hasTakenFullControlOfCamera = true;
                if (beholderEyePlayer != null && beholderEyePlayer instanceof Player && beholderEyePlayer.equals((Object)playerSided)) {
                    if (message.active) {
                        AlexsCaves.PROXY.setRenderViewEntity((Player)playerSided, beholderEye);
                    } else {
                        AlexsCaves.PROXY.resetRenderViewEntity((Player)playerSided);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

