/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class FerrouslimeEntity
extends Monster {
    private Map<Integer, Vec3> headOffsets = new HashMap<Integer, Vec3>();
    public float prevHeadCount = 1.0f;
    private float prevMergeProgress;
    private float mergeProgress;
    private float prevAttackProgress;
    private float attackProgress;
    private static final EntityDataAccessor<Integer> HEADS = SynchedEntityData.m_135353_(FerrouslimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(FerrouslimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int mergeCooldown = 0;
    private int noMoveTime = 0;

    public FerrouslimeEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 1;
        this.f_21342_ = new MoveController();
        this.prevMergeProgress = 5.0f;
        this.mergeProgress = 5.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new FormGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEADS, (Object)1);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, 10.0);
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_7625_(DamageSource source, boolean b) {
        if (this.getHeadCount() <= 1) {
            super.m_7625_(source, b);
        }
    }

    public boolean isFakeEntity() {
        return this.f_19803_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_5616_(this.m_146908_());
        this.prevMergeProgress = this.mergeProgress;
        this.prevAttackProgress = this.attackProgress;
        if (this.prevHeadCount != (float)this.getHeadCount()) {
            this.m_6210_();
            if (this.mergeProgress < 5.0f) {
                this.mergeProgress += 1.0f;
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)Mth.m_14045_((int)(this.getHeadCount() * 10), (int)10, (int)100));
                this.m_21051_(Attributes.f_22281_).m_22100_((double)Mth.m_14045_((int)(this.getHeadCount() * 2), (int)2, (int)10));
                double d = this.m_21051_(Attributes.f_22276_).m_22135_();
                if ((double)this.m_21223_() < d && this.getHeadCount() > 0) {
                    this.m_5634_((float)Math.ceil(d - (double)this.m_21223_()));
                }
                this.prevHeadCount = this.getHeadCount();
            }
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else {
            LivingEntity target = this.m_5448_();
            if (this.attackProgress >= 3.0f && target != null && this.m_20270_((Entity)target) < this.getSlimeSize(1.0f)) {
                target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f + (float)(this.getHeadCount() * 2));
            }
            if (this.attackProgress > 0.0f) {
                this.attackProgress -= 1.0f;
            }
        }
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            float slimeSize = this.getSlimeSize(1.0f);
            int i = 0;
            while ((double)i < Math.ceil(slimeSize)) {
                double particleX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)(slimeSize + 1.5f);
                double particleY = this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * (double)(slimeSize + 1.5f);
                double particleZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)(slimeSize + 1.5f);
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.FERROUSLIME.get(), particleX, particleY, particleZ, (double)this.m_19879_(), 0.0, 0.0);
                ++i;
            }
            AlexsCaves.PROXY.playWorldSound((Object)this, (byte)13);
        } else {
            LivingEntity living = this.m_5448_();
            if (living != null && living.m_6084_()) {
                this.noMoveTime = this.m_20184_().m_82553_() < 0.1 ? ++this.noMoveTime : 0;
                if (this.noMoveTime > 40 && this.mergeCooldown <= 0) {
                    this.split(1200);
                }
            }
        }
        if (this.mergeCooldown > 0) {
            --this.mergeCooldown;
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        if (this.getHeadCount() >= 2 && this.m_21224_()) {
            int ours = this.getHeadCount() / 2;
            int theirs = this.getHeadCount() - ours;
            this.mergeCooldown = 1200;
            this.m_9236_().m_7967_((Entity)this.makeSlime(ours, 1200));
            this.m_9236_().m_7967_((Entity)this.makeSlime(theirs, 1200));
        }
        super.m_142687_(removalReason);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    protected float m_6431_(Pose p_33614_, EntityDimensions dimensions) {
        return 0.625f * dimensions.f_20378_;
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (HEADS.equals(entityDataAccessor)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            this.mergeProgress = 0.0f;
        }
    }

    public int getHeadCount() {
        return (Integer)this.f_19804_.m_135370_(HEADS);
    }

    public void setHeadCount(int headCount) {
        this.f_19804_.m_135381_(HEADS, (Object)headCount);
    }

    public float getMergeProgress(float partialTick) {
        return (this.prevMergeProgress + (this.mergeProgress - this.prevMergeProgress) * partialTick) * 0.2f;
    }

    protected PathNavigation m_6037_(Level level) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, level, AdvancedPathNavigate.MovementType.FLYING);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return this.m_9236_().m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public Vec3 getHeadOffsetPos(int i) {
        if (i <= 1) {
            return Vec3.f_82478_;
        }
        if (this.headOffsets.containsKey(i)) {
            return this.headOffsets.get(i);
        }
        Vec3 vec = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)(this.getSlimeSize(1.0f) * 0.5f));
        this.headOffsets.put(i, vec);
        return vec;
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(this.getSlimeSize(1.0f));
    }

    public float getSlimeSize(float partialTicks) {
        float smoothHeadCount = (float)(this.getHeadCount() - 1) + this.getMergeProgress(partialTicks);
        return Math.min((float)(Math.log(smoothHeadCount) + 1.0) * 1.2f, 3.2f);
    }

    public boolean split(int cooldown) {
        if (this.getHeadCount() >= 2) {
            int ours = this.getHeadCount() / 2;
            int theirs = this.getHeadCount() - ours;
            this.mergeCooldown = 1200;
            this.m_9236_().m_7967_((Entity)this.makeSlime(ours, 1200));
            this.m_9236_().m_7967_((Entity)this.makeSlime(theirs, 1200));
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    private FerrouslimeEntity makeSlime(int heads, int cooldown) {
        Component component = this.m_7770_();
        FerrouslimeEntity ferrouslime = (FerrouslimeEntity)((EntityType)ACEntityRegistry.FERROUSLIME.get()).m_20615_(this.m_9236_());
        ferrouslime.m_146884_(this.m_20182_());
        ferrouslime.setHeadCount(heads);
        ferrouslime.m_6593_(component);
        ferrouslime.m_21557_(this.m_21525_());
        ferrouslime.m_20331_(this.m_20147_());
        ferrouslime.mergeCooldown = cooldown;
        ferrouslime.m_146922_(this.f_20885_);
        ferrouslime.f_20883_ = this.f_20885_;
        return ferrouslime;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setHeadCount(1 + this.f_19796_.m_188503_(2));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean canCutCorner(BlockPathTypes types) {
        return true;
    }

    public float getAttackProgress(float partialTicks) {
        return (this.prevAttackProgress + (this.attackProgress - this.prevAttackProgress) * partialTicks) * 0.2f;
    }

    public boolean m_7327_(Entity entityIn) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)10);
        return super.m_7327_(entityIn);
    }

    private boolean canForm() {
        return this.m_6084_() && this.mergeCooldown <= 0;
    }

    public int m_213860_() {
        return 2;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.FERROUSLIME_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.FERROUSLIME_DEATH.get();
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;
        private Direction lastSlideDirection;
        private int slideStop;
        private int slideFor;

        public MoveController() {
            super((Mob)FerrouslimeEntity.this);
            this.slideStop = 0;
            this.slideFor = 0;
            this.parentEntity = FerrouslimeEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                BlockPos centerPos;
                BlockPos target = BlockPos.m_274561_((double)this.f_24975_, (double)this.f_24976_, (double)this.f_24977_);
                BlockPos closest = centerPos = BlockPos.m_274561_((double)this.parentEntity.m_20185_(), (double)this.parentEntity.m_20227_(0.5), (double)this.parentEntity.m_20189_());
                if (this.slideStop <= 0) {
                    this.lastSlideDirection = null;
                    for (Direction direction : Direction.values()) {
                        BlockPos check = centerPos.m_121945_(direction);
                        if (!(check.m_123331_((Vec3i)target) < closest.m_123331_((Vec3i)target)) || !FerrouslimeEntity.this.m_9236_().m_8055_(check).m_60795_()) continue;
                        this.lastSlideDirection = direction;
                    }
                    this.slideStop = 6;
                } else {
                    --this.slideStop;
                }
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                if (this.lastSlideDirection != null && !this.parentEntity.f_19862_) {
                    vector3d = vector3d.m_82542_((double)Math.abs(this.lastSlideDirection.m_122429_()), (double)Math.abs(this.lastSlideDirection.m_122430_()), (double)Math.abs(this.lastSlideDirection.m_122431_()));
                }
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                LivingEntity attackTarget = this.parentEntity.m_5448_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.25 / d0);
                if (d0 < 0.5) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else {
                    this.parentEntity.m_20256_(vector3d1);
                    if (d0 >= width && attackTarget == null) {
                        this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                        if (FerrouslimeEntity.this.m_5448_() != null) {
                            this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                        }
                    }
                }
            }
        }
    }

    private class MeleeGoal
    extends Goal {
        private int cooldown = 0;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FerrouslimeEntity.this.m_5448_() != null && FerrouslimeEntity.this.m_5448_().m_6084_();
        }

        public void m_8037_() {
            LivingEntity target = FerrouslimeEntity.this.m_5448_();
            if (target != null && target.m_6084_()) {
                FerrouslimeEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                FerrouslimeEntity.this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                if (FerrouslimeEntity.this.m_20270_((Entity)target) < 1.0f + FerrouslimeEntity.this.getSlimeSize(1.0f) && FerrouslimeEntity.this.m_142582_((Entity)target) && this.cooldown == 0) {
                    FerrouslimeEntity.this.m_7327_((Entity)target);
                    this.cooldown = 10;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        public void m_8041_() {
            this.cooldown = 0;
        }
    }

    private class FormGoal
    extends Goal {
        int executionCooldown = 0;
        FerrouslimeEntity otherslime;

        public FormGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!FerrouslimeEntity.this.canForm()) {
                return false;
            }
            if (this.executionCooldown-- < 0) {
                this.executionCooldown = FerrouslimeEntity.this.m_5448_() == null ? 100 : 20;
                FerrouslimeEntity closest = null;
                for (FerrouslimeEntity slime : FerrouslimeEntity.this.m_9236_().m_45976_(FerrouslimeEntity.class, FerrouslimeEntity.this.m_20191_().m_82377_(30.0, 30.0, 30.0))) {
                    if (slime == FerrouslimeEntity.this || !slime.canForm() || closest != null && !(slime.m_20270_((Entity)FerrouslimeEntity.this) < closest.m_20270_((Entity)FerrouslimeEntity.this))) continue;
                    closest = slime;
                }
                this.otherslime = closest;
                return this.otherslime != null;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.otherslime != null && FerrouslimeEntity.this.canForm() && this.otherslime.canForm() && FerrouslimeEntity.this.m_20270_((Entity)this.otherslime) < 32.0f;
        }

        public void m_8037_() {
            FerrouslimeEntity.this.m_21573_().m_5624_((Entity)this.otherslime, 1.0);
            if ((double)FerrouslimeEntity.this.m_20270_((Entity)this.otherslime) <= 0.5 + (double)(FerrouslimeEntity.this.m_20205_() + this.otherslime.m_20205_()) / 2.0 && this.otherslime.canForm()) {
                FerrouslimeEntity.this.setHeadCount(FerrouslimeEntity.this.getHeadCount() + this.otherslime.getHeadCount());
                this.otherslime.m_142687_(Entity.RemovalReason.DISCARDED);
                FerrouslimeEntity.this.m_216990_((SoundEvent)ACSoundRegistry.FERROUSLIME_COMBINE.get());
                this.otherslime = null;
                FerrouslimeEntity.this.mergeCooldown = 600;
            }
        }
    }
}

