/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.NuclearSirenBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.util.ActivatesSirens;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class NuclearSirenBlockEntity
extends BlockEntity {
    private float volumeProgress;
    private float prevVolumeProgress;
    public int age;
    private Entity nearestNuclearBomb = null;
    private BlockPos nearestMeltdownFurnace = null;
    private int bombId = -1;
    private boolean wasPowered;

    public NuclearSirenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.NUCLEAR_SIREN.get(), pos, state);
        if (((Boolean)state.m_61143_((Property)NuclearSirenBlock.POWERED)).booleanValue()) {
            this.volumeProgress = 10.0f;
            this.prevVolumeProgress = 10.0f;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, NuclearSirenBlockEntity entity) {
        entity.prevVolumeProgress = entity.volumeProgress;
        boolean powered = entity.isActivated(state);
        ++entity.age;
        if (entity.wasPowered != powered) {
            entity.wasPowered = powered;
            entity.m_6596_();
        }
        if (powered && entity.volumeProgress < 10.0f) {
            entity.volumeProgress += 0.5f;
        } else if (!powered && entity.volumeProgress > 0.0f) {
            entity.volumeProgress -= 0.5f;
        }
        if (powered && !entity.m_58901_()) {
            int j = entity.age % 18;
            if (level.f_46443_ && j >= 9 && j % 3 == 0) {
                level.m_220407_(GameEvent.f_223701_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
                Vec3 particlesFrom = blockPos.m_252807_().m_82520_(0.0, 0.2, 0.0);
                for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
                    Vec3 vec3 = particlesFrom.m_82520_((double)((float)direction.m_122429_() * 0.5f), 0.0, (double)((float)direction.m_122431_() * 0.5f));
                    float yRot = direction.m_122435_();
                    level.m_6485_((ParticleOptions)ACParticleRegistry.NUCLEAR_SIREN_SONAR.get(), true, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, (double)yRot, 0.0);
                }
            }
        }
        if (!level.f_46443_) {
            ActivatesSirens sirens;
            Entity pos;
            if (entity.nearestMeltdownFurnace == null || !entity.isTrackedFurnaceCritical()) {
                entity.nearestMeltdownFurnace = null;
                boolean flag = false;
                if (entity.age % 20 == 0 && level instanceof ServerLevel && (pos = (BlockPos)entity.getNearbyCriticalFurnaces((ServerLevel)level, 128).findAny().orElse(null)) != null && entity.nearestMeltdownFurnace == null) {
                    entity.nearestMeltdownFurnace = pos;
                    flag = true;
                }
                if (flag) {
                    level.m_7260_(entity.m_58899_(), entity.m_58900_(), entity.m_58900_(), 2);
                }
            }
            if (entity.nearestNuclearBomb == null || entity.nearestNuclearBomb.m_213877_() || (pos = entity.nearestNuclearBomb) instanceof ActivatesSirens && (sirens = (ActivatesSirens)pos).shouldStopBlaringSirens()) {
                entity.nearestNuclearBomb = null;
                int prevBombId = entity.bombId;
                entity.bombId = -1;
                if (prevBombId != entity.bombId) {
                    level.m_7260_(entity.m_58899_(), entity.m_58900_(), entity.m_58900_(), 2);
                }
            } else {
                int prevBombId = entity.bombId;
                int n = entity.bombId = entity.nearestNuclearBomb != null ? entity.nearestNuclearBomb.m_19879_() : -1;
                if (prevBombId != entity.bombId) {
                    level.m_7260_(entity.m_58899_(), entity.m_58900_(), entity.m_58900_(), 2);
                }
            }
        } else if (powered) {
            AlexsCaves.PROXY.playWorldSound((Object)entity, (byte)0);
        }
    }

    public boolean isTrackedFurnaceCritical() {
        BlockEntity blockEntity;
        if (this.nearestMeltdownFurnace != null && (blockEntity = this.f_58857_.m_7702_(this.nearestMeltdownFurnace)) instanceof NuclearFurnaceBlockEntity) {
            NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity;
            return nuclearFurnaceBlockEntity.getCriticality() >= 2;
        }
        return false;
    }

    public void setNearestNuclearBomb(Entity bomb) {
        Vec3 center = this.m_58899_().m_252807_();
        if (this.nearestNuclearBomb == null || this.nearestNuclearBomb.m_20238_(center) > bomb.m_20238_(center)) {
            this.nearestNuclearBomb = bomb;
        }
    }

    public boolean isActivated(BlockState state) {
        return state.m_60713_((Block)ACBlockRegistry.NUCLEAR_SIREN.get()) && (Boolean)state.m_61143_((Property)NuclearSirenBlock.POWERED) != false || this.bombId != -1 || this.isTrackedFurnaceCritical();
    }

    public float getVolume(float partialTicks) {
        return (this.prevVolumeProgress + (this.volumeProgress - this.prevVolumeProgress) * partialTicks) * 0.1f;
    }

    private Stream<BlockPos> getNearbyCriticalFurnaces(ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_FURNACE.getKey()), this::isCriticalFurnace, this.m_58899_(), range, PoiManager.Occupancy.ANY);
    }

    private boolean isCriticalFurnace(BlockPos pos) {
        NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity;
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        return blockEntity instanceof NuclearFurnaceBlockEntity && (nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity).getCriticality() >= 2;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bombId = tag.m_128451_("BombID");
        if (tag.m_128441_("NearestFurnaceX")) {
            this.nearestMeltdownFurnace = new BlockPos(tag.m_128451_("NearestFurnaceX"), tag.m_128451_("NearestFurnaceY"), tag.m_128451_("NearestFurnaceZ"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BombID", this.bombId);
        if (this.nearestMeltdownFurnace != null) {
            tag.m_128405_("NearestFurnaceX", this.nearestMeltdownFurnace.m_123341_());
            tag.m_128405_("NearestFurnaceY", this.nearestMeltdownFurnace.m_123342_());
            tag.m_128405_("NearestFurnaceZ", this.nearestMeltdownFurnace.m_123343_());
        }
    }

    public void m_7651_() {
        AlexsCaves.PROXY.clearSoundCacheFor(this);
        super.m_7651_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.bombId = packet.m_131708_().m_128451_("BombID");
            if (packet.m_131708_().m_128441_("NearestFurnaceX")) {
                this.nearestMeltdownFurnace = new BlockPos(packet.m_131708_().m_128451_("NearestFurnaceX"), packet.m_131708_().m_128451_("NearestFurnaceY"), packet.m_131708_().m_128451_("NearestFurnaceZ"));
            }
        }
    }
}

